/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.providers.decorators;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.decorators.AbstractSiriusDecorator;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.viewpoint.Decoration;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;
import org.eclipse.swt.graphics.Image;

public class DescribedDecorator
extends AbstractSiriusDecorator {
    public DescribedDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    @Override
    public void refresh() {
        DDiagramElement element;
        super.refresh();
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        int margin = -1;
        if (editPart instanceof GraphicalEditPart) {
            margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
        }
        if (editPart instanceof IDiagramElementEditPart && (element = ((IDiagramElementEditPart)editPart).resolveDiagramElement()) != null) {
            for (Decoration decoration : element.getDecorations()) {
                Image image = this.getImage(decoration);
                if (image == null) continue;
                this.addDecoration(this.getDecoratorTarget().addShapeDecoration(image, this.getPosition(decoration), margin, false));
            }
        }
    }

    private IDecoratorTarget.Direction getPosition(Decoration decoration) {
        IDecoratorTarget.Direction direction = IDecoratorTarget.Direction.SOUTH_WEST;
        if (decoration.getDescription() != null) {
            switch (decoration.getDescription().getPosition().getValue()) {
                case 8: {
                    direction = IDecoratorTarget.Direction.CENTER;
                    break;
                }
                case 0: {
                    direction = IDecoratorTarget.Direction.NORTH;
                    break;
                }
                case 2: {
                    direction = IDecoratorTarget.Direction.SOUTH;
                    break;
                }
                case 1: {
                    direction = IDecoratorTarget.Direction.WEST;
                    break;
                }
                case 3: {
                    direction = IDecoratorTarget.Direction.EAST;
                    break;
                }
                case 5: {
                    direction = IDecoratorTarget.Direction.NORTH_EAST;
                    break;
                }
                case 4: {
                    direction = IDecoratorTarget.Direction.NORTH_WEST;
                    break;
                }
                case 7: {
                    direction = IDecoratorTarget.Direction.SOUTH_EAST;
                    break;
                }
                case 6: {
                    direction = IDecoratorTarget.Direction.SOUTH_WEST;
                    break;
                }
            }
        }
        return direction;
    }

    private Image getImage(Decoration decoration) {
        DecorationDescription description = decoration.getDescription();
        if (description != null) {
            return WorkspaceImageFigure.getImageInstanceFromPath(description.getDecoratorPath());
        }
        return null;
    }

    @Override
    protected IDecoratorTarget.Direction getDirection(EditPart editPart) {
        return null;
    }

    @Override
    protected Image getDecorationImage(EditPart editPart) {
        return null;
    }
}

