/*******************************************************************************
 * Copyright (c) 2007-2013 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.sirius.tree.description.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.sirius.tree.description.DescriptionPackage;
import org.eclipse.sirius.tree.description.TreeMapping;
import org.eclipse.sirius.viewpoint.description.impl.RepresentationElementMappingImpl;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Tree Mapping</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>
 * {@link org.eclipse.sirius.tree.description.impl.TreeMappingImpl#getSemanticElements
 * <em>Semantic Elements</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TreeMappingImpl extends RepresentationElementMappingImpl implements TreeMapping {
    /**
     * The default value of the '{@link #getSemanticElements()
     * <em>Semantic Elements</em>}' attribute. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @see #getSemanticElements()
     * @generated
     * @ordered
     */
    protected static final String SEMANTIC_ELEMENTS_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSemanticElements()
     * <em>Semantic Elements</em>}' attribute. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @see #getSemanticElements()
     * @generated
     * @ordered
     */
    protected String semanticElements = TreeMappingImpl.SEMANTIC_ELEMENTS_EDEFAULT;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected TreeMappingImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return DescriptionPackage.Literals.TREE_MAPPING;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public String getSemanticElements() {
        return semanticElements;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setSemanticElements(String newSemanticElements) {
        String oldSemanticElements = semanticElements;
        semanticElements = newSemanticElements;
        if (eNotificationRequired()) {
            eNotify(new ENotificationImpl(this, Notification.SET, DescriptionPackage.TREE_MAPPING__SEMANTIC_ELEMENTS, oldSemanticElements, semanticElements));
        }
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
        case DescriptionPackage.TREE_MAPPING__SEMANTIC_ELEMENTS:
            return getSemanticElements();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
        case DescriptionPackage.TREE_MAPPING__SEMANTIC_ELEMENTS:
            setSemanticElements((String) newValue);
            return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
        case DescriptionPackage.TREE_MAPPING__SEMANTIC_ELEMENTS:
            setSemanticElements(TreeMappingImpl.SEMANTIC_ELEMENTS_EDEFAULT);
            return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
        case DescriptionPackage.TREE_MAPPING__SEMANTIC_ELEMENTS:
            return TreeMappingImpl.SEMANTIC_ELEMENTS_EDEFAULT == null ? semanticElements != null : !TreeMappingImpl.SEMANTIC_ELEMENTS_EDEFAULT.equals(semanticElements);
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public String toString() {
        if (eIsProxy()) {
            return super.toString();
        }

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (semanticElements: "); //$NON-NLS-1$
        result.append(semanticElements);
        result.append(')');
        return result.toString();
    }

} // TreeMappingImpl
