/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.command;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.helper.SelectionDescriptionHelper;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.selection.EMFMessageDialog;
import org.eclipse.sirius.common.ui.tools.api.selection.EObjectSelectionWizard;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.resource.LoadEMFResourceRunnableWithProgress;
import org.eclipse.sirius.ui.tools.api.Messages;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.selection.TypedVariableValueDialog;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.SelectionDescription;
import org.eclipse.sirius.viewpoint.description.TypedVariable;
import org.eclipse.sirius.viewpoint.description.tool.SelectModelElementVariable;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSWTCallback
implements UICallBack {
    public Collection<EObject> askForVariableValues(EObject model, SelectModelElementVariable variable) throws InterruptedException {
        BasicEList variableValues = new ArrayList();
        TreeItemWrapper input = new TreeItemWrapper(null, null);
        this.computeInput(model, variable, input);
        EObjectSelectionWizard wizard = new EObjectSelectionWizard(EObjectSelectionWizard.WIZARD_GENERIC_DIALOG_TITLE, variable.getMessage(), null, input, ViewHelper.INSTANCE.createAdapterFactory());
        wizard.setMany(variable.isMultiple());
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            if (!variable.isMultiple() && wizard.getSelectedEObject() != null) {
                variableValues.add(wizard.getSelectedEObject());
            } else {
                BasicEList value = new BasicEList();
                value.addAll(wizard.getSelectedEObjects());
                variableValues = value;
            }
        } else {
            throw new InterruptedException();
        }
        return variableValues;
    }

    private void computeInput(EObject model, SelectModelElementVariable variable, TreeItemWrapper input) {
        if (model != null) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(model);
            if (variable.getCandidatesExpression() != null) {
                DRepresentation representation = model instanceof DRepresentationElement ? SiriusUtil.findRepresentation((DRepresentationElement)((DRepresentationElement)model)) : null;
                interpreter.setVariable(this.getVariableNameForRepresentation(), (Object)representation);
                SelectionDescriptionHelper.computeInput((SelectionDescription)variable, (EObject)model, (IInterpreter)interpreter, (TreeItemWrapper)input);
                interpreter.unSetVariable(this.getVariableNameForRepresentation());
            }
        }
    }

    protected abstract String getVariableNameForRepresentation();

    public String askForDetailName(String defaultName) throws InterruptedException {
        return this.askForDetailName(defaultName, null);
    }

    @Deprecated
    public String askForDetailName(String defaultName, String representationDescriptionDoc) throws InterruptedException {
        return this.askForDetailName(defaultName, Messages.createRepresentationInputDialog_DefaultRepresentationDescName, representationDescriptionDoc);
    }

    public String askForDetailName(String defaultName, String representationDescriptionName, String representationDescriptionDoc) throws InterruptedException {
        String description = null;
        if (representationDescriptionDoc != null && representationDescriptionDoc.trim().length() > 0) {
            description = MessageFormat.format(Messages.createRepresentationInputDialog_RepresentationDescriptionLabel, representationDescriptionDoc);
        }
        description = description == null ? "" : String.valueOf(description) + "\n\n";
        description = String.valueOf(description) + Messages.createRepresentationInputDialog_NewRepresentationNameLabel;
        InputDialog askSiriusName = new InputDialog(Display.getDefault().getActiveShell(), MessageFormat.format(Messages.createRepresentationInputDialog_Title, representationDescriptionName), description, defaultName, new IInputValidator(){

            public String isValid(String newText) {
                return null;
            }
        });
        if (askSiriusName.open() == 0) {
            return askSiriusName.getValue();
        }
        throw new InterruptedException(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_askForDetailName_canceled);
    }

    public boolean openEObjectsDialogMessage(Collection<EObject> objects, String title, String message) {
        return EMFMessageDialog.openQuestionWithEObjects((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (AdapterFactory)ViewHelper.INSTANCE.createAdapterFactory(), objects, (String)title, (String)message);
    }

    public void openRepresentation(final Session openedSession, final DRepresentation representation) {
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DialectUIManager.INSTANCE.openEditor(openedSession, representation, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public Resource loadResource(EditingDomain domain, IFile file) {
        LoadEMFResourceRunnableWithProgress operation = new LoadEMFResourceRunnableWithProgress(domain.getResourceSet(), file);
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            SiriusTransPlugin.INSTANCE.error(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_loadResourceError, (Throwable)e);
        }
        catch (InterruptedException e) {
            SiriusTransPlugin.INSTANCE.error(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_loadResourceError, (Throwable)e);
        }
        return operation.getLoadedResource();
    }

    public Collection<EObject> askForEObjects(String message, TreeItemWrapper input, AdapterFactory factory) throws InterruptedException {
        EObjectSelectionWizard wizard = new EObjectSelectionWizard(EObjectSelectionWizard.WIZARD_GENERIC_DIALOG_TITLE, message, null, input, factory);
        wizard.setMany(true);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSelectedEObjects();
        }
        throw new InterruptedException();
    }

    public EObject askForEObject(String message, TreeItemWrapper input, AdapterFactory factory) throws InterruptedException {
        EObjectSelectionWizard wizard = new EObjectSelectionWizard(EObjectSelectionWizard.WIZARD_GENERIC_DIALOG_TITLE, message, null, input, factory);
        wizard.setMany(false);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSelectedEObject();
        }
        throw new InterruptedException();
    }

    public List<String> askForTypedVariable(List<TypedVariable> typedVariableList, List<String> defaultValues) throws InterruptedException {
        TypedVariableValueDialog dialog = new TypedVariableValueDialog(typedVariableList, defaultValues, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        int result = dialog.open();
        if (result == 0) {
            return dialog.getValues();
        }
        throw new InterruptedException();
    }

    public boolean shouldReload(Resource resource) {
        return this.openQuestion(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_shouldReload_title, MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_shouldReload_message, resource.getURI()));
    }

    public boolean shouldRemove(Resource resource) {
        return this.openQuestion(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_shouldRemove_title, MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_shouldRemove_message, resource.getURI()));
    }

    public boolean shouldClose(Session session, Resource resource) {
        return this.openQuestion(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_shouldClose_title, MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_shouldClose_message, resource.getURI()));
    }

    private boolean openQuestion(final String title, final String message) {
        if (this.inUIThread()) {
            return MessageDialog.openQuestion((Shell)this.getActiveShell(), (String)title, (String)message);
        }
        RunnableWithResult.Impl<Boolean> reload = new RunnableWithResult.Impl<Boolean>(){

            public void run() {
                this.setResult(MessageDialog.openQuestion((Shell)AbstractSWTCallback.this.getActiveShell(), (String)title, (String)message));
            }
        };
        EclipseUIUtil.displaySyncExec((Runnable)reload);
        return (Boolean)reload.getResult();
    }

    public String getSessionNameToDisplayWhileSaving(Session session) {
        String result = "";
        if (session != null) {
            boolean inProject;
            String location;
            String projectName = null;
            Resource representationsFileResource = session.getSessionResource();
            URI representationsFileURI = representationsFileResource.getURI();
            if (representationsFileURI.segments().length > 1) {
                projectName = representationsFileURI.segment(1);
            }
            URIQuery uriQuery = new URIQuery(representationsFileURI);
            if (projectName != null) {
                location = projectName;
                inProject = true;
            } else {
                location = uriQuery.isInMemoryURI() ? uriQuery.toPlatformString() : representationsFileURI.toString();
                inProject = false;
            }
            result = ResourceSetSync.getStatus((Resource)representationsFileResource).equals((Object)ResourceSetSync.ResourceStatus.SYNC) ? (inProject ? MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_modelsInProject, location) : MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_models, location)) : (this.semanticResourcesDirty(session) ? (inProject ? MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_modelsAndRepresentationsInProject, location) : MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_modelsAndRepresentations, location)) : (inProject ? MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_representationsInProject, location) : MessageFormat.format(org.eclipse.sirius.viewpoint.provider.Messages.AbstractSWTCallback_representations, location)));
        }
        return result;
    }

    private boolean semanticResourcesDirty(Session session) {
        for (Resource semanticResource : this.getAllSemanticResources(session)) {
            if (ResourceSetSync.getStatus((Resource)semanticResource).equals((Object)ResourceSetSync.ResourceStatus.SYNC)) continue;
            return true;
        }
        return false;
    }

    private Iterable<Resource> getAllSemanticResources(Session session) {
        if (session instanceof DAnalysisSessionEObject) {
            return Iterables.concat((Iterable)session.getSemanticResources(), (Iterable)((DAnalysisSessionEObject)session).getControlledResources());
        }
        return session.getSemanticResources();
    }

    private boolean inUIThread() {
        return Display.getCurrent() != null;
    }

    private Shell getActiveShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void openError(String title, String message) {
        if (this.inUIThread()) {
            MessageDialog.openError((Shell)this.getActiveShell(), (String)title, (String)message);
        }
    }
}

