/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFCheckboxDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFCheckboxController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFCheckboxController
extends AbstractEEFWidgetController
implements IEEFCheckboxController {
    private EEFCheckboxDescription description;
    private EditingContextAdapter contextAdapter;
    private IConsumer<Boolean> newValueConsumer;

    public EEFCheckboxController(EEFCheckboxDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public IStatus updateValue(final boolean checkbox) {
        return this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String editExpression = EEFCheckboxController.this.description.getEditExpression();
                EAttribute eAttribute = EefPackage.Literals.EEF_CHECKBOX_DESCRIPTION__EDIT_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFCheckboxController.this.variableManager.getVariables());
                variables.put("newValue", checkbox);
                EvalFactory.of(EEFCheckboxController.this.interpreter, variables).logIfBlank(eAttribute).call(editExpression);
            }
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        this.newEval().logIfInvalidType(Boolean.class).call(valueExpression, this.newValueConsumer);
    }

    @Override
    public void onNewValue(IConsumer<Boolean> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }
}

