/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFRadioDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFRadioController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFRadioController
extends AbstractEEFWidgetController
implements IEEFRadioController {
    private EEFRadioDescription description;
    private EditingContextAdapter contextAdapter;
    private IConsumer<Object> newValueConsumer;
    private IConsumer<List<Object>> newCandidatesConsumer;

    public EEFRadioController(EEFRadioDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public IStatus updateValue(final Object text) {
        return this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String editExpression = EEFRadioController.this.description.getEditExpression();
                EAttribute eAttribute = EefPackage.Literals.EEF_RADIO_DESCRIPTION__EDIT_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFRadioController.this.variableManager.getVariables());
                variables.put("newValue", text);
                EvalFactory.of(EEFRadioController.this.interpreter, variables).logIfBlank(eAttribute).call(editExpression);
            }
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        String candidatesExpression = this.description.getCandidatesExpression();
        EAttribute candidatesExpressionEAttribute = EefPackage.Literals.EEF_RADIO_DESCRIPTION__CANDIDATES_EXPRESSION;
        this.newEval().logIfBlank(candidatesExpressionEAttribute).call(candidatesExpression, new IConsumer<Object>(){

            @Override
            public void apply(Object value) {
                if (value instanceof Iterable) {
                    ArrayList candidates = new ArrayList();
                    for (Object iterator : (Iterable)value) {
                        candidates.add(iterator);
                    }
                    EEFRadioController.this.newCandidatesConsumer.apply(candidates);
                }
            }
        });
        String valueExpression = this.description.getValueExpression();
        this.newEval().call(valueExpression, this.newValueConsumer);
    }

    @Override
    public void onNewValue(IConsumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void onNewCandidates(IConsumer<List<Object>> consumer) {
        this.newCandidatesConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    public void removeNewCandidatesConsumer() {
        this.newCandidatesConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }
}

