/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFTextController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFTextController
extends AbstractEEFWidgetController
implements IEEFTextController {
    private EEFTextDescription description;
    private EditingContextAdapter contextAdapter;
    private IConsumer<Object> newValueConsumer;

    public EEFTextController(EEFTextDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter);
        this.description = description;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public IStatus updateValue(final String text) {
        return this.contextAdapter.performModelChange(new Runnable(){

            @Override
            public void run() {
                String editExpression = EEFTextController.this.description.getEditExpression();
                EAttribute eAttribute = EefPackage.Literals.EEF_TEXT_DESCRIPTION__EDIT_EXPRESSION;
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.putAll(EEFTextController.this.variableManager.getVariables());
                variables.put("newValue", text);
                EvalFactory.of(EEFTextController.this.interpreter, variables).logIfBlank(eAttribute).call(editExpression);
            }
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        this.newEval().call(valueExpression, this.newValueConsumer);
    }

    @Override
    public void onNewValue(IConsumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }
}

