/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.visitor.MappingsHierarchyVisitor;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;

public class DiagramDescriptionMappingManagerQuery {
    private DiagramDescriptionMappingsManager manager;

    public DiagramDescriptionMappingManagerQuery(DiagramDescriptionMappingsManager manager) {
        this.manager = manager;
    }

    public Set<DiagramElementMapping> computeAllMappings() {
        LinkedHashSet<DiagramElementMapping> allMappings = new LinkedHashSet<DiagramElementMapping>();
        this.computeAllMappings(allMappings, this.manager.getContainerMappings());
        this.computeAllMappings(allMappings, this.manager.getNodeMappings());
        this.computeAllMappings(allMappings, this.manager.getEdgeMappings());
        return allMappings;
    }

    private void computeAllMappings(Collection<DiagramElementMapping> allMappings, Collection<? extends DiagramElementMapping> mappings) {
        MappingsHierarchyVisitor visitor = new MappingsHierarchyVisitor();
        for (DiagramElementMapping diagramElementMapping : mappings) {
            if (allMappings.contains(diagramElementMapping)) continue;
            allMappings.add(diagramElementMapping);
            this.computeAllMappings(allMappings, visitor.getChildren(diagramElementMapping));
        }
    }
}

