/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.eclipse.sirius.properties.impl.EditSupportImpl;
import org.eclipse.sirius.ui.properties.api.preferences.SiriusPropertiesViewPreferencesKeys;
import org.eclipse.sirius.ui.properties.internal.Messages;
import org.eclipse.sirius.ui.properties.internal.SiriusContext;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;

public class EditSupportSpec
extends EditSupportImpl {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String INT = "int";
    private static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    private static final String DOUBLE = "double";
    private static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    private static final String CHAR = "char";
    private static final String JAVA_LANG_CHARACTER = "java.lang.Character";
    private static final String SHORT = "short";
    private static final String JAVA_LANG_SHORT = "java.lang.Short";
    private static final String LONG = "long";
    private static final String JAVA_LANG_LONG = "java.lang.Long";
    private static final String FLOAT = "float";
    private static final String JAVA_LANG_FLOAT = "java.lang.Float";
    private static final String JAVA_UTIL_DATE = "java.util.Date";
    private static final String BOOLEAN = "boolean";
    private static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";
    private final EditingDomainServices editServices = new EditingDomainServices();
    private final SiriusContext context;
    private final Object self;

    public EditSupportSpec(SiriusContext ctx, Object target) {
        this.context = ctx;
        this.self = target;
    }

    private EObject getTargetEObject() {
        EObject result = null;
        if (this.self instanceof EObject) {
            result = (EObject)this.self;
        }
        return result;
    }

    public Object getImage() {
        EObject target = this.getTargetEObject();
        if (target != null) {
            return this.editServices.getLabelProviderImage(target);
        }
        return null;
    }

    public String getText() {
        EObject target = this.getTargetEObject();
        if (target != null) {
            return this.editServices.getLabelProviderText(target);
        }
        return String.valueOf(this.self);
    }

    public Object getText(EStructuralFeature feature) {
        EObject target = this.getTargetEObject();
        if (target != null) {
            String result = this.editServices.getPropertyDescriptorDisplayName(target, feature.getName());
            if (Util.isBlank((String)result)) {
                result = this.editServices.getLabelProviderText((EObject)feature);
            }
            if (Util.isBlank((String)result)) {
                result = feature.getName();
            }
            return result;
        }
        return "";
    }

    public String getTabName() {
        Option<EObject> mainSemanticElement;
        EObject target = this.getTargetEObject();
        String result = target != null ? ((mainSemanticElement = this.context.getMainSemanticElement()).some() && ((EObject)mainSemanticElement.get()).equals(target) ? Messages.SiriusToolServices_MainTabLabel : this.editServices.getLabelProviderText(target)) : String.valueOf(target);
        return this.elide(result, SiriusUIPropertiesPlugin.getPlugin().getPreferenceStore().getInt(SiriusPropertiesViewPreferencesKeys.PREF_MAX_LENGTH_TAB_NAME.name()));
    }

    private String elide(String s, int maxLength) {
        if ("...".length() <= maxLength && maxLength < s.length()) {
            return String.valueOf(s.substring(0, maxLength - "...".length())) + "...";
        }
        return s;
    }

    public EList<Object> getChoiceOfValues(EStructuralFeature feature) {
        BasicEList result = new BasicEList();
        EObject target = this.getTargetEObject();
        if (target != null) {
            result.addAll(this.editServices.getPropertyDescriptorChoiceOfValues(target, feature.getName()));
        }
        return result;
    }

    public boolean isMultiline(EStructuralFeature eStructuralFeature) {
        EObject target = this.getTargetEObject();
        if (target != null) {
            return this.editServices.isPropertyDescriptorMultiLine(target, eStructuralFeature.getName());
        }
        return false;
    }

    public String getDescription(EStructuralFeature eStructuralFeature) {
        EObject target = this.getTargetEObject();
        if (target != null) {
            return this.editServices.getPropertyDescriptorDescription(target, eStructuralFeature.getName());
        }
        return "";
    }

    public boolean needsTextWidget(EStructuralFeature eStructuralFeature) {
        boolean needsTextWidget = false;
        needsTextWidget = needsTextWidget || JAVA_LANG_STRING.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || INT.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || JAVA_LANG_INTEGER.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || DOUBLE.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || JAVA_LANG_DOUBLE.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || CHAR.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || JAVA_LANG_CHARACTER.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || SHORT.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || JAVA_LANG_SHORT.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || LONG.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || JAVA_LANG_LONG.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || FLOAT.equals(eStructuralFeature.getEType().getInstanceTypeName());
        needsTextWidget = needsTextWidget || JAVA_LANG_FLOAT.equals(eStructuralFeature.getEType().getInstanceTypeName());
        boolean bl = needsTextWidget = needsTextWidget || JAVA_UTIL_DATE.equals(eStructuralFeature.getEType().getInstanceTypeName());
        return needsTextWidget && !eStructuralFeature.isMany();
    }

    public boolean needsCheckboxWidget(EStructuralFeature eStructuralFeature) {
        boolean needsCheckboxWidget = false;
        needsCheckboxWidget = needsCheckboxWidget || BOOLEAN.equals(eStructuralFeature.getEType().getInstanceTypeName());
        boolean bl = needsCheckboxWidget = needsCheckboxWidget || JAVA_LANG_BOOLEAN.equals(eStructuralFeature.getEType().getInstanceTypeName());
        return needsCheckboxWidget && !eStructuralFeature.isMany();
    }

    public EList<EStructuralFeature> getEStructuralFeatures() {
        BasicEList visibleFeatures = new BasicEList();
        for (EStructuralFeature eStructuralFeature : this.getTargetEObject().eClass().getEAllStructuralFeatures()) {
            if (eStructuralFeature.isDerived() || eStructuralFeature.isTransient() || eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment()) continue;
            visibleFeatures.add((Object)eStructuralFeature);
        }
        return visibleFeatures;
    }

    public Object setValue(EStructuralFeature feature, Object newValue) {
        EObject target = this.getTargetEObject();
        if (target != null) {
            Object finalValue = newValue;
            if (feature instanceof EAttribute && newValue instanceof String) {
                finalValue = EcoreUtil.createFromString((EDataType)((EAttribute)feature).getEAttributeType(), (String)((String)newValue));
            }
            target.eSet(feature, finalValue);
        }
        return this.self;
    }
}

