/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class HideDDiagramElementLabelAction
extends Action
implements IObjectActionDelegate,
Disposable {
    private ISelection selection;

    public HideDDiagramElementLabelAction() {
    }

    public HideDDiagramElementLabelAction(String text) {
        this(text, DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/categoryLabelHidden.gif"));
    }

    public HideDDiagramElementLabelAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(text);
    }

    public static boolean isEnabled(Collection<?> elementsToCheck) {
        boolean canHideLabel = true;
        for (Object selectedElement : elementsToCheck) {
            if (selectedElement instanceof IGraphicalEditPart) {
                canHideLabel &= HideDDiagramElementLabelAction.isEnabled((IGraphicalEditPart)selectedElement);
                continue;
            }
            if (selectedElement instanceof DDiagramElement) {
                canHideLabel &= HideDDiagramElementLabelAction.isEnabled((DDiagramElement)selectedElement);
                continue;
            }
            canHideLabel = false;
        }
        return canHideLabel;
    }

    private static boolean isEnabled(IGraphicalEditPart graphicalEditPart) {
        if (graphicalEditPart.isActive() && graphicalEditPart.resolveSemanticElement() instanceof DDiagramElement) {
            return HideDDiagramElementLabelAction.isEnabled((DDiagramElement)graphicalEditPart.resolveSemanticElement());
        }
        return false;
    }

    private static boolean isEnabled(DDiagramElement diagramElement) {
        DDiagramElementQuery query = new DDiagramElementQuery(diagramElement);
        return query.canHideLabel() && !query.isLabelHidden();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IStructuredSelection structuredSelection;
        HashSet<Object> minimizedSelection;
        if (this.selection instanceof IStructuredSelection && (minimizedSelection = new HashSet<Object>(Arrays.asList((structuredSelection = (IStructuredSelection)this.selection).toArray()))).size() > 0) {
            Object nextSelected = minimizedSelection.iterator().next();
            if (nextSelected instanceof EditPart) {
                RootEditPart root = ((EditPart)nextSelected).getRoot();
                DDiagramEditor diagramEditor = (DDiagramEditor)((EditPart)nextSelected).getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
                this.runHideLabelCommand(root, diagramEditor, this.partsToSemantic(Arrays.asList(structuredSelection.toArray())));
            } else if (nextSelected instanceof DDiagramElement || nextSelected instanceof AbstractDDiagramElementLabelItemProvider) {
                this.runForNoEditPartSelection(minimizedSelection);
            }
        }
    }

    private void runForNoEditPartSelection(Set<Object> minimizedSelection) {
        HashSet<EObject> eObjectSelection = new HashSet<EObject>();
        for (Object obj : minimizedSelection) {
            Option<DDiagramElement> optionTarget;
            if (obj instanceof EObject) {
                eObjectSelection.add((EObject)obj);
                continue;
            }
            if (!(obj instanceof AbstractDDiagramElementLabelItemProvider) || !(optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)obj)).getDiagramElementTarget()).some()) continue;
            eObjectSelection.add((EObject)optionTarget.get());
        }
        this.run(eObjectSelection);
    }

    public void run() {
        this.selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        this.run((IAction)this);
    }

    private void run(Set<EObject> minimizedSelection) {
        if (this.selection instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            DiagramOutlinePage.TreeSelectionWrapper wrapper = (DiagramOutlinePage.TreeSelectionWrapper)this.selection;
            RootEditPart root = wrapper.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)wrapper.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runHideLabelCommand(root, diagramEditor, minimizedSelection);
        }
    }

    private void runHideLabelCommand(RootEditPart root, DDiagramEditor editor, Set<EObject> elements) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)editor.getEditingDomain().getResourceSet());
        IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        Command cmd = emfCommandFactory.buildHideLabelCommand(elements);
        ((TransactionalEditingDomain)editor.getAdapter(EditingDomain.class)).getCommandStack().execute(cmd);
    }

    private Set<EObject> partsToSemantic(List<Object> asList) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (Object obj : asList) {
            IGraphicalEditPart part;
            EObject element;
            if (!(obj instanceof IGraphicalEditPart) || (element = (part = (IGraphicalEditPart)obj).resolveSemanticElement()) == null) continue;
            result.add(element);
        }
        return result;
    }

    public void selectionChanged(IAction action, ISelection s) {
        this.selection = s;
        this.setEnabled(true);
        if (s instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            this.setEnabled(HideDDiagramElementLabelAction.isEnabled(((DiagramOutlinePage.TreeSelectionWrapper)s).toList()));
        } else if (s instanceof IStructuredSelection) {
            this.setEnabled(HideDDiagramElementLabelAction.isEnabled(((IStructuredSelection)s).toList()));
        }
    }

    public void dispose() {
        this.selection = null;
    }
}

