/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.format.semantic;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.formatdata.EdgeFormatData;
import org.eclipse.sirius.diagram.formatdata.NodeFormatData;
import org.eclipse.sirius.diagram.ui.tools.api.format.AbstractSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.format.AdvancedSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.format.NodeFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.AbstractSemanticFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticEdgeFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticNodeFormatDataKey;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class SiriusFormatDataManagerForSemanticElements
extends AbstractSiriusFormatDataManager
implements AdvancedSiriusFormatDataManager {
    private static final String ERROR_MESSAGE_UNSUPPORTED_FORMAT_DATA_TYPE = "The default format data manager SiriusFormatDataManagerForSemanticElements does not support AbstractDataFormat of the type :";
    private static final String ERROR_MESSAGE_UNSUPPORTED_METHOD_CALL = "The default SiriusFormatDataManager does not use this method anymore";
    private static final SiriusFormatDataManagerForSemanticElements INSTANCE = new SiriusFormatDataManagerForSemanticElements();
    private static final Predicate<EObject> ROOT_PREDICATE = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            return input.eContainer() == null;
        }
    };
    private final Map<SemanticNodeFormatDataKey, Map<String, NodeFormatData>> nodeFormatDataMap = new HashMap<SemanticNodeFormatDataKey, Map<String, NodeFormatData>>();
    private final Map<SemanticEdgeFormatDataKey, Map<String, EdgeFormatData>> edgeFormatDataMap = new HashMap<SemanticEdgeFormatDataKey, Map<String, EdgeFormatData>>();

    @Override
    public void addFormatData(FormatDataKey key, AbstractFormatData formatData) {
        this.clearFormatData();
        throw new UnsupportedOperationException(ERROR_MESSAGE_UNSUPPORTED_METHOD_CALL);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addFormatData(FormatDataKey key, RepresentationElementMapping mapping, AbstractFormatData formatData) {
        if (!this.checkKeyType(key)) {
            formatData.setId(null);
            return;
        }
        if (key instanceof SemanticNodeFormatDataKey) {
            if (!(formatData instanceof NodeFormatData)) {
                this.clearFormatData();
                throw new IllegalStateException(ERROR_MESSAGE_UNSUPPORTED_FORMAT_DATA_TYPE + formatData.getClass().getSimpleName());
            }
            Map<String, NodeFormatData> formatsMap = this.nodeFormatDataMap.get(key);
            if (formatsMap == null) {
                formatsMap = new TreeMap<String, NodeFormatData>();
                this.nodeFormatDataMap.put((SemanticNodeFormatDataKey)key, formatsMap);
            }
            formatsMap.put(mapping.getName(), (NodeFormatData)formatData);
            return;
        }
        if (!(key instanceof SemanticEdgeFormatDataKey)) return;
        if (!(formatData instanceof EdgeFormatData)) {
            this.clearFormatData();
            throw new IllegalStateException(ERROR_MESSAGE_UNSUPPORTED_FORMAT_DATA_TYPE + formatData.getClass().getSimpleName());
        }
        Map<String, EdgeFormatData> formatsMap = this.edgeFormatDataMap.get(key);
        if (formatsMap == null) {
            formatsMap = new TreeMap<String, EdgeFormatData>();
            this.edgeFormatDataMap.put((SemanticEdgeFormatDataKey)key, formatsMap);
        }
        formatsMap.put(mapping.getName(), (EdgeFormatData)formatData);
    }

    @Override
    public AbstractFormatData getFormatData(FormatDataKey key) {
        this.clearFormatData();
        throw new UnsupportedOperationException(ERROR_MESSAGE_UNSUPPORTED_METHOD_CALL);
    }

    @Override
    public AbstractFormatData getFormatData(FormatDataKey key, RepresentationElementMapping mapping) {
        Object result = null;
        if (this.checkKeyType(key)) {
            Map<String, EdgeFormatData> formatsMap;
            String mappingName;
            String string = mappingName = mapping == null ? null : mapping.getName();
            if (key instanceof SemanticNodeFormatDataKey) {
                Map<String, NodeFormatData> formatsMap2 = this.nodeFormatDataMap.get(key);
                if (formatsMap2 != null) {
                    NodeFormatData nodeFormatData = formatsMap2.get(mappingName);
                    result = nodeFormatData == null && formatsMap2.size() > 0 ? (AbstractFormatData)formatsMap2.values().iterator().next() : nodeFormatData;
                }
            } else if (key instanceof SemanticEdgeFormatDataKey && (formatsMap = this.edgeFormatDataMap.get(key)) != null) {
                EdgeFormatData edgeFormatData = formatsMap.get(mappingName);
                result = edgeFormatData == null && formatsMap.size() > 0 ? (AbstractFormatData)formatsMap.values().iterator().next() : edgeFormatData;
            }
        }
        return result;
    }

    private boolean checkKeyType(FormatDataKey key) {
        return key instanceof SemanticNodeFormatDataKey || key instanceof SemanticEdgeFormatDataKey;
    }

    public SiriusFormatDataManager getInstance() {
        return INSTANCE;
    }

    @Override
    public FormatDataKey createKey(DSemanticDecorator semanticDecorator) {
        AbstractSemanticFormatDataKey result = null;
        EObject realSemanticElement = semanticDecorator.getTarget();
        if (semanticDecorator instanceof DEdge) {
            result = new SemanticEdgeFormatDataKey(realSemanticElement);
        } else if (semanticDecorator instanceof AbstractDNode || semanticDecorator instanceof DDiagram) {
            result = new SemanticNodeFormatDataKey(realSemanticElement);
        }
        return result;
    }

    @Override
    public boolean containsData() {
        return !this.nodeFormatDataMap.isEmpty() || !this.edgeFormatDataMap.isEmpty();
    }

    @Override
    public void clearFormatData() {
        this.nodeFormatDataMap.clear();
        this.edgeFormatDataMap.clear();
    }

    @Override
    public Map<SemanticEdgeFormatDataKey, Map<String, EdgeFormatData>> getEdgeFormatData() {
        return this.edgeFormatDataMap;
    }

    @Override
    public Map<? extends NodeFormatDataKey, Map<String, NodeFormatData>> getRootNodeFormatData() {
        return this.getRootFormatData(this.nodeFormatDataMap);
    }

    public Map<? extends NodeFormatDataKey, Map<String, NodeFormatData>> getRootFormatData(Map<SemanticNodeFormatDataKey, Map<String, NodeFormatData>> theNodeFormatDataMap) {
        HashMap<NodeFormatDataKey, Map> resultValues = new HashMap<NodeFormatDataKey, Map>();
        Set<Map.Entry<SemanticNodeFormatDataKey, Map<String, NodeFormatData>>> allEntries = theNodeFormatDataMap.entrySet();
        for (Map.Entry<SemanticNodeFormatDataKey, Map<String, NodeFormatData>> entry : allEntries) {
            Map<String, NodeFormatData> value = entry.getValue();
            Map filterValues = Maps.filterValues(value, ROOT_PREDICATE);
            if (filterValues.size() <= 0) continue;
            resultValues.put(entry.getKey(), filterValues);
        }
        return resultValues;
    }

    @Override
    public Map<? extends NodeFormatDataKey, Map<String, NodeFormatData>> getNodeFormatData() {
        return this.nodeFormatDataMap;
    }
}

