/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.properties.section.semantic;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.ui.properties.propertysource.TreeCompositeEObjectPropertySource;
import org.eclipse.sirius.tree.ui.properties.section.common.AbstractDTreePropertySection;
import org.eclipse.sirius.ui.tools.api.properties.AbstractCompositeEObjectPropertySource;
import org.eclipse.sirius.ui.tools.api.properties.SiriusExtensiblePropertySource;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.ui.views.properties.IPropertySource;

public class SemanticPropertySection
extends AbstractDTreePropertySection {
    public IPropertySource getPropertySource(Object object) {
        IPropertySource propSrc = null;
        if (object instanceof IPropertySource) {
            propSrc = (IPropertySource)object;
        } else if (object instanceof DTreeItem) {
            DTreeItem item = (DTreeItem)object;
            propSrc = this.getPropertySource(item);
        } else if (object instanceof DSemanticDecorator) {
            DSemanticDecorator semanticDecorator = (DSemanticDecorator)object;
            propSrc = this.getPropertySource(semanticDecorator);
        } else {
            IItemPropertySource ips;
            AdapterFactory af = this.getAdapterFactory(object);
            if (af != null && (ips = (IItemPropertySource)af.adapt(object, IItemPropertySource.class)) != null) {
                return new PropertySource(object, ips);
            }
            if (object instanceof IAdaptable) {
                propSrc = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
            }
        }
        return propSrc;
    }

    protected IPropertySource getPropertySource(DTreeItem tableElement) {
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)tableElement);
        return this.getPropertySource(accessor, (Collection<EObject>)tableElement.getSemanticElements());
    }

    protected IPropertySource getPropertySource(ModelAccessor accessor, Collection<EObject> eObjects) {
        Iterator<EObject> iterElements = eObjects.iterator();
        TreeCompositeEObjectPropertySource propertySource = new TreeCompositeEObjectPropertySource();
        while (iterElements.hasNext()) {
            EObject semanticElement = iterElements.next();
            this.fillPropertySource(accessor, semanticElement, (AbstractCompositeEObjectPropertySource)propertySource);
        }
        return propertySource;
    }

    protected IPropertySource getPropertySource(DSemanticDecorator semanticDecorator) {
        TreeCompositeEObjectPropertySource propertySource = new TreeCompositeEObjectPropertySource();
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)semanticDecorator);
        EObject semanticElement = semanticDecorator.getTarget();
        this.fillPropertySource(accessor, semanticElement, (AbstractCompositeEObjectPropertySource)propertySource);
        return propertySource;
    }

    private void fillPropertySource(ModelAccessor accessor, EObject semanticElement, AbstractCompositeEObjectPropertySource propertySource) {
        IItemPropertySource ips;
        AdapterFactory af;
        if (!accessor.isExtension(semanticElement) && (af = this.getAdapterFactory(semanticElement)) != null && (ips = (IItemPropertySource)af.adapt((Notifier)semanticElement, IItemPropertySource.class)) != null) {
            SiriusExtensiblePropertySource targetPropertySource = new SiriusExtensiblePropertySource((Object)semanticElement, ips);
            propertySource.addPropertySource(semanticElement, (IPropertySource)targetPropertySource);
        }
    }
}

