/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.internal.interpreter.IMonomorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.ServiceInterpreter;

class MonomorphicService
implements IMonomorphicService {
    private final Object serviceInstance;
    private final Method serviceMethod;

    public MonomorphicService(Object serviceInstance, Method serviceMethod) {
        this.serviceInstance = Preconditions.checkNotNull((Object)serviceInstance);
        this.serviceMethod = (Method)Preconditions.checkNotNull((Object)serviceMethod);
        Preconditions.checkArgument((boolean)ServiceInterpreter.isValidServiceMethod(serviceMethod));
    }

    @Override
    public String getName() {
        return this.serviceMethod.getName();
    }

    @Override
    public boolean appliesTo(Object[] target) {
        boolean apply = true;
        Class<?>[] parameters = this.serviceMethod.getParameterTypes();
        if (parameters.length != target.length) {
            apply = false;
        } else {
            int i = 0;
            while (i < target.length) {
                if (target[i] != null && !this.serviceMethod.getParameterTypes()[i].isAssignableFrom(target[i].getClass())) {
                    apply = false;
                    break;
                }
                ++i;
            }
        }
        return apply;
    }

    @Override
    public Object call(Object[] target) throws EvaluationException {
        Object result = null;
        try {
            result = this.serviceMethod.invoke(this.serviceInstance, target);
        }
        catch (IllegalArgumentException e) {
            this.fail(e);
        }
        catch (IllegalAccessException e) {
            this.fail(e);
        }
        catch (InvocationTargetException e) {
            this.fail(e);
        }
        return result;
    }

    private void fail(Exception e) throws EvaluationException {
        throw new EvaluationException(MessageFormat.format(Messages.MonomorphicService_serviceError, this), e);
    }

    public String toString() {
        return MessageFormat.format("{0}.{1}({2})", this.serviceInstance.getClass().getCanonicalName(), this.serviceMethod.getName(), this.serviceMethod.getParameterTypes()[0].getCanonicalName());
    }

    @Override
    public List<String> getParametersTypes() {
        ArrayList<String> parametersTypes = new ArrayList<String>();
        Class<?>[] classArray = this.serviceMethod.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            parametersTypes.add(type.getSimpleName());
            ++n2;
        }
        return parametersTypes;
    }
}

