/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.DTreeItemLocalRefreshCommand;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeRefreshContext;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends Action
implements IObjectActionDelegate {
    private DTreeEditor treeEditor;
    private ISelection selection;
    private LinkedList<Object> minimizedSelection;

    public RefreshAction(DTreeEditor treeEditor) {
        super(Messages.RefreshAction_refreshTreeElement, DTreeViewerManager.getImageRegistry().getDescriptor("tree/refresh"));
        this.treeEditor = treeEditor;
        this.minimizedSelection = new LinkedList();
    }

    public void run() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) instanceof DTreeEditor) {
            IRunnableWithProgress op;
            this.treeEditor = (DTreeEditor)activeEditor;
            this.selection = activePage.getSelection();
            if (this.selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
                this.minimizedSelection = new LinkedList<Object>(Arrays.asList(structuredSelection.toArray()));
            }
            if ((op = this.getRunnable()) != null) {
                this.run(op);
            }
        }
    }

    private IRunnableWithProgress getRunnable() {
        Object op = null;
        if (this.minimizedSelection.isEmpty()) {
            op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    TransactionalEditingDomain domain = RefreshAction.this.treeEditor.getEditingDomain();
                    domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, monitor, new DRepresentation[]{RefreshAction.this.treeEditor.getTreeModel()}));
                }
            };
            RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)this.treeEditor.getTreeModel());
        } else {
            Iterable elements = Iterables.filter(this.minimizedSelection, DTreeItem.class);
            final ArrayList dTreeItems = Lists.newArrayList((Iterable)elements);
            if (!dTreeItems.isEmpty()) {
                op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        Session session = new EObjectQuery((EObject)RefreshAction.this.treeEditor.getRepresentation()).getSession();
                        if (session != null) {
                            TreeRefreshContext globalContext = new TreeRefreshContext(session.getModelAccessor(), session.getInterpreter(), session.getSemanticResources(), session.getTransactionalEditingDomain());
                            TransactionalEditingDomain domain = RefreshAction.this.treeEditor.getEditingDomain();
                            DTreeItemLocalRefreshCommand localRefreshCmd = new DTreeItemLocalRefreshCommand(domain, (GlobalContext)globalContext, dTreeItems, false);
                            domain.getCommandStack().execute((Command)localRefreshCmd);
                        }
                    }
                };
            }
        }
        return op;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.run();
    }

    private void run(IRunnableWithProgress op) {
        Shell activeShell = this.treeEditor.getSite().getShell();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
        try {
            try {
                this.treeEditor.enablePropertiesUpdate(false);
                monitorDialog.run(true, false, op);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)Messages.EditorRefreshAction_error, (String)e.getTargetException().getMessage());
                SiriusPlugin.getDefault().error(Messages.EditorRefreshAction_treeRefreshError, (Throwable)e);
                this.treeEditor.enablePropertiesUpdate(true);
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)activeShell, (String)Messages.EditorRefreshAction_refreshCancelled, (String)e.getMessage());
                this.treeEditor.enablePropertiesUpdate(true);
            }
        }
        finally {
            this.treeEditor.enablePropertiesUpdate(true);
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel;
    }
}

