/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.edit.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.RecordingCommandsExecutor;

public final class CommandFactory {
    private CommandFactory() {
    }

    public static <T> RecordingCommand createRecordingCommand(TransactionalEditingDomain ted, Collection<AbstractModelChangeOperation<T>> operations) {
        String name = operations.isEmpty() ? Messages.CommandFactory_doNothingLabel : operations.iterator().next().getName();
        return new RecordingCommandsExecutor<T>(ted, name, operations);
    }

    public static <T> RecordingCommand createRecordingCommand(TransactionalEditingDomain ted, AbstractModelChangeOperation<T> operation) {
        return CommandFactory.createRecordingCommand(ted, Collections.singleton(operation));
    }

    public static <T> RecordingCommand createRecordingCommand(TransactionalEditingDomain ted, AbstractModelChangeOperation<T> ... operations) {
        return CommandFactory.createRecordingCommand(ted, Arrays.asList(operations));
    }

    public static <T> ICommand createICommand(TransactionalEditingDomain ted, final Collection<AbstractModelChangeOperation<T>> operations) {
        String name = operations.isEmpty() ? Messages.CommandFactory_doNothingLabel : operations.iterator().next().getName();
        return new AbstractTransactionalCommand(ted, name, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ArrayList results = new ArrayList();
                for (AbstractModelChangeOperation operation : operations) {
                    Object value = operation.execute();
                    if (value == null) continue;
                    results.add(value);
                }
                return CommandResult.newOKCommandResult(results.size() == 1 ? results.get(0) : results);
            }
        };
    }

    public static <T> ICommand createICommand(TransactionalEditingDomain ted, AbstractModelChangeOperation<T> operation) {
        return CommandFactory.createICommand(ted, Collections.singleton(operation));
    }

    public static <T> ICommand createICommand(TransactionalEditingDomain ted, AbstractModelChangeOperation<T> ... operations) {
        return CommandFactory.createICommand(ted, Arrays.asList(operations));
    }
}

