/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.interpreter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.sirius.common.acceleo.interpreter.SiriusCompletionProposal;
import org.eclipse.sirius.common.acceleo.interpreter.SiriusInterpreterSourceViewer;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposalWithReplacement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SiriusContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Collection<ContentProposal> vpProposals;
        if (viewer instanceof SiriusInterpreterSourceViewer && (vpProposals = ((SiriusInterpreterSourceViewer)viewer).getComputedProposals()) != null) {
            Iterable proposals = Iterables.transform(vpProposals, (Function)new CompletionProposalConverter(viewer.getSelectedRange()));
            return (ICompletionProposal[])Iterables.toArray((Iterable)proposals, ICompletionProposal.class);
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private class CompletionProposalConverter
    implements Function<ContentProposal, ICompletionProposal> {
        final Point currentRange;

        public CompletionProposalConverter(Point currentRange) {
            this.currentRange = currentRange;
        }

        public ICompletionProposal apply(ContentProposal input) {
            SiriusCompletionProposal proposal;
            if (input instanceof ContentProposalWithReplacement) {
                ContentProposalWithReplacement proposalWithReplacement = (ContentProposalWithReplacement)input;
                Image image = null;
                if (ContentProposalWithReplacement.ImageKind.SWT_IMAGE.equals((Object)proposalWithReplacement.getImageKind()) && proposalWithReplacement.getImage() instanceof Image) {
                    image = (Image)proposalWithReplacement.getImage();
                }
                proposal = new SiriusCompletionProposal(proposalWithReplacement.getProposal(), proposalWithReplacement.getReplacementOffset(), proposalWithReplacement.getReplacementLength(), proposalWithReplacement.getCursorPosition(), image, proposalWithReplacement.getDisplay(), null, proposalWithReplacement.getInformation());
            } else {
                proposal = new SiriusCompletionProposal(input.getProposal(), this.currentRange.x, this.currentRange.y, input.getCursorPosition(), null, input.getDisplay(), null, input.getInformation());
            }
            return proposal;
        }
    }
}

