/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.EvaluatedSemanticPartition;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.SemanticPartition;
import org.eclipse.sirius.synchronizer.SemanticPartitions;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.tools.internal.Messages;

public class MappingBasedPartition
implements SemanticPartition {
    private static final String TREE = "tree";
    private String domainClass;
    private Option<String> semanticCandidate;
    private GlobalContext ctx;
    private Option<? extends EObject> specificationAttachment;

    public MappingBasedPartition(GlobalContext ctx, String domainClass, Option<String> semanticCandidate, Option<? extends EObject> specificationAttachment) {
        this.domainClass = domainClass;
        this.ctx = ctx;
        this.semanticCandidate = semanticCandidate;
        this.specificationAttachment = specificationAttachment;
    }

    public EvaluatedSemanticPartition evaluate(EObject root, CreatedOutput parentElement) {
        this.setTreeElementVariables(parentElement);
        Iterator<Object> elements = Collections.emptyList().iterator();
        if (this.semanticCandidate.some()) {
            try {
                elements = this.ctx.getInterpreter().evaluateCollection(root, (String)this.semanticCandidate.get()).iterator();
            }
            catch (EvaluationException e) {
                this.ctx.getSpecifierFeedBack().warning(Messages.MappingBasedPartition_semanticCandidateEvaluationError, (Exception)((Object)e), this.specificationAttachment);
            }
        } else {
            elements = this.allEObjectsOfTheSession();
        }
        this.unSetTreeElementVariables();
        return SemanticPartitions.eObjectList((List)ImmutableList.copyOf((Iterator)Iterators.filter(elements, (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return MappingBasedPartition.this.ctx.getModelAccessor().eInstanceOf(input, MappingBasedPartition.this.domainClass);
            }
        })));
    }

    private Iterator<EObject> allEObjectsOfTheSession() {
        ArrayList iterators = Lists.newArrayList();
        for (EObject obj : this.getAllSessionSemanticRoots()) {
            iterators.add(obj.eAllContents());
        }
        return Iterators.concat(iterators.iterator());
    }

    private Collection<EObject> getAllSessionSemanticRoots() {
        Collection<Resource> semanticResources = this.ctx.getSemanticResources();
        if (semanticResources == null) {
            semanticResources = Collections.emptyList();
        }
        ArrayList semanticRoots = Lists.newArrayList();
        for (Resource semanticResource : semanticResources) {
            semanticRoots.addAll(semanticResource.getContents());
        }
        return semanticRoots;
    }

    private void setTreeElementVariables(CreatedOutput element) {
        if (element != null) {
            EObject createdElement;
            OutputDescriptor descriptor = element.getDescriptor();
            if (descriptor != null && descriptor.getSourceElement() != null) {
                this.ctx.getInterpreter().setVariable("container", (Object)descriptor.getSourceElement());
            }
            if ((createdElement = element.getCreatedElement()) != null) {
                this.ctx.getInterpreter().setVariable("containerView", (Object)createdElement);
                this.ctx.getInterpreter().setVariable(TREE, (Object)TreeHelper.getTree(createdElement));
            }
        }
    }

    private void unSetTreeElementVariables() {
        this.ctx.getInterpreter().unSetVariable("container");
        this.ctx.getInterpreter().unSetVariable("containerView");
        this.ctx.getInterpreter().unSetVariable(TREE);
    }
}

