/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.internal.session.ReloadingPolicyImpl;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilter;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilterManager;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.EditingSessionEvent;
import org.eclipse.sirius.ui.business.api.session.EditorNameAdapter;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.internal.dialect.editor.DialectEditorCloser;
import org.eclipse.sirius.ui.business.internal.session.RestoreToLastSavePointListener;
import org.eclipse.sirius.ui.business.internal.session.SaveSessionWhenNoDialectEditorsListener;
import org.eclipse.sirius.ui.business.internal.session.SessionSaveable;
import org.eclipse.sirius.ui.tools.internal.util.SessionCallBackWithUI;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.part.FileEditorInput;

public class EditingSession
implements IEditingSession,
ISaveablesSource,
RefreshFilter {
    protected Saveable saveable;
    private final List<DialectEditor> editors = new ArrayList<DialectEditor>();
    private Map<DialectEditor, DialectEditorCloser> dialectEditorClosers = new HashMap<DialectEditor, DialectEditorCloser>();
    private NeedSaveOnCloseDetector needSaveOnCloseDetec = new NeedSaveOnCloseDetector();
    private boolean opened;
    private final Session session;
    private EditorNameAdapter editorNameAdapter;
    private RestoreToLastSavePointListener restoreToSavePointListener;
    private SaveSessionWhenNoDialectEditorsListener saveSessionListener;

    public EditingSession(Session session) {
        this.session = session;
        this.saveable = new SessionSaveable(session);
        this.editorNameAdapter = new EditorNameAdapter(this);
        session.setReloadingPolicy((ReloadingPolicy)new ReloadingPolicyImpl((UICallBack)new SessionCallBackWithUI()));
    }

    private void initListeners() {
        this.restoreToSavePointListener = new RestoreToLastSavePointListener(this.session);
        this.saveSessionListener = this.createSaveSessionWhenNoDialectEditorsListener(this.session);
        this.saveSessionListener.register();
    }

    protected SaveSessionWhenNoDialectEditorsListener createSaveSessionWhenNoDialectEditorsListener(Session theSession) {
        return new SaveSessionWhenNoDialectEditorsListener(this.session);
    }

    private void removeListeners() {
        if (this.restoreToSavePointListener != null) {
            this.restoreToSavePointListener.dispose();
            this.restoreToSavePointListener = null;
        }
        if (this.saveSessionListener != null) {
            this.saveSessionListener.unregister();
            this.saveSessionListener = null;
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Collection<DialectEditor> getEditors() {
        return this.editors;
    }

    @Override
    public void attachEditor(DialectEditor dialectEditor) {
        if (!this.editors.contains(dialectEditor) && dialectEditor != null) {
            this.editors.add(dialectEditor);
            this.editorNameAdapter.registerEditor(dialectEditor);
            this.needSaveOnCloseDetec.reInit();
            this.reorderEditorsIfNeeded(dialectEditor);
            if (dialectEditor.getRepresentation() != null) {
                this.dialectEditorClosers.put(dialectEditor, new DialectEditorCloser(this, dialectEditor));
            }
        }
    }

    private void reorderEditorsIfNeeded(DialectEditor justAddedEditor) {
        ArrayList reorderedList = Lists.newArrayList();
        Object[] editorReferences = null;
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            editorReferences = page.getEditorReferences();
        }
        if (editorReferences != null) {
            for (IEditorReference ref : Lists.newArrayList((Object[])editorReferences)) {
                IEditorPart editor2 = ref.getEditor(false);
                IEditorInput refInput = null;
                try {
                    refInput = ref.getEditorInput();
                }
                catch (PartInitException partInitException) {}
                if (editor2 == null && justAddedEditor.getEditorInput() == refInput) {
                    reorderedList.add(justAddedEditor);
                    continue;
                }
                if (!this.editors.contains(editor2)) continue;
                reorderedList.add((DialectEditor)editor2);
            }
            if (this.editors.size() == reorderedList.size() && !Iterables.elementsEqual(this.editors, (Iterable)reorderedList)) {
                this.editors.clear();
                this.editors.addAll(reorderedList);
            }
        }
    }

    @Override
    public void detachEditor(DialectEditor dialectEditor) {
        this.editors.remove(dialectEditor);
        this.editorNameAdapter.unregisterEditor(dialectEditor);
        this.needSaveOnCloseDetec.reInit();
        DialectEditorCloser dialectEditorCloser = this.dialectEditorClosers.remove(dialectEditor);
        if (dialectEditorCloser != null) {
            dialectEditorCloser.dispose();
        }
    }

    @Override
    public void detachEditor(DialectEditor dialectEditor, boolean revertChanges) {
        boolean returnToSyncState = revertChanges && (this.getEditors().size() == 1 || this.closeAllDetected());
        this.detachEditor(dialectEditor);
        if (returnToSyncState) {
            this.restoreToSavePointListener.returnToSyncState();
        }
    }

    @Override
    public void closeEditors(boolean save, Collection<? extends DialectEditor> editorParts) {
        for (DialectEditor dialectEditor : new ArrayList<DialectEditor>(editorParts)) {
            this.closeEditor(dialectEditor, save);
        }
    }

    @Override
    public void closeEditors(boolean save, DialectEditor ... editorParts) {
        this.closeEditors(save, Arrays.asList(editorParts));
    }

    private void closeEditor(DialectEditor editor, boolean save) {
        if (DialectUIManager.INSTANCE.canHandleEditor(editor)) {
            try {
                try {
                    this.detachEditor(editor);
                }
                catch (IllegalStateException e) {
                    SiriusEditPlugin.getPlugin().log(e);
                    DialectUIManager.INSTANCE.closeEditor(editor, save);
                }
            }
            finally {
                DialectUIManager.INSTANCE.closeEditor(editor, save);
            }
        } else {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, save);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.editors.size() == 0;
    }

    @Override
    public boolean isLastOpenedEditor() {
        return this.editors.size() == 1;
    }

    @Override
    public boolean needToBeSavedOnClose(IEditorPart editor) {
        return this.needSaveOnCloseDetec.needToBeSavedOnClose(editor);
    }

    @Override
    public int promptToSaveOnClose() {
        int choice = 3;
        if (this.saveable != null) {
            boolean stillOpenElsewhere = this.getEditors().size() > 1 && !this.closeAllDetected();
            boolean promptStandardDialog = !this.restoreToSavePointListener.isAllowedToReturnToSyncState();
            choice = SWTUtil.showSaveDialog((Object)this.session, (String)this.saveable.getName(), (boolean)true, (boolean)stillOpenElsewhere, (boolean)promptStandardDialog);
            if (choice == 2) {
                this.needSaveOnCloseDetec.reInit();
            }
        }
        return choice;
    }

    private boolean closeAllDetected() {
        return this.needSaveOnCloseDetec.closeAllDetected();
    }

    @Override
    public void close() {
        if (this.opened) {
            this.close(true);
        }
    }

    @Override
    public void close(boolean save) {
        if (this.opened) {
            if (!this.isEmpty()) {
                this.closeEditors(save, this.editors);
            }
            RefreshFilterManager.INSTANCE.removeRefreshFilter((RefreshFilter)this);
            this.removeListeners();
            this.opened = false;
        }
        this.closeOthersEditors(save);
    }

    private void closeOthersEditors(final boolean save) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = EclipseUIUtil.getActivePage();
                if (page != null) {
                    IEditorReference[] editorReferences = page.getEditorReferences();
                    ArrayList<IEditorReference> editorsToClose = new ArrayList<IEditorReference>();
                    IEditorReference[] iEditorReferenceArray = editorReferences;
                    int n = editorReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference editor = iEditorReferenceArray[n2];
                        try {
                            IEditorInput input = editor.getEditorInput();
                            IEditorPart editorPart = editor.getEditor(false);
                            if (editorPart == null && input instanceof URIEditorInput && this.shouldCloseEditor((URIEditorInput)input)) {
                                editorsToClose.add(editor);
                            }
                        }
                        catch (PartInitException partInitException) {}
                        ++n2;
                    }
                    if (!editorsToClose.isEmpty()) {
                        IEditorReference[] toClose = editorsToClose.toArray(new IEditorReference[editorsToClose.size()]);
                        page.closeEditors(toClose, save);
                    }
                }
            }

            private boolean shouldCloseEditor(URIEditorInput input) {
                if (EditingSession.this.session instanceof DAnalysisSession) {
                    for (Resource resource : ((DAnalysisSession)EditingSession.this.session).getAllSessionResources()) {
                        if (resource.getURI() == null || !resource.getURI().equals(input.getURI().trimFragment())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    @Override
    public void open() {
        if (!this.opened) {
            RefreshFilterManager.INSTANCE.addRefreshFilter((RefreshFilter)this);
            this.initListeners();
            this.opened = true;
        }
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public boolean isSessionFor(IEditorInput editorInput) {
        boolean result = false;
        String key = this.keyFromInput(editorInput);
        if (key != null) {
            for (IEditorPart iEditorPart : this.editors) {
                if (!key.equals(this.keyFromInput(iEditorPart.getEditorInput()))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private String keyFromInput(IEditorInput input) {
        Object uri;
        String result = null;
        if (input instanceof URIEditorInput) {
            uri = ((URIEditorInput)input).getURI();
            URI deresolved = uri.deresolve(URI.createURI((String)"platform:/resource/"));
            String workspacePAth = "/" + deresolved.path();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePAth));
            if (file != null && file.isAccessible() && file.exists()) {
                String filePath = file.getLocation().toString();
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                result = filePath;
            }
            if (result == null) {
                String path = uri.path();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                result = path;
            }
        }
        if (result == null && input instanceof IPathEditorInput) {
            result = ((IPathEditorInput)input).getPath().toString();
        }
        if (result == null && input instanceof FileEditorInput) {
            uri = ((FileEditorInput)input).getURI();
            String path = ((java.net.URI)uri).getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            result = path;
        }
        if (result == null) {
            result = input.toString();
        }
        return result;
    }

    @Override
    public DialectEditor getEditor(DRepresentation representation) {
        if (representation != null) {
            for (DialectEditor editorPart : this.editors) {
                if (!DialectUIManager.INSTANCE.isRepresentationManagedByEditor(representation, editorPart)) continue;
                return editorPart;
            }
        }
        return null;
    }

    @Override
    public boolean handleEditor(IEditorPart editor) {
        return this.editors.contains(editor);
    }

    public Collection<DRepresentation> getOpenedRepresantationsToRefresh() {
        ArrayList<DRepresentation> openedRepresantationsToRefresh = new ArrayList<DRepresentation>();
        for (DialectEditor dialectEditor : this.getEditors()) {
            DRepresentation dRepresentation = dialectEditor.getRepresentation();
            if (dRepresentation == null) continue;
            openedRepresantationsToRefresh.add(dRepresentation);
        }
        return openedRepresantationsToRefresh;
    }

    public boolean shouldRefresh(DRepresentation representation) {
        return this.getOpenedRepresantationsToRefresh().contains(representation);
    }

    public Saveable[] getSaveables() {
        Saveable[] saveableArray;
        if (this.saveable != null) {
            Saveable[] saveableArray2 = new Saveable[1];
            saveableArray = saveableArray2;
            saveableArray2[0] = this.saveable;
        } else {
            saveableArray = new Saveable[]{};
        }
        return saveableArray;
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    @Override
    public void notify(EditingSessionEvent event) {
        this.saveSessionListener.notify(event);
    }

    private class NeedSaveOnCloseDetector {
        private Set<IEditorPart> closingEditors = Sets.newHashSet();

        private NeedSaveOnCloseDetector() {
        }

        public boolean needToBeSavedOnClose(IEditorPart editor) {
            boolean needToBeSavedOnClose = EditingSession.this.isLastOpenedEditor();
            if (!needToBeSavedOnClose) {
                IPreferenceStore platformUIPrefStore = PlatformUI.getPreferenceStore();
                boolean closeAll = this.checkCloseAllEditor(editor);
                needToBeSavedOnClose = platformUIPrefStore.getBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN") || closeAll;
            }
            return needToBeSavedOnClose;
        }

        public boolean closeAllDetected() {
            return this.closingEditors.size() == EditingSession.this.editors.size();
        }

        private boolean checkCloseAllEditor(IEditorPart editor) {
            if (EditingSession.this.editors.indexOf(editor) == 0) {
                this.reInit();
                this.closingEditors.add(editor);
            } else if (this.closingEditors.size() > 0) {
                this.closingEditors.add(editor);
            }
            return this.closeAllDetected();
        }

        public void reInit() {
            this.closingEditors.clear();
            this.closingEditors = Sets.newHashSet();
        }
    }
}

