/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;

public class CompoundCondition
extends DefaultCondition {
    private final Collection<ICondition> conditions = Sets.newLinkedHashSet();
    private final Set<ICondition> failures = Sets.newHashSet();

    public CompoundCondition(Collection<ICondition> conditions) {
        this.conditions.addAll(conditions);
    }

    public boolean test() throws Exception {
        this.failures.clear();
        for (ICondition condition : this.conditions) {
            try {
                if (condition.test()) continue;
                this.failures.add(condition);
            }
            catch (Exception exception) {
                this.failures.add(condition);
            }
        }
        return this.failures.isEmpty();
    }

    public String getFailureMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.failures.size() == 1) {
            sb.append("The following condition has not been met: ");
            sb.append(this.failures.iterator().next().getFailureMessage());
        } else {
            sb.append("Several conditions have not been met:\n");
            for (ICondition condition : this.failures) {
                sb.append(".").append(condition.getFailureMessage()).append("\n");
            }
        }
        return sb.toString();
    }
}

