/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.InitialPointsOfRequestDataManager;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.handles.SiriusConnectionEndPointHandle;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.draw2d.ui.geometry.LineSegQuery;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SiriusConnectionEndPointEditPolicy
extends ConnectionEndpointEditPolicy {
    private InitialPointsOfRequestDataManager initialPointsManager = new InitialPointsOfRequestDataManager();
    private ConnectionAnchor originalAnchor;
    private Object originalConstraint;
    private PointList originalPoints;

    protected List createSelectionHandles() {
        ArrayList<SiriusConnectionEndPointHandle> list = new ArrayList<SiriusConnectionEndPointHandle>();
        list.add(new SiriusConnectionEndPointHandle((AbstractDiagramEdgeEditPart)this.getHost(), 2));
        list.add(new SiriusConnectionEndPointHandle((AbstractDiagramEdgeEditPart)this.getHost(), 3));
        return list;
    }

    protected void showConnectionMoveFeedback(ReconnectRequest request) {
        ConnectionQuery connectionQuery = new ConnectionQuery(this.getConnection());
        ConnectionEditPartQuery cepq = new ConnectionEditPartQuery((org.eclipse.gef.ConnectionEditPart)((ConnectionEditPart)this.getHost()));
        boolean isOrthogonalTreeBranch = connectionQuery.isOrthogonalTreeBranch(this.getConnection().getPoints());
        boolean isEdgeWithObliqueRoutingStyle = cepq.isEdgeWithObliqueRoutingStyle();
        boolean isEdgeWithRectilinearRoutingStyle = cepq.isEdgeWithRectilinearRoutingStyle();
        if (isOrthogonalTreeBranch || isEdgeWithObliqueRoutingStyle || isEdgeWithRectilinearRoutingStyle) {
            this.preShowConnectionMoveFeedback(request);
        } else if (this.originalAnchor != null) {
            this.getConnection().setRoutingConstraint(this.originalConstraint);
        }
        super.showConnectionMoveFeedback(request);
        if (isOrthogonalTreeBranch) {
            this.postShowConnectionMoveFeedbackForOrthogonalTreeBranch(request);
        } else if (isEdgeWithObliqueRoutingStyle || isEdgeWithRectilinearRoutingStyle) {
            this.postShowConnectionMoveFeedbackForObliqueOrRectilinearConnection(request);
        }
    }

    private void preShowConnectionMoveFeedback(ReconnectRequest request) {
        if (this.originalAnchor == null) {
            this.originalAnchor = request.isMovingStartAnchor() ? this.getConnection().getSourceAnchor() : this.getConnection().getTargetAnchor();
            this.originalPoints = new PointList();
            this.saveOriginalConstraint();
            ConnectionQuery connectionQuery = new ConnectionQuery(this.getConnection());
            Option<List<RelativeBendpoint>> optionalRelativeBendpointsContraint = connectionQuery.getTreeRelativeBendpointsConstraint();
            if (optionalRelativeBendpointsContraint.some()) {
                for (RelativeBendpoint relativeBendpoint : (List)optionalRelativeBendpointsContraint.get()) {
                    this.originalPoints.addPoint(relativeBendpoint.getLocation());
                }
            } else {
                Option<List<AbsoluteBendpoint>> optionalAsboluteBendpointsContraint = connectionQuery.getTreeAbsoluteBendpointsConstraint();
                if (optionalAsboluteBendpointsContraint.some()) {
                    for (AbsoluteBendpoint absoluteBendpoint : (List)optionalAsboluteBendpointsContraint.get()) {
                        this.originalPoints.addPoint(absoluteBendpoint.getLocation().getCopy());
                    }
                }
            }
            if (this.originalPoints.size() == 0) {
                int i = 0;
                while (i < this.getConnection().getPoints().size()) {
                    this.originalPoints.addPoint(this.getConnection().getPoints().getPoint(i).getCopy());
                    ++i;
                }
            }
        }
        this.initialPointsManager.storeInitialPointsInRequest((LocationRequest)request, (org.eclipse.gef.ConnectionEditPart)((ConnectionEditPart)this.getHost()));
    }

    private void saveOriginalConstraint() {
        if (this.getConnection().getRoutingConstraint() instanceof List) {
            ArrayList listBendpoint = Lists.newArrayList();
            ArrayList originListBendpoint = new ArrayList((List)this.getConnection().getRoutingConstraint());
            try {
                Field dimension1Field = RelativeBendpoint.class.getDeclaredField("d1");
                boolean dim1Accessibility = dimension1Field.isAccessible();
                dimension1Field.setAccessible(true);
                Field dimension2Field = RelativeBendpoint.class.getDeclaredField("d2");
                boolean dim2Accessibility = dimension1Field.isAccessible();
                dimension2Field.setAccessible(true);
                Field weightField = RelativeBendpoint.class.getDeclaredField("weight");
                boolean weightAccessibility = dimension1Field.isAccessible();
                weightField.setAccessible(true);
                int i = 0;
                while (i < originListBendpoint.size()) {
                    if (originListBendpoint.get(i) instanceof RelativeBendpoint) {
                        RelativeBendpoint originBendpoint = (RelativeBendpoint)originListBendpoint.get(i);
                        Dimension dimension1 = (Dimension)dimension1Field.get(originBendpoint);
                        Dimension dimension2 = (Dimension)dimension2Field.get(originBendpoint);
                        Float weight = (Float)weightField.get(originBendpoint);
                        RelativeBendpoint copyBendpoint = new RelativeBendpoint(this.getConnection());
                        copyBendpoint.setRelativeDimensions(dimension1, dimension2);
                        copyBendpoint.setWeight(weight.floatValue());
                        listBendpoint.add(copyBendpoint);
                    }
                    ++i;
                }
                dimension1Field.setAccessible(dim1Accessibility);
                dimension2Field.setAccessible(dim2Accessibility);
                weightField.setAccessible(weightAccessibility);
            }
            catch (SecurityException e) {
                DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.diagram.ui", e.getMessage()));
            }
            catch (NoSuchFieldException e) {
                DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.diagram.ui", e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.diagram.ui", e.getMessage()));
            }
            catch (IllegalAccessException e) {
                DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.diagram.ui", e.getMessage()));
            }
            this.originalConstraint = listBendpoint;
        } else {
            this.originalConstraint = this.getConnection().getRoutingConstraint();
        }
    }

    private void postShowConnectionMoveFeedbackForOrthogonalTreeBranch(ReconnectRequest request) {
        PointList points = this.originalPoints.getCopy();
        Point newSourceRefPoint = this.getConnection().getSourceAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)newSourceRefPoint);
        Point newTargetRefPoint = this.getConnection().getTargetAnchor().getReferencePoint();
        this.getConnection().translateToRelative((Translatable)newTargetRefPoint);
        if (request.isMovingStartAnchor()) {
            int deltaX = points.getPoint((int)0).x - newSourceRefPoint.x;
            points.getPoint(0).translate(deltaX, 0);
            points.getPoint(1).translate(deltaX, 0);
        } else {
            int deltaX = newTargetRefPoint.x - points.getPoint((int)3).x;
            points.getPoint(2).translate(deltaX, 0);
            points.getPoint(3).translate(deltaX, 0);
        }
        this.changeRoutingConstraint(points, newSourceRefPoint, newTargetRefPoint);
    }

    private void changeRoutingConstraint(PointList points, Point sourceRefPoint, Point targetRefPoint) {
        ConnectionQuery connectionQuery = new ConnectionQuery(this.getConnection());
        Option<List<RelativeBendpoint>> optionalRelativeBendpointsContraint = connectionQuery.getTreeRelativeBendpointsConstraint();
        Option<List<AbsoluteBendpoint>> optionalAsboluteBendpointsContraint = connectionQuery.getTreeAbsoluteBendpointsConstraint();
        if (optionalRelativeBendpointsContraint.some() || optionalAsboluteBendpointsContraint.some()) {
            if (optionalRelativeBendpointsContraint.some()) {
                int i = 0;
                while (i < points.size()) {
                    Dimension s = points.getPoint(i).getDifference(sourceRefPoint);
                    Dimension t = points.getPoint(i).getDifference(targetRefPoint);
                    ((RelativeBendpoint)((List)optionalRelativeBendpointsContraint.get()).get(i)).setRelativeDimensions(s, t);
                    ++i;
                }
                this.getConnection().setRoutingConstraint(optionalRelativeBendpointsContraint.get());
            } else {
                int i = 0;
                while (i < points.size()) {
                    ((AbsoluteBendpoint)((List)optionalAsboluteBendpointsContraint.get()).get(i)).setLocation(points.getPoint(i));
                    ++i;
                }
                this.getConnection().setRoutingConstraint(optionalAsboluteBendpointsContraint.get());
            }
        } else {
            LinkedList newConstraint = Lists.newLinkedList();
            int i = 0;
            while (i < points.size()) {
                Dimension s = points.getPoint(i).getDifference(sourceRefPoint);
                Dimension t = points.getPoint(i).getDifference(targetRefPoint);
                RelativeBendpoint rb = new RelativeBendpoint(this.getConnection());
                rb.setRelativeDimensions(s, t);
                rb.setWeight((float)i / ((float)points.size() - 1.0f));
                newConstraint.add(rb);
                ++i;
            }
            this.getConnection().setRoutingConstraint((Object)newConstraint);
        }
    }

    private void postShowConnectionMoveFeedbackForObliqueOrRectilinearConnection(ReconnectRequest request) {
        PointList points = this.originalPoints.getCopy();
        Connection connection = this.getConnection();
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
        Point newSourceRefPoint = connection.getSourceAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)newSourceRefPoint);
        Point newTargetRefPoint = connection.getTargetAnchor().getReferencePoint();
        connection.translateToRelative((Translatable)newTargetRefPoint);
        PrecisionPoint scrollSize = new PrecisionPoint(GraphicalHelper.getScrollSize((GraphicalEditPart)connectionEditPart));
        GraphicalHelper.applyInverseZoomOnPoint((IGraphicalEditPart)connectionEditPart, (Point)scrollSize);
        if (!request.isMovingStartAnchor() && !connectionEditPart.getTarget().equals(request.getTarget()) && connection.getTargetAnchor() instanceof XYAnchor) {
            ((XYAnchor)connection.getTargetAnchor()).setLocation(GraphicalHelper.applyZoomOnPoint((IGraphicalEditPart)connectionEditPart, (Point)newTargetRefPoint.getTranslated(-scrollSize.x, -scrollSize.y)));
            newTargetRefPoint = connection.getTargetAnchor().getReferencePoint().getCopy();
            connection.translateToRelative((Translatable)newTargetRefPoint);
        } else if (request.isMovingStartAnchor() && !connectionEditPart.getSource().equals(request.getTarget()) && connection.getSourceAnchor() instanceof XYAnchor) {
            ((XYAnchor)connection.getSourceAnchor()).setLocation(GraphicalHelper.applyZoomOnPoint((IGraphicalEditPart)connectionEditPart, (Point)newSourceRefPoint.getTranslated(-scrollSize.x, -scrollSize.y)));
            newSourceRefPoint = connection.getSourceAnchor().getReferencePoint().getCopy();
            connection.translateToRelative((Translatable)newSourceRefPoint);
        }
        PrecisionPoint moveDelta = request.isMovingStartAnchor() ? new PrecisionPoint(points.getPoint((int)0).x - newSourceRefPoint.x, points.getPoint((int)0).y - newSourceRefPoint.y) : new PrecisionPoint(newTargetRefPoint.x - points.getPoint((int)(points.size() - 1)).x, newTargetRefPoint.y - points.getPoint((int)(points.size() - 1)).y);
        if (request.isMovingStartAnchor()) {
            moveDelta.negate();
            LineSeg firstSegment = new LineSeg(points.getPoint(0), points.getPoint(1));
            LineSegQuery lineSegQuery = new LineSegQuery(firstSegment);
            points.setPoint(points.getPoint(0).getTranslated((Point)moveDelta), 0);
            if (new ConnectionEditPartQuery((org.eclipse.gef.ConnectionEditPart)connectionEditPart).isEdgeWithRectilinearRoutingStyle()) {
                if (lineSegQuery.isHorizontal()) {
                    points.setPoint(points.getPoint(1).getTranslated(0.0, moveDelta.preciseY()), 1);
                } else {
                    points.setPoint(points.getPoint(1).getTranslated(moveDelta.preciseX(), 0.0), 1);
                }
            }
        } else {
            LineSeg lastSegment = new LineSeg(points.getPoint(points.size() - 2), points.getPoint(points.size() - 1));
            LineSegQuery lineSegQuery = new LineSegQuery(lastSegment);
            points.setPoint(points.getPoint(points.size() - 1).getTranslated((Point)moveDelta), points.size() - 1);
            if (new ConnectionEditPartQuery((org.eclipse.gef.ConnectionEditPart)connectionEditPart).isEdgeWithRectilinearRoutingStyle()) {
                if (lineSegQuery.isHorizontal()) {
                    points.setPoint(points.getPoint(points.size() - 2).getTranslated(0.0, moveDelta.preciseY()), points.size() - 2);
                } else {
                    points.setPoint(points.getPoint(points.size() - 2).getTranslated(moveDelta.preciseX(), 0.0), points.size() - 2);
                }
            }
        }
        this.changeRoutingConstraint(points, newSourceRefPoint, newTargetRefPoint);
    }

    protected void eraseConnectionMoveFeedback(ReconnectRequest request) {
        super.eraseConnectionMoveFeedback(request);
        if (this.originalAnchor != null) {
            this.getConnection().setRoutingConstraint(this.originalConstraint);
            this.originalAnchor = null;
        }
        this.originalConstraint = null;
        this.initialPointsManager.eraseInitialPoints(this.getConnection());
    }
}

