/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.ToolSectionQuery;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.draw2d.ui.figures.FigureUtilities;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.ui.ExternalJavaActionProvider;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.MenuItemDescription;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PopupMenuContribution
implements IContributionItemProvider {
    public void contributeToActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void contributeToPopupMenu(IMenuManager menu, IWorkbenchPart part) {
        if (part instanceof SiriusDiagramEditor) {
            SiriusDiagramEditor diagrampart = (SiriusDiagramEditor)part;
            Object adapter = diagrampart.getAdapter(IDiagramCommandFactoryProvider.class);
            if (adapter == null) {
                return;
            }
            TransactionalEditingDomain transactionalEditingDomain = diagrampart.getEditingDomain();
            IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
            IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
            EObject element = diagrampart.getDiagramEditPart().resolveSemanticElement();
            if (element instanceof DSemanticDiagram) {
                DSemanticDiagram designerDiag = (DSemanticDiagram)element;
                EList layers = designerDiag.getActivatedLayers();
                Session session = SessionManager.INSTANCE.getSession(designerDiag.getTarget());
                BasicEList sections = new BasicEList();
                BasicEList activatedPopupMenus = new BasicEList();
                BasicEList activatedOperationActionMenus = new BasicEList();
                BasicEList activatedExternalJavaActionMenus = new BasicEList();
                EList tools = designerDiag.getDescription().getReusedTools();
                this.computeReusedTools((EList<? extends ToolEntry>)tools, (EList<PopupMenu>)activatedPopupMenus, (EList<ExternalJavaAction>)activatedExternalJavaActionMenus, (EList<OperationAction>)activatedOperationActionMenus);
                sections.addAll((Collection)new ToolSectionQuery(designerDiag.getDescription().getToolSection()).getAllSections());
                for (Layer layer : layers) {
                    for (ToolSection ts : layer.getToolSections()) {
                        sections.addAll((Collection)new ToolSectionQuery(ts).getAllSections());
                    }
                }
                for (ToolSection toolSection : sections) {
                    activatedPopupMenus.addAll((Collection)toolSection.getPopupMenus());
                    ToolSectionQuery toolSectionQuery = new ToolSectionQuery(toolSection);
                    activatedOperationActionMenus.addAll((Collection)toolSectionQuery.getOperationActions(session));
                    activatedExternalJavaActionMenus.addAll((Collection)toolSectionQuery.getExternalJavaActions(session));
                    this.computeReusedTools((EList<? extends ToolEntry>)toolSection.getReusedTools(), (EList<PopupMenu>)activatedPopupMenus, (EList<ExternalJavaAction>)activatedExternalJavaActionMenus, (EList<OperationAction>)activatedOperationActionMenus);
                }
                EditDomain domain = null;
                EditPart primarySelection = null;
                ArrayList<DSemanticDecorator> selectedViews = new ArrayList<DSemanticDecorator>(diagrampart.getDiagramGraphicalViewer().getSelectedEditParts().size());
                for (EditPart editpart : diagrampart.getDiagramGraphicalViewer().getSelectedEditParts()) {
                    IGraphicalEditPart curPart;
                    EObject designerObj;
                    if (2 == editpart.getSelected()) {
                        primarySelection = editpart;
                    }
                    domain = editpart.getViewer().getEditDomain();
                    if (!(editpart instanceof IGraphicalEditPart) || !(editpart instanceof ISiriusEditPart) || !((designerObj = (curPart = (IGraphicalEditPart)editpart).resolveSemanticElement()) instanceof DSemanticDecorator)) continue;
                    selectedViews.add((DSemanticDecorator)designerObj);
                }
                if (diagrampart.getDiagramGraphicalViewer().getSelectedEditParts().size() == 0) {
                    domain = diagrampart.getDiagramEditPart().getViewer().getEditDomain();
                    selectedViews.add((DSemanticDecorator)designerDiag);
                    primarySelection = diagrampart.getDiagramEditPart();
                }
                if (domain != null && selectedViews.size() > 0) {
                    Option<IAction> action;
                    Point relativeCursorLocationToPrimarySelection = this.getCurrentLocation(primarySelection);
                    for (PopupMenu popMenu : new HashSet(activatedPopupMenus)) {
                        Option<? extends IContributionItem> contributionItem = this.buildContributionItemToAdd(domain, selectedViews, popMenu, emfCommandFactory, primarySelection, relativeCursorLocationToPrimarySelection);
                        if (!contributionItem.some()) continue;
                        menu.appendToGroup("additions", (IContributionItem)contributionItem.get());
                    }
                    for (OperationAction operationAction : new HashSet(activatedOperationActionMenus)) {
                        action = this.buildActionToAdd(domain, selectedViews, (MenuItemDescription)operationAction, emfCommandFactory, primarySelection, relativeCursorLocationToPrimarySelection);
                        if (!action.some()) continue;
                        menu.appendToGroup("additions", (IAction)action.get());
                    }
                    for (ExternalJavaAction externalJavaAction : new HashSet(activatedExternalJavaActionMenus)) {
                        action = this.buildActionToAdd(domain, selectedViews, (MenuItemDescription)externalJavaAction, emfCommandFactory, primarySelection, relativeCursorLocationToPrimarySelection);
                        if (!action.some()) continue;
                        menu.appendToGroup("additions", (IAction)action.get());
                    }
                }
            }
        }
    }

    protected Point getCurrentLocation(EditPart primarySelection) {
        org.eclipse.swt.graphics.Point cursorLocation = PlatformUI.getWorkbench().getDisplay().getCursorLocation();
        FigureCanvas control = (FigureCanvas)primarySelection.getRoot().getViewer().getControl();
        org.eclipse.swt.graphics.Point screenRelativeSWTPoint = control.toControl(cursorLocation);
        EditPart editPartUnderMouse = primarySelection.getRoot().getViewer().findObjectAtExcluding(new Point(screenRelativeSWTPoint.x, screenRelativeSWTPoint.y), (Collection)Collections.EMPTY_LIST);
        Point currentLocation = new Point(screenRelativeSWTPoint.x, screenRelativeSWTPoint.y);
        if (editPartUnderMouse instanceof GraphicalEditPart) {
            IFigure fig = ((GraphicalEditPart)editPartUnderMouse).getFigure();
            fig.translateToRelative((Translatable)currentLocation);
            Point containerLocation = fig.getBounds().getLocation();
            currentLocation = new Point(currentLocation.x - Math.max(0, containerLocation.x), currentLocation.y - Math.max(0, containerLocation.y));
            if (fig instanceof ResizableCompartmentFigure) {
                Point scrollOffset = ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                Point shiftFromMarginOffset = FigureUtilities.getShiftFromMarginOffset((ResizableCompartmentFigure)fig, false, editPartUnderMouse);
                currentLocation = new Point(currentLocation.x + scrollOffset.x - shiftFromMarginOffset.x, currentLocation.y + scrollOffset.y - shiftFromMarginOffset.y);
            }
        }
        return currentLocation;
    }

    private void computeReusedTools(EList<? extends ToolEntry> reusedTools, EList<PopupMenu> activatedPopupMenus, EList<ExternalJavaAction> activatedExternalJavaActionMenus, EList<OperationAction> activatedOperationActionMenus) {
        for (ToolEntry abstractToolDescription : reusedTools) {
            if (abstractToolDescription instanceof PopupMenu) {
                activatedPopupMenus.add((Object)((PopupMenu)abstractToolDescription));
                continue;
            }
            if (abstractToolDescription instanceof OperationAction) {
                activatedOperationActionMenus.add((Object)((OperationAction)abstractToolDescription));
                continue;
            }
            if (!(abstractToolDescription instanceof ExternalJavaAction)) continue;
            activatedExternalJavaActionMenus.add((Object)((ExternalJavaAction)abstractToolDescription));
        }
    }

    private Option<? extends IContributionItem> buildContributionItemToAdd(EditDomain domain, Collection<DSemanticDecorator> selectedViews, PopupMenu popupMenu, IDiagramCommandFactory emfCommandFactory, EditPart primarySelection, Point currentMouseLocation) {
        EObject semantic = selectedViews.iterator().next().getTarget();
        MenuManager subMenu = new MenuManager(MessageTranslator.INSTANCE.getMessage((EObject)popupMenu, new IdentifiedElementQuery((IdentifiedElement)popupMenu).getLabel()), popupMenu.getName().toLowerCase());
        EList activatedAction = popupMenu.getMenuItemDescription();
        IInterpreter interpreter = null;
        if (semantic != null && semantic.eResource() != null) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        } else if (semantic instanceof DMappingBased) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)((DMappingBased)semantic).getMapping());
        }
        Boolean menuPrecondition = StringUtil.isEmpty((String)popupMenu.getPrecondition()) ? Boolean.valueOf(true) : Boolean.valueOf(RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semantic, (EObject)popupMenu, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition()));
        if (menuPrecondition.booleanValue()) {
            for (MenuItemDescription menuItemDescription : activatedAction) {
                IAction action;
                if (interpreter == null || !this.preconditionHolds(menuItemDescription, selectedViews, semantic, interpreter).booleanValue() || (action = this.buildMenuItemAction(menuItemDescription, selectedViews, domain, emfCommandFactory, interpreter, primarySelection, currentMouseLocation)) == null) continue;
                subMenu.add(action);
            }
        } else {
            subMenu.removeAll();
        }
        if (subMenu.getSize() > 0) {
            subMenu.setVisible(true);
            return Options.newSome((Object)subMenu);
        }
        return Options.newNone();
    }

    private Boolean preconditionHolds(MenuItemDescription menuItemDescription, Collection<DSemanticDecorator> selectedViews, EObject semantic, IInterpreter interpreter) {
        Boolean precondition;
        if (StringUtil.isEmpty((String)menuItemDescription.getPrecondition())) {
            precondition = true;
        } else {
            if (menuItemDescription instanceof OperationAction) {
                interpreter.setVariable(((OperationAction)menuItemDescription).getView().getName(), selectedViews);
            }
            try {
                precondition = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semantic, (EObject)menuItemDescription, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
            }
            finally {
                if (menuItemDescription instanceof OperationAction) {
                    interpreter.unSetVariable(((OperationAction)menuItemDescription).getView().getName());
                }
            }
        }
        return precondition;
    }

    private Option<IAction> buildActionToAdd(EditDomain domain, Collection<DSemanticDecorator> selectedViews, MenuItemDescription menuItemDescription, IDiagramCommandFactory emfCommandFactory, EditPart primarySelection, Point currentMouseLocation) {
        IAction action;
        EObject semantic = selectedViews.iterator().next().getTarget();
        IInterpreter interpreter = null;
        if (semantic != null && semantic.eResource() != null) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
        } else if (semantic instanceof DMappingBased) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)((DMappingBased)semantic).getMapping());
        }
        if (interpreter != null && this.preconditionHolds(menuItemDescription, selectedViews, semantic, interpreter).booleanValue() && (action = this.buildMenuItemAction(menuItemDescription, selectedViews, domain, emfCommandFactory, interpreter, primarySelection, currentMouseLocation)) != null) {
            return Options.newSome((Object)action);
        }
        return Options.newNone();
    }

    private IAction buildMenuItemAction(MenuItemDescription menuItemDescription, Collection<DSemanticDecorator> selectedViews, EditDomain domain, IDiagramCommandFactory emfCommandFactory, IInterpreter interpreter, EditPart primarySelection, Point currentMouseLocation) {
        OperationAction operation;
        IAction result = null;
        if (menuItemDescription instanceof ExternalJavaAction) {
            ExternalJavaAction javaAction = (ExternalJavaAction)menuItemDescription;
            if (javaAction.getId() != null && !"".equalsIgnoreCase(javaAction.getId())) {
                result = this.buildJavaAction(javaAction, selectedViews, domain, emfCommandFactory, interpreter, currentMouseLocation);
            }
        } else if (menuItemDescription instanceof OperationAction && (operation = (OperationAction)menuItemDescription).getInitialOperation().getFirstModelOperations() != null) {
            result = this.buildOperationAction(operation, selectedViews, domain, emfCommandFactory, primarySelection, currentMouseLocation);
        }
        return result;
    }

    private IAction buildJavaAction(ExternalJavaAction javaActionMenuItem, Collection<DSemanticDecorator> selectedViews, final EditDomain domain, IDiagramCommandFactory emfCommandFactory, IInterpreter interpreter, Point currentMouseLocation) {
        IExternalJavaAction javaAction = ExternalJavaActionProvider.INSTANCE.getJavaActionById(javaActionMenuItem.getId());
        Action result = null;
        ImageDescriptor imageDescriptor = null;
        if (javaAction != null) {
            Command command = emfCommandFactory.buildJavaActionFromTool(javaActionMenuItem, selectedViews, javaAction);
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)((EObject)selectedViews.iterator().next()));
            final GMFCommandWrapper gefCommandWrapper = new GMFCommandWrapper(transactionalEditingDomain, command);
            if (command.canExecute()) {
                if (javaActionMenuItem.getIcon() != null && !"".equals(javaActionMenuItem.getIcon())) {
                    imageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor(javaActionMenuItem.getIcon());
                }
                result = new Action(new IdentifiedElementQuery((IdentifiedElement)javaActionMenuItem).getLabel(), imageDescriptor){

                    public void run() {
                        super.run();
                        domain.getCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)gefCommandWrapper));
                    }
                };
            }
        }
        return result;
    }

    private IAction buildOperationAction(OperationAction operationAction, Collection<DSemanticDecorator> selectedViews, final EditDomain domain, IDiagramCommandFactory emfCommandFactory, final EditPart primarySelection, final Point currentMouseLocation) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)((EObject)selectedViews.iterator().next()));
        Command command = emfCommandFactory.buildOperationActionFromTool(operationAction, selectedViews);
        final CompoundCommand cc = new CompoundCommand(command.getLabel());
        cc.add(new org.eclipse.gef.commands.Command(Messages.PopupMenuContribution_storeMouseLocationCmdLabel){

            public void execute() {
                SiriusLayoutDataManager.INSTANCE.addData(new RootLayoutData(primarySelection, currentMouseLocation.getCopy(), new Dimension(-1, -1)));
            }
        });
        cc.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new GMFCommandWrapper(transactionalEditingDomain, command)));
        ImageDescriptor imageDescriptor = null;
        if (operationAction.getIcon() != null && !"".equals(operationAction.getIcon())) {
            imageDescriptor = DiagramUIPlugin.Implementation.findImageDescriptor(operationAction.getIcon());
        }
        return new Action(MessageTranslator.INSTANCE.getMessage((EObject)operationAction, new IdentifiedElementQuery((IdentifiedElement)operationAction).getLabel()), imageDescriptor){

            public void run() {
                super.run();
                domain.getCommandStack().execute((org.eclipse.gef.commands.Command)cc);
            }
        };
    }

    public void disposeContributions(IWorkbenchPartDescriptor arg0) {
    }

    public void updateActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void addProviderChangeListener(IProviderChangeListener arg0) {
    }

    public boolean provides(IOperation arg0) {
        return true;
    }

    public void removeProviderChangeListener(IProviderChangeListener arg0) {
    }
}

