/**
 * Copyright (c) 2007, 2013 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *
 */
package org.eclipse.sirius.viewpoint.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration ' <em><b>System Colors</b></em>', and
 * utility methods for working with them. <!-- end-user-doc --> <!-- begin-model-doc --> The list of colors available in
 * the system palette. <!-- end-model-doc -->
 *
 * @see org.eclipse.sirius.viewpoint.description.DescriptionPackage#getSystemColors()
 * @model
 * @generated
 */
public enum SystemColors implements Enumerator {
    /**
     * The '<em><b>Black</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #BLACK
     * @generated
     * @ordered
     */
    BLACK_LITERAL(0, "black", "black"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Blue</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #BLUE
     * @generated
     * @ordered
     */
    BLUE_LITERAL(1, "blue", "blue"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Red</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #RED
     * @generated
     * @ordered
     */
    RED_LITERAL(2, "red", "red"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Green</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #GREEN
     * @generated
     * @ordered
     */
    GREEN_LITERAL(3, "green", "green"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Yellow</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #YELLOW
     * @generated
     * @ordered
     */
    YELLOW_LITERAL(4, "yellow", "yellow"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Purple</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #PURPLE
     * @generated
     * @ordered
     */
    PURPLE_LITERAL(5, "purple", "purple"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Orange</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #ORANGE
     * @generated
     * @ordered
     */
    ORANGE_LITERAL(6, "orange", "orange"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Chocolate</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #CHOCOLATE
     * @generated
     * @ordered
     */
    CHOCOLATE_LITERAL(7, "chocolate", "chocolate"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Gray</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #GRAY
     * @generated
     * @ordered
     */
    GRAY_LITERAL(8, "gray", "gray"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>White</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #WHITE
     * @generated
     * @ordered
     */
    WHITE_LITERAL(9, "white", "white"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark blue</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_BLUE
     * @generated
     * @ordered
     */
    DARK_BLUE_LITERAL(11, "dark_blue", "dark_blue"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark red</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_RED
     * @generated
     * @ordered
     */
    DARK_RED_LITERAL(12, "dark_red", "dark_red"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark green</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_GREEN
     * @generated
     * @ordered
     */
    DARK_GREEN_LITERAL(13, "dark_green", "dark_green"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark yellow</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_YELLOW
     * @generated
     * @ordered
     */
    DARK_YELLOW_LITERAL(14, "dark_yellow", "dark_yellow"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark purple</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_PURPLE
     * @generated
     * @ordered
     */
    DARK_PURPLE_LITERAL(15, "dark_purple", "dark_purple"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark orange</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_ORANGE
     * @generated
     * @ordered
     */
    DARK_ORANGE_LITERAL(16, "dark_orange", "dark_orange"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark chocolate</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_CHOCOLATE
     * @generated
     * @ordered
     */
    DARK_CHOCOLATE_LITERAL(17, "dark_chocolate", "dark_chocolate"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Dark gray</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #DARK_GRAY
     * @generated
     * @ordered
     */
    DARK_GRAY_LITERAL(18, "dark_gray", "dark_gray"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light blue</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_BLUE
     * @generated
     * @ordered
     */
    LIGHT_BLUE_LITERAL(21, "light_blue", "light_blue"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light red</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_RED
     * @generated
     * @ordered
     */
    LIGHT_RED_LITERAL(22, "light_red", "light_red"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light green</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_GREEN
     * @generated
     * @ordered
     */
    LIGHT_GREEN_LITERAL(23, "light_green", "light_green"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light yellow</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_YELLOW
     * @generated
     * @ordered
     */
    LIGHT_YELLOW_LITERAL(24, "light_yellow", "light_yellow"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light purple</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_PURPLE
     * @generated
     * @ordered
     */
    LIGHT_PURPLE_LITERAL(25, "light_purple", "light_purple"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light orange</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_ORANGE
     * @generated
     * @ordered
     */
    LIGHT_ORANGE_LITERAL(26, "light_orange", "light_orange"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light chocolate</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_CHOCOLATE
     * @generated
     * @ordered
     */
    LIGHT_CHOCOLATE_LITERAL(27, "light_chocolate", "light_chocolate"), //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Light gray</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #LIGHT_GRAY
     * @generated
     * @ordered
     */
    LIGHT_GRAY_LITERAL(28, "light_gray", "light_gray"); //$NON-NLS-1$ //$NON-NLS-2$

    /**
     * The '<em><b>Black</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Black</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #BLACK_LITERAL
     * @model name="black"
     * @generated
     * @ordered
     */
    public static final int BLACK = 0;

    /**
     * The '<em><b>Blue</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Blue</b></em>' literal object isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #BLUE_LITERAL
     * @model name="blue"
     * @generated
     * @ordered
     */
    public static final int BLUE = 1;

    /**
     * The '<em><b>Red</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Red</b></em>' literal object isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #RED_LITERAL
     * @model name="red"
     * @generated
     * @ordered
     */
    public static final int RED = 2;

    /**
     * The '<em><b>Green</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Green</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #GREEN_LITERAL
     * @model name="green"
     * @generated
     * @ordered
     */
    public static final int GREEN = 3;

    /**
     * The '<em><b>Yellow</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Yellow</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #YELLOW_LITERAL
     * @model name="yellow"
     * @generated
     * @ordered
     */
    public static final int YELLOW = 4;

    /**
     * The '<em><b>Purple</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Purple</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #PURPLE_LITERAL
     * @model name="purple"
     * @generated
     * @ordered
     */
    public static final int PURPLE = 5;

    /**
     * The '<em><b>Orange</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Orange</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #ORANGE_LITERAL
     * @model name="orange"
     * @generated
     * @ordered
     */
    public static final int ORANGE = 6;

    /**
     * The '<em><b>Chocolate</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Chocolate</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #CHOCOLATE_LITERAL
     * @model name="chocolate"
     * @generated
     * @ordered
     */
    public static final int CHOCOLATE = 7;

    /**
     * The '<em><b>Gray</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Gray</b></em>' literal object isn't clear, there really should be more of a description
     * here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #GRAY_LITERAL
     * @model name="gray"
     * @generated
     * @ordered
     */
    public static final int GRAY = 8;

    /**
     * The '<em><b>White</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>White</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #WHITE_LITERAL
     * @model name="white"
     * @generated
     * @ordered
     */
    public static final int WHITE = 9;

    /**
     * The '<em><b>Dark blue</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark blue</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_BLUE_LITERAL
     * @model name="dark_blue"
     * @generated
     * @ordered
     */
    public static final int DARK_BLUE = 11;

    /**
     * The '<em><b>Dark red</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark red</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_RED_LITERAL
     * @model name="dark_red"
     * @generated
     * @ordered
     */
    public static final int DARK_RED = 12;

    /**
     * The '<em><b>Dark green</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark green</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_GREEN_LITERAL
     * @model name="dark_green"
     * @generated
     * @ordered
     */
    public static final int DARK_GREEN = 13;

    /**
     * The '<em><b>Dark yellow</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark yellow</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_YELLOW_LITERAL
     * @model name="dark_yellow"
     * @generated
     * @ordered
     */
    public static final int DARK_YELLOW = 14;

    /**
     * The '<em><b>Dark purple</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark purple</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_PURPLE_LITERAL
     * @model name="dark_purple"
     * @generated
     * @ordered
     */
    public static final int DARK_PURPLE = 15;

    /**
     * The '<em><b>Dark orange</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark orange</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_ORANGE_LITERAL
     * @model name="dark_orange"
     * @generated
     * @ordered
     */
    public static final int DARK_ORANGE = 16;

    /**
     * The '<em><b>Dark chocolate</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark chocolate</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_CHOCOLATE_LITERAL
     * @model name="dark_chocolate"
     * @generated
     * @ordered
     */
    public static final int DARK_CHOCOLATE = 17;

    /**
     * The '<em><b>Dark gray</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Dark gray</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #DARK_GRAY_LITERAL
     * @model name="dark_gray"
     * @generated
     * @ordered
     */
    public static final int DARK_GRAY = 18;

    /**
     * The '<em><b>Light blue</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light blue</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_BLUE_LITERAL
     * @model name="light_blue"
     * @generated
     * @ordered
     */
    public static final int LIGHT_BLUE = 21;

    /**
     * The '<em><b>Light red</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light red</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_RED_LITERAL
     * @model name="light_red"
     * @generated
     * @ordered
     */
    public static final int LIGHT_RED = 22;

    /**
     * The '<em><b>Light green</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light green</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_GREEN_LITERAL
     * @model name="light_green"
     * @generated
     * @ordered
     */
    public static final int LIGHT_GREEN = 23;

    /**
     * The '<em><b>Light yellow</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light yellow</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_YELLOW_LITERAL
     * @model name="light_yellow"
     * @generated
     * @ordered
     */
    public static final int LIGHT_YELLOW = 24;

    /**
     * The '<em><b>Light purple</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light purple</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_PURPLE_LITERAL
     * @model name="light_purple"
     * @generated
     * @ordered
     */
    public static final int LIGHT_PURPLE = 25;

    /**
     * The '<em><b>Light orange</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light orange</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_ORANGE_LITERAL
     * @model name="light_orange"
     * @generated
     * @ordered
     */
    public static final int LIGHT_ORANGE = 26;

    /**
     * The '<em><b>Light chocolate</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light chocolate</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_CHOCOLATE_LITERAL
     * @model name="light_chocolate"
     * @generated
     * @ordered
     */
    public static final int LIGHT_CHOCOLATE = 27;

    /**
     * The '<em><b>Light gray</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>Light gray</b></em>' literal object isn't clear, there really should be more of a
     * description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #LIGHT_GRAY_LITERAL
     * @model name="light_gray"
     * @generated
     * @ordered
     */
    public static final int LIGHT_GRAY = 28;

    /**
     * An array of all the '<em><b>System Colors</b></em>' enumerators. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private static final SystemColors[] VALUES_ARRAY = new SystemColors[] { BLACK_LITERAL, BLUE_LITERAL, RED_LITERAL, GREEN_LITERAL, YELLOW_LITERAL, PURPLE_LITERAL, ORANGE_LITERAL, CHOCOLATE_LITERAL,
            GRAY_LITERAL, WHITE_LITERAL, DARK_BLUE_LITERAL, DARK_RED_LITERAL, DARK_GREEN_LITERAL, DARK_YELLOW_LITERAL, DARK_PURPLE_LITERAL, DARK_ORANGE_LITERAL, DARK_CHOCOLATE_LITERAL,
            DARK_GRAY_LITERAL, LIGHT_BLUE_LITERAL, LIGHT_RED_LITERAL, LIGHT_GREEN_LITERAL, LIGHT_YELLOW_LITERAL, LIGHT_PURPLE_LITERAL, LIGHT_ORANGE_LITERAL, LIGHT_CHOCOLATE_LITERAL,
            LIGHT_GRAY_LITERAL, };

    /**
     * A public read-only list of all the '<em><b>System Colors</b></em>' enumerators. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    public static final List<SystemColors> VALUES = Collections.unmodifiableList(Arrays.asList(SystemColors.VALUES_ARRAY));

    /**
     * Returns the '<em><b>System Colors</b></em>' literal with the specified literal value. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @param literal
     *            the literal.
     * @return the matching enumerator or <code>null</code>.
     * @generated
     */
    public static SystemColors get(String literal) {
        for (SystemColors result : SystemColors.VALUES_ARRAY) {
            if (result.toString().equals(literal)) {
                return result;
            }
        }
        return null;
    }

    /**
     * Returns the '<em><b>System Colors</b></em>' literal with the specified name. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @param name
     *            the name.
     * @return the matching enumerator or <code>null</code>.
     * @generated
     */
    public static SystemColors getByName(String name) {
        for (SystemColors result : SystemColors.VALUES_ARRAY) {
            if (result.getName().equals(name)) {
                return result;
            }
        }
        return null;
    }

    /**
     * Returns the '<em><b>System Colors</b></em>' literal with the specified integer value. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @param value
     *            the integer value.
     * @return the matching enumerator or <code>null</code>.
     * @generated
     */
    public static SystemColors get(int value) {
        switch (value) {
        case BLACK:
            return BLACK_LITERAL;
        case BLUE:
            return BLUE_LITERAL;
        case RED:
            return RED_LITERAL;
        case GREEN:
            return GREEN_LITERAL;
        case YELLOW:
            return YELLOW_LITERAL;
        case PURPLE:
            return PURPLE_LITERAL;
        case ORANGE:
            return ORANGE_LITERAL;
        case CHOCOLATE:
            return CHOCOLATE_LITERAL;
        case GRAY:
            return GRAY_LITERAL;
        case WHITE:
            return WHITE_LITERAL;
        case DARK_BLUE:
            return DARK_BLUE_LITERAL;
        case DARK_RED:
            return DARK_RED_LITERAL;
        case DARK_GREEN:
            return DARK_GREEN_LITERAL;
        case DARK_YELLOW:
            return DARK_YELLOW_LITERAL;
        case DARK_PURPLE:
            return DARK_PURPLE_LITERAL;
        case DARK_ORANGE:
            return DARK_ORANGE_LITERAL;
        case DARK_CHOCOLATE:
            return DARK_CHOCOLATE_LITERAL;
        case DARK_GRAY:
            return DARK_GRAY_LITERAL;
        case LIGHT_BLUE:
            return LIGHT_BLUE_LITERAL;
        case LIGHT_RED:
            return LIGHT_RED_LITERAL;
        case LIGHT_GREEN:
            return LIGHT_GREEN_LITERAL;
        case LIGHT_YELLOW:
            return LIGHT_YELLOW_LITERAL;
        case LIGHT_PURPLE:
            return LIGHT_PURPLE_LITERAL;
        case LIGHT_ORANGE:
            return LIGHT_ORANGE_LITERAL;
        case LIGHT_CHOCOLATE:
            return LIGHT_CHOCOLATE_LITERAL;
        case LIGHT_GRAY:
            return LIGHT_GRAY_LITERAL;
        }
        return null;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private final int value;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private final String name;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private final String literal;

    /**
     * Only this class can construct instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private SystemColors(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int getValue() {
        return value;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String getLiteral() {
        return literal;
    }

    /**
     * Returns the literal value of the enumerator, which is its string representation. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String toString() {
        return literal;
    }

} // SystemColors
