/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQueryProvider;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.business.internal.dialect.description.InterpretedExpressionQueryProviderRegistry;
import org.eclipse.sirius.business.internal.helper.delete.DeleteHookDescriptorRegistryListener;
import org.eclipse.sirius.business.internal.helper.task.ModelOperationManagerRegistryListener;
import org.eclipse.sirius.business.internal.resource.strategy.ResourceStrategyRegistryListener;
import org.eclipse.sirius.business.internal.session.factory.SessionFactoryRegistryListener;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessorsRegistry;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tools.internal.ui.ExternalJavaActionRegistryListener;
import org.eclipse.sirius.tools.internal.validation.EValidatorAdapter;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.osgi.framework.BundleContext;

public final class SiriusPlugin
extends EMFPlugin {
    public static final boolean IS_ECLIPSE_RUNNING;
    public static final String ID = "org.eclipse.sirius";
    public static final SiriusPlugin INSTANCE;
    private static Implementation plugin;
    private static final ModelAccessorsRegistry REGISTRY;

    static {
        boolean result = false;
        try {
            result = Platform.isRunning();
        }
        catch (Throwable throwable) {}
        IS_ECLIPSE_RUNNING = result;
        INSTANCE = new SiriusPlugin();
        REGISTRY = new ModelAccessorsRegistry();
    }

    public SiriusPlugin() {
        super(new ResourceLocator[]{EcorePlugin.INSTANCE, INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getDefault() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private InterpreterRegistry interRegistry;
        private SessionFactoryRegistryListener sessionFactoryRegistryListener;
        private DeleteHookDescriptorRegistryListener deleteHookDescriptorRegistryListener;
        private ExternalJavaActionRegistryListener javaActionRegistryListener;
        private ResourceStrategyRegistryListener resourceStrategyRegistryListener;
        private ModelOperationManagerRegistryListener modelOperationManagerRegistryListener;
        private InterpretedExpressionQueryProviderRegistry expressionQueryProviderRegistry;
        private UICallBack uiCallback;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            this.interRegistry = new InterpreterRegistry();
            EValidator.Registry.INSTANCE.put((Object)ViewpointPackage.eINSTANCE, (Object)new EValidatorAdapter());
            EValidator.Registry.INSTANCE.put((Object)DescriptionPackage.eINSTANCE, (Object)new EValidatorAdapter());
            EValidator.Registry.INSTANCE.put((Object)ToolPackage.eINSTANCE, (Object)new EValidatorAdapter());
            this.sessionFactoryRegistryListener = new SessionFactoryRegistryListener();
            this.sessionFactoryRegistryListener.init();
            this.deleteHookDescriptorRegistryListener = new DeleteHookDescriptorRegistryListener();
            this.deleteHookDescriptorRegistryListener.init();
            this.javaActionRegistryListener = new ExternalJavaActionRegistryListener();
            this.javaActionRegistryListener.init();
            this.resourceStrategyRegistryListener = new ResourceStrategyRegistryListener();
            this.resourceStrategyRegistryListener.init();
            this.modelOperationManagerRegistryListener = new ModelOperationManagerRegistryListener();
            this.modelOperationManagerRegistryListener.init();
            this.expressionQueryProviderRegistry = new InterpretedExpressionQueryProviderRegistry(Platform.getExtensionRegistry(), (Plugin)this);
            this.expressionQueryProviderRegistry.init();
        }

        public Collection<IInterpretedExpressionQueryProvider> getInterpretedExpressionQueryProviders() {
            return this.expressionQueryProviderRegistry.getEntries();
        }

        public void stop(BundleContext context) throws Exception {
            REGISTRY.dispose();
            this.sessionFactoryRegistryListener.dispose();
            this.sessionFactoryRegistryListener = null;
            this.deleteHookDescriptorRegistryListener.dispose();
            this.deleteHookDescriptorRegistryListener = null;
            this.javaActionRegistryListener.dispose();
            this.javaActionRegistryListener = null;
            this.resourceStrategyRegistryListener.dispose();
            this.resourceStrategyRegistryListener = null;
            this.modelOperationManagerRegistryListener.dispose();
            this.modelOperationManagerRegistryListener = null;
            this.expressionQueryProviderRegistry.dispose();
            this.expressionQueryProviderRegistry = null;
            ViewpointRegistry.getInstance().dispose();
            MultiLanguagesValidator.getInstance().dispose();
            super.stop(context);
        }

        public ModelAccessorsRegistry getModelAccessorRegistry() {
            return REGISTRY;
        }

        public InterpreterRegistry getInterpreterRegistry() {
            return this.interRegistry;
        }

        public void error(String message, Throwable e) {
            String messageToDisplay = message;
            if (messageToDisplay == null && e != null) {
                messageToDisplay = e.getMessage();
            }
            if (e instanceof CoreException) {
                this.getLog().log(((CoreException)e).getStatus());
            } else {
                Status status = new Status(4, SiriusPlugin.getDefault().getSymbolicName(), messageToDisplay, e);
                this.getLog().log((IStatus)status);
            }
        }

        public void warning(String message, Exception e) {
            String messageToDisplay = message;
            if (messageToDisplay == null && e != null) {
                messageToDisplay = e.getMessage();
            }
            if (e instanceof CoreException) {
                this.getLog().log(((CoreException)e).getStatus());
            } else {
                Status status = new Status(2, SiriusPlugin.getDefault().getSymbolicName(), messageToDisplay, (Throwable)e);
                this.getLog().log((IStatus)status);
            }
        }

        public UICallBack getUiCallback() {
            return this.uiCallback;
        }

        public void setUiCallback(UICallBack uiCallback) {
            this.uiCallback = uiCallback;
        }
    }
}

