/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.VerticalPositionFunction;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public final class SequenceGraphicalHelper {
    private SequenceGraphicalHelper() {
    }

    public static EventEnd getEndBefore(SequenceDDiagram diagram, int y) {
        VerticalPositionFunction vpf = new VerticalPositionFunction(diagram);
        for (EventEnd end : Lists.reverse((List)diagram.getGraphicalOrdering().getEventEnds())) {
            int pos = vpf.apply(end);
            if (pos == Integer.MAX_VALUE || pos > y) continue;
            return end;
        }
        return null;
    }

    public static EObject getInstanceRoleBefore(SequenceDDiagram diagram, int x) {
        Option seqDiag;
        Iterable diagramViews = Iterables.filter((Iterable)ISequenceElementAccessor.getViewsForSemanticElement((SequenceDDiagram)diagram, (EObject)diagram.getTarget()), Diagram.class);
        if (!Iterables.isEmpty((Iterable)diagramViews) && (seqDiag = ISequenceElementAccessor.getSequenceDiagram((Diagram)((Diagram)diagramViews.iterator().next()))).some()) {
            for (InstanceRole ir : Lists.reverse((List)((SequenceDiagram)seqDiag.get()).getSortedInstanceRole())) {
                int pos = ir.getProperLogicalBounds().x;
                if (pos > x) continue;
                return (EObject)ir.getSemanticTargetElement().get();
            }
        }
        return null;
    }

    public static EventEnd getEndAfter(SequenceDDiagram diagram, int y) {
        VerticalPositionFunction vpf = new VerticalPositionFunction(diagram);
        for (EventEnd end : diagram.getGraphicalOrdering().getEventEnds()) {
            int pos = vpf.apply(end);
            if (pos == Integer.MAX_VALUE || pos <= y) continue;
            return end;
        }
        return null;
    }

    public static int getAbsoluteYCenterFromGMFView(IGraphicalEditPart part) {
        if (part instanceof ShapeNodeEditPart) {
            Rectangle absoluteboundsRectangle = SequenceGraphicalHelper.getAbsoluteBoundsFromGMFView(part);
            return absoluteboundsRectangle.getCenter().y;
        }
        Point location = part.getFigure().getBounds().getCenter().getCopy();
        GraphicalHelper.screen2logical((Point)location, (IGraphicalEditPart)part);
        return location.y;
    }

    public static Rectangle getAbsoluteBoundsFromGMFView(IGraphicalEditPart part) {
        Rectangle rect = part.getFigure().getBounds().getCopy();
        if (part instanceof LifelineEditPart) {
            SequenceGraphicalHelper.handleLifelineEditPartOffset(rect);
        }
        if (part.getNotationView() instanceof Node) {
            Node node = (Node)part.getNotationView();
            Point absLoc = GMFNotationHelper.getAbsoluteLocation((Node)node);
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Bounds) {
                Bounds bounds = (Bounds)layoutConstraint;
                rect.setLocation(absLoc.x, absLoc.y);
                if (bounds.getWidth() != -1) {
                    rect.width = bounds.getWidth();
                }
                if (bounds.getHeight() != -1) {
                    rect.height = bounds.getHeight();
                }
                if (!(part instanceof InstanceRoleEditPart)) {
                    SequenceGraphicalHelper.handleLifelineEditPartOffset(rect);
                }
            }
        }
        return rect;
    }

    private static void handleLifelineEditPartOffset(Rectangle rect) {
        rect.translate(0, IBorderItemOffsets.DEFAULT_OFFSET.height);
    }

    public static int getAnchorAbsolutePosition(IdentityAnchor anchor, Range range) {
        PrecisionPoint rel = anchor != null ? BaseSlidableAnchor.parseTerminalString((String)anchor.getId()) : new PrecisionPoint(0.5, 0.5);
        return range.getLowerBound() + (int)Math.round(rel.preciseY() * (double)range.width());
    }
}

