/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data;

import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.ILostElementDataContainer;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataState;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataUtil;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataWithMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class LostEdgeData
extends LostElementDataWithMapping {
    private ILostElementDataContainer sourceData;
    private ILostElementDataContainer targetData;

    public void setSourceData(ILostElementDataContainer sourceData) {
        this.sourceData = sourceData;
    }

    public ILostElementDataContainer getSourceData() {
        return this.sourceData;
    }

    public void setTargetData(ILostElementDataContainer targetData) {
        this.targetData = targetData;
    }

    public ILostElementDataContainer getTargetData() {
        return this.targetData;
    }

    @Override
    protected LostElementDataState doRecreateNonExistingLostElement(DSemanticDiagram designerDiagram) {
        LostElementDataState result = super.doRecreateNonExistingLostElement(designerDiagram);
        if (this.getSourceData() != null && this.getTargetData() != null && this.getMapping() instanceof EdgeMapping) {
            DDiagramElement sourceElement = LostElementDataUtil.findDesignerDiagramElement(designerDiagram, this.getSourceData());
            DDiagramElement targetElement = LostElementDataUtil.findDesignerDiagramElement(designerDiagram, this.getTargetData());
            if (sourceElement instanceof EdgeTarget && targetElement instanceof EdgeTarget) {
                EdgeMapping edgeMapping = (EdgeMapping)this.getMapping();
                DEdge dEdge = edgeMapping.createEdge((EdgeTarget)((Object)sourceElement), (EdgeTarget)((Object)targetElement), designerDiagram, this.getTarget());
                if (designerDiagram.getOwnedDiagramElements().add((Object)dEdge)) {
                    result = LostElementDataState.CREATED;
                }
            }
        }
        return result;
    }

    @Override
    protected boolean doIsSimilarTo(DDiagramElement diagramElement, RepresentationElementMapping extractedMapping) {
        boolean result = super.doIsSimilarTo(diagramElement, extractedMapping);
        if (result && diagramElement instanceof DEdge) {
            EdgeTarget sourceNode = ((DEdge)diagramElement).getSourceNode();
            EdgeTarget targetNode = ((DEdge)diagramElement).getTargetNode();
            if (this.getSourceData() != null && this.getTargetData() != null && sourceNode instanceof DDiagramElement && targetNode instanceof DDiagramElement) {
                result = this.getSourceData().isSimilarTo((DSemanticDecorator)((DDiagramElement)((Object)sourceNode))) && this.getTargetData().isSimilarTo((DSemanticDecorator)((DDiagramElement)((Object)targetNode)));
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = String.valueOf(super.toString()) + " |--| ";
        result = this.sourceData == null ? String.valueOf(result) + "No source data" : String.valueOf(result) + "Source data: " + this.sourceData.toString();
        result = this.targetData == null ? String.valueOf(result) + "No target data" : String.valueOf(result) + "Target data: " + this.targetData.toString();
        return result;
    }
}

