/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshSemanticOrderingsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SynchronizeGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.command.DoNothingCommand;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.util.EditPartTools;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class SequenceLayoutProvider
extends AbstractLayoutProvider {
    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        SequenceDiagramEditPart sdep = this.getParentSequenceDiagramEditPart(selectedObjects);
        boolean isArrangeAll = this.isArrangeAll(sdep, selectedObjects);
        if (sdep != null && isArrangeAll) {
            return this.createArrangeAllCommand(sdep);
        }
        return DoNothingCommand.INSTANCE;
    }

    private boolean isArrangeAll(SequenceDiagramEditPart sdep, List selectedObjects) {
        boolean result = false;
        if (sdep != null && selectedObjects != null) {
            result = sdep.getChildren().size() == selectedObjects.size() && sdep.getChildren().containsAll(selectedObjects);
        }
        return result;
    }

    private Command createArrangeAllCommand(SequenceDiagramEditPart sdep) {
        TransactionalEditingDomain transactionalEditingDomain = sdep.getEditingDomain();
        SequenceDiagram sequenceDiagram = sdep.getSequenceDiagram();
        SequenceDDiagram sequenceDDiagram = (SequenceDDiagram)sdep.resolveSemanticElement();
        ArrayList<Object> operations = new ArrayList<Object>();
        operations.add(new RefreshGraphicalOrderingOperation(sequenceDiagram));
        operations.add(new RefreshSemanticOrderingsOperation(sequenceDDiagram));
        operations.add(new SynchronizeGraphicalOrderingOperation(sdep.getDiagramView(), true));
        ICommand cmd = CommandFactory.createICommand((TransactionalEditingDomain)transactionalEditingDomain, operations);
        cmd.setLabel(Messages.SequenceLayoutProvider_arrangeAllCommand);
        return new ICommandProxy(cmd);
    }

    private SequenceDiagramEditPart getParentSequenceDiagramEditPart(List<?> selectedObjects) {
        if (!selectedObjects.isEmpty()) {
            return (SequenceDiagramEditPart)EditPartTools.getParentOfType((EditPart)((EditPart)selectedObjects.iterator().next()), SequenceDiagramEditPart.class);
        }
        return null;
    }
}

