/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.color;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Color;

public class ColorManager {
    private static ColorManager defaultInstance;
    private Map<String, Color> lighterColorCache = new HashMap<String, Color>();

    protected ColorManager() {
    }

    public static ColorManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ColorManager();
        }
        return defaultInstance;
    }

    public Color getLighterColor(RGBValues colorToLight) {
        String key = this.getKey(colorToLight);
        if (!this.lighterColorCache.containsKey(key)) {
            Color newLighterColor = FigureUtilities.mixColors((Color)VisualBindingManager.getDefault().getColorFromRGBValues(colorToLight), (Color)ColorConstants.white, (double)0.4);
            this.lighterColorCache.put(key, newLighterColor);
        }
        return this.lighterColorCache.get(key);
    }

    private String getKey(RGBValues color) {
        StringBuilder sb = new StringBuilder("Color");
        if (color != null) {
            sb.append("_r:");
            sb.append(color.getRed());
            sb.append("_g:");
            sb.append(color.getGreen());
            sb.append("_b:");
            sb.append(color.getBlue());
        }
        return sb.toString();
    }
}

