/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.session.danalysis.DRepresentationLocationRule;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class DRepresentationLocationManager {
    public Resource getOrCreateRepresentationResource(DRepresentation representation, Resource aird) {
        ResourceSet resourceSet;
        Resource resource = null;
        ResourceSet resourceSet2 = resourceSet = aird != null ? aird.getResourceSet() : null;
        if (resourceSet != null) {
            URI repResourceURI = this.getURIFromExtensionPoint(representation, aird);
            if (repResourceURI == null) {
                repResourceURI = this.getRepURI(representation, aird, resourceSet);
            }
            if ((resource = resourceSet.getResource(repResourceURI, false)) == null) {
                resource = resourceSet.createResource(repResourceURI);
            }
        }
        return resource;
    }

    private URI getRepURI(DRepresentation representation, Resource aird, ResourceSet resourceSet) {
        int count = 0;
        URI repUri = this.createRepURI(aird, representation, count++);
        while (resourceSet.getResource(repUri, false) != null) {
            repUri = this.createRepURI(aird, representation, count++);
        }
        return repUri;
    }

    private URI getURIFromExtensionPoint(DRepresentation representation, Resource dViewResource) {
        ArrayList extensionPointRules = Lists.newArrayList();
        extensionPointRules.addAll(EclipseUtil.getExtensionPlugins(DRepresentationLocationRule.class, (String)"org.eclipse.sirius.dRepresentationLocationRule", (String)"class"));
        Optional<DRepresentationLocationRule> locationRule = extensionPointRules.stream().filter(rule -> rule.provides(representation, dViewResource)).findFirst();
        return locationRule.isPresent() ? locationRule.get().getResourceURI(representation, dViewResource) : null;
    }

    private URI createRepURI(Resource aird, DRepresentation representation, int count) {
        String repName = representation.getName().replace(' ', '_');
        if (count > 0) {
            repName = String.valueOf(repName) + String.valueOf(count);
        }
        URI airdURI = aird.getURI();
        ArrayList<String> srmFileSegments = new ArrayList<String>(airdURI.segmentsList());
        srmFileSegments.remove(srmFileSegments.size() - 1);
        srmFileSegments.add(airdURI.lastSegment().replace(".aird", "_aird"));
        srmFileSegments.add(String.valueOf(repName) + "." + "srm");
        return URI.createHierarchicalURI((String)airdURI.scheme(), (String)airdURI.authority(), (String)airdURI.device(), (String[])srmFileSegments.toArray(new String[srmFileSegments.size()]), (String)airdURI.query(), (String)airdURI.fragment());
    }
}

