/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import java.text.MessageFormat;
import org.eclipse.sirius.tests.swtbot.support.api.business.AbstractUIRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.business.UINewRepresentationBuilderFlow;
import org.eclipse.sirius.tests.swtbot.support.api.condition.ItemEnabledCondition;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusHelper;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.tests.swtbot.support.utils.business.UIRepresentationUtils;
import org.eclipse.sirius.ui.tools.api.Messages;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;

public class UINewRepresentationBuilder<R extends AbstractUIRepresentation<?>>
implements UINewRepresentationBuilderFlow.ItemChoice<R>,
UINewRepresentationBuilderFlow.NameChoice<R>,
UINewRepresentationBuilderFlow.EndFlow<R> {
    private final String representationNameToClick;
    private final String representationDescriptionLabel;
    private String newRepresentationName;
    private final SWTWorkbenchBot mainBot = new SWTWorkbenchBot();
    private SWTBotShell shell;
    private SWTBot shellBot;
    private final Class<R> representationType;

    public UINewRepresentationBuilder(String clickedRepresentationName, String representationDescriptionLabel, Class<R> representationType) {
        this.representationNameToClick = clickedRepresentationName;
        this.representationType = representationType;
        this.representationDescriptionLabel = representationDescriptionLabel;
    }

    @Override
    public UINewRepresentationBuilderFlow.NameChoice<R> on(SWTBotTreeItem treeItem) {
        treeItem.select();
        SWTBotUtils.clickContextMenu(treeItem, this.representationNameToClick);
        this.shell = this.mainBot.shell(MessageFormat.format(Messages.createRepresentationInputDialog_Title, this.representationDescriptionLabel));
        this.shell.activate();
        this.shellBot = new SWTBot(this.shell.widget);
        return this;
    }

    @Override
    public UINewRepresentationBuilderFlow.EndFlow<R> withName(String name) {
        this.newRepresentationName = name;
        SWTBotText text = this.shellBot.text();
        text.setText(this.newRepresentationName);
        return this;
    }

    @Override
    public UINewRepresentationBuilderFlow.EndFlow<R> withDefaultName() {
        SWTBotText text = this.shellBot.text();
        return this.withName(text.getText());
    }

    @Override
    public R ok() {
        return this.ok(false);
    }

    @Override
    public R ok(boolean disableSnapToGridOnThisEditor) {
        SWTBotButton ok = this.shellBot.button("OK");
        this.shellBot.waitUntilWidgetAppears((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)ok));
        ok.click();
        SWTBotUtils.waitProgressMonitorClose("Progress Information");
        this.finish();
        Object swtBotEditor = SWTBotSiriusHelper.getSiriusEditor(this.newRepresentationName);
        swtBotEditor = disableSnapToGridOnThisEditor ? SWTBotSiriusHelper.getSiriusDiagramEditor(this.newRepresentationName) : SWTBotSiriusHelper.getSiriusEditor(this.newRepresentationName);
        if (swtBotEditor != null && disableSnapToGridOnThisEditor) {
            ((SWTBotSiriusDiagramEditor)((Object)swtBotEditor)).setSnapToGrid(false);
        }
        return UIRepresentationUtils.buildRepresentation(null, this.getRealNewRepresentationName(), this.getRepresentationType());
    }

    @Override
    public void cancel() {
        SWTBotButton cancel = this.shellBot.button("Cancel");
        this.shellBot.waitUntilWidgetAppears((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)cancel));
        cancel.click();
        this.finish();
    }

    private void finish() {
        this.mainBot.waitUntil(Conditions.shellCloses((SWTBotShell)this.shell));
        this.mainBot.sleep(500L);
    }

    private String getRealNewRepresentationName() {
        String result = this.newRepresentationName == null ? this.representationNameToClick : this.newRepresentationName;
        return result;
    }

    private Class<R> getRepresentationType() {
        return this.representationType;
    }
}

