/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIProject;
import org.eclipse.sirius.ui.tools.internal.actions.session.OpenSessionAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.junit.Assert;

public class UIResource {
    private final UIProject project;
    private final String path;
    private final List<String> nodePath;
    private final String name;

    public UIResource(UIProject pUIProject, String name) {
        this(pUIProject, "", name);
    }

    public UIResource(UIProject pUIProject, String pPath, String name) {
        this.project = pUIProject;
        this.path = pPath;
        this.name = name;
        this.nodePath = pPath == null || pPath.length() == 0 ? Lists.newArrayList() : Lists.newArrayList((Object[])pPath.split("/"));
    }

    public static UIResource createFromResource(Resource resource) {
        return UIResource.createFromURI(resource.getURI());
    }

    public static UIResource createFromURI(URI uri) {
        UIResource uiResource = null;
        if (uri.isPlatform()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            IProject project = file.getProject();
            String resourcePath = file.getProjectRelativePath().removeLastSegments(1).toOSString();
            uiResource = new UIResource(new UIProject(project.getName()), resourcePath, file.getName());
        }
        return uiResource;
    }

    public UIProject getProject() {
        return this.project;
    }

    public String getPath() {
        return this.path;
    }

    public String getLongName() {
        String longName = "";
        String thePath = this.getPath();
        if (!"".equals(thePath) && !"/".equals(thePath)) {
            longName = String.valueOf(longName) + this.getPath() + "/";
        }
        return String.valueOf(longName) + this.getName();
    }

    public String getFullPath() {
        return String.valueOf(this.getProject().getName()) + File.separator + this.getLongName();
    }

    public List<String> getNodePath() {
        return this.nodePath;
    }

    public String getName() {
        return this.name;
    }

    public void openSession() {
        final IFile fileToOpen = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getFullPath()));
        if (!fileToOpen.exists()) {
            Assert.fail((String)("The session could not be open on " + fileToOpen.getFullPath() + ", because this file does not exist."));
        }
        UIThreadRunnable.syncExec((Display)SWTUtils.display(), (VoidResult)new VoidResult(){

            public void run() {
                OpenSessionAction action = new OpenSessionAction("Open session");
                action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)fileToOpen));
                action.run();
            }
        });
    }
}

