/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.editor.ISiriusEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.editor.Messages;
import org.eclipse.sirius.ui.editor.internal.pages.DefaultSessionEditorPage;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.IModelExplorerView;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SessionEditor
extends SharedHeaderFormEditor
implements ITabbedPropertySheetPageContributor,
IModelExplorerView,
SessionListener,
ISiriusEditor {
    public static final String EDITOR_ID = "org.eclipse.sirius.ui.editor.session";
    private Session session;
    private DefaultSessionEditorPage defaultPage;
    private TabbedPropertySheetPage propertySheetPage;
    private CommandStackListener listener;
    private int choice = 3;

    protected void addPages() {
        try {
            this.defaultPage = new DefaultSessionEditorPage(this, this.session);
            this.addPage(0, (IFormPage)this.defaultPage);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)MessageFormat.format(Messages.UI_SessionEditor_page_loading_error_message, new Object[0]), (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IEditorInput editorInput = this.getEditorInput();
        URI sessionResourceURI = null;
        if (editorInput instanceof FileEditorInput) {
            IFile sessionResourceFile = ((FileEditorInput)editorInput).getFile();
            sessionResourceURI = URI.createPlatformResourceURI((String)sessionResourceFile.getFullPath().toOSString(), (boolean)true);
        } else if (editorInput instanceof URIEditorInput) {
            sessionResourceURI = ((URIEditorInput)editorInput).getURI();
        } else {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)MessageFormat.format(Messages.UI_SessionEditor_session_loading_error_message, new Object[0]), (String)MessageFormat.format(Messages.UI_SessionEditor_inputNotHandled_error_message, editorInput.getClass().getSimpleName()), (IStatus)Status.CANCEL_STATUS);
        }
        try {
            if (sessionResourceURI != null) {
                URI sessionResourceURIFinal = sessionResourceURI;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(sessionResourceURIFinal.toPlatformString(true)));
                IProject project = file.getProject();
                if (ModelingProject.hasModelingProjectNature((IProject)project)) {
                    this.setPartName(sessionResourceURIFinal.segments()[1]);
                } else {
                    this.setPartName(sessionResourceURIFinal.lastSegment());
                    this.setContentDescription(sessionResourceURIFinal.toPlatformString(true));
                }
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                    subMonitor.beginTask(MessageFormat.format(Messages.UI_SessionEditor_session_loading_task_title, new Object[0]), 1);
                    this.session = SessionManager.INSTANCE.getSession(sessionResourceURIFinal, (IProgressMonitor)subMonitor);
                    if (!this.session.isOpen()) {
                        this.session.open(monitor);
                    }
                    this.session.addListener((SessionListener)this);
                    IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(this.session);
                    editingSession.open();
                    editingSession.attachEditor((ISiriusEditor)this);
                    subMonitor.worked(1);
                    subMonitor.done();
                });
                this.listener = new CommandStackListener(){

                    public void commandStackChanged(EventObject event) {
                        SessionEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SessionEditor.this.firePropertyChange(257);
                                if (SessionEditor.this.propertySheetPage == null || SessionEditor.this.propertySheetPage.getControl() == null || SessionEditor.this.propertySheetPage.getControl().isDisposed()) {
                                    SessionEditor.this.propertySheetPage = null;
                                } else if (SessionEditor.this.propertySheetPage.getCurrentTab() != null) {
                                    SessionEditor.this.propertySheetPage.refresh();
                                }
                            }
                        });
                    }
                };
                this.session.getTransactionalEditingDomain().getCommandStack().addCommandStackListener(this.listener);
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)MessageFormat.format(Messages.UI_SessionEditor_session_loading_error_message, new Object[0]), (String)e.getMessage(), (IStatus)Status.CANCEL_STATUS);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.session != null) {
            IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(this.session);
            if (editingSession != null) {
                editingSession.detachEditor((ISiriusEditor)this, this.choice == 1);
            }
            if (this.session.getTransactionalEditingDomain() != null) {
                this.session.getTransactionalEditingDomain().getCommandStack().removeCommandStackListener(this.listener);
            }
        }
        this.session = null;
        this.propertySheetPage = null;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                Object page = this.pages.get(i);
                if (page instanceof IFormPage) {
                    ((IFormPage)page).doSave(monitor);
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class type) {
        Object result = null;
        if (type == IPropertySheetPage.class) {
            IPropertySheetPage contributedPage = SiriusEditPlugin.getPlugin().getPropertySheetPage((Object)this, this.getContributorId());
            if (contributedPage != null) {
                result = contributedPage;
            } else {
                this.propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
                result = this.propertySheetPage;
            }
        }
        if (result == null) {
            result = super.getAdapter(type);
        }
        return result;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getContributorId() {
        return "org.eclipse.sirius.ui.tools.views.model.explorer";
    }

    public void notify(int changeKind) {
        switch (changeKind) {
            case 8: {
                this.close(false);
                break;
            }
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public EditingDomain getEditingDomain() {
        return this.session.getTransactionalEditingDomain();
    }

    public Saveable[] getSaveables() {
        IEditingSession uiSession;
        if (this.session != null && this.session.isOpen() && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) instanceof ISaveablesSource) {
            return ((ISaveablesSource)uiSession).getSaveables();
        }
        return new Saveable[0];
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public int promptToSaveOnClose() {
        IEditingSession uiSession;
        this.choice = 3;
        if (this.session != null && this.session.isOpen() && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) != null && uiSession.needToBeSavedOnClose((IEditorPart)this)) {
            this.choice = uiSession.promptToSaveOnClose();
        }
        return this.choice;
    }
}

