/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.action;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.sirius.ui.business.api.action.IRefreshActionListener;
import org.eclipse.sirius.viewpoint.DRepresentation;

public final class RefreshActionListenerRegistry {
    public static final RefreshActionListenerRegistry INSTANCE = new RefreshActionListenerRegistry();
    private Set<IRefreshActionListener> listeners = Sets.newLinkedHashSet();

    private RefreshActionListenerRegistry() {
    }

    public void addListener(IRefreshActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IRefreshActionListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyRepresentationIsAboutToBeRefreshed(DRepresentation refreshedRepresentation) {
        for (IRefreshActionListener listener : this.listeners) {
            listener.notifyRepresentationIsAboutToBeRefreshed(refreshedRepresentation);
        }
    }
}

