/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree.tools;

import com.google.common.collect.Lists;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.tests.support.api.AbstractToolDescriptionTestCase;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.api.command.TreeCommandFactoryService;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.ui.tools.api.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class SelectionInTreeAfterToolExecutionTest
extends AbstractToolDescriptionTestCase {
    private static final String PATH = "/data/unit/tools/selection/";
    private static final String SEMANTIC_RESOURCE_NAME = "testVSMForSelection.ecore";
    private static final String REPRESENTATIONS_RESOURCE_NAME = "testVSMForSelection.aird";
    private static final String MODELER_RESOURCE_NAME = "VSMForSelection.odesign";
    private DTree treeClasses;
    private DTreeEditor editor;

    protected void setUp() throws Exception {
        super.setUp();
        this.copyFilesToTestProject("org.eclipse.sirius.tests.junit", PATH, new String[]{SEMANTIC_RESOURCE_NAME, REPRESENTATIONS_RESOURCE_NAME, MODELER_RESOURCE_NAME});
        this.genericSetUp(Collections.singleton("DesignerTestProject/testVSMForSelection.ecore"), Lists.newArrayList((Object[])new String[]{"DesignerTestProject/VSMForSelection.odesign"}), "DesignerTestProject/testVSMForSelection.aird");
        this.changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        this.treeClasses = (DTree)this.getRepresentations("Tree", this.semanticModel).iterator().next();
        this.editor = (DTreeEditor)DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.treeClasses, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.emptyEventsFromUIThread();
    }

    public void testSelectionAfterTreeItemCreationTool() {
        DTreeItem dTreeItem = (DTreeItem)this.treeClasses.getOwnedTreeItems().get(0);
        AbstractToolDescription tool = this.getTool("Tree_CreateItem");
        this.changeSelectionExpression(tool, "[instance/]", false);
        TestsUtil.synchronizationWithUIThread();
        this.applyTreeItemCreationTool("Tree_CreateItem", (DTreeItemContainer)dTreeItem, dTreeItem.getTarget());
        TestsUtil.synchronizationWithUIThread();
        this.checkExpectedElementsInSelection((DialectEditor)this.editor, null, 1, false);
        SelectionInTreeAfterToolExecutionTest.assertTrue((String)"As we create a children DTreeItem of a collapsed parent, this last should be expanded to see the created children", (boolean)dTreeItem.isExpanded());
        this.changeSelectionExpression(tool, "[instance/]", false);
        TestsUtil.synchronizationWithUIThread();
        this.applyTreeItemCreationTool("Tree_CreateItem", (DTreeItemContainer)dTreeItem, dTreeItem.getTarget());
        TestsUtil.synchronizationWithUIThread();
        this.checkExpectedElementsInSelection((DialectEditor)this.editor, null, 1, false);
        this.changeSelectionExpression(tool, "", false);
        TestsUtil.synchronizationWithUIThread();
        this.applyTreeItemCreationTool("Tree_CreateItem", dTreeItem.getContainer(), dTreeItem.getTarget());
        TestsUtil.synchronizationWithUIThread();
        this.checkExpectedElementsInSelection((DialectEditor)this.editor, null, 1);
        this.changeSelectionExpression(tool, "[/]", false);
        TestsUtil.synchronizationWithUIThread();
        this.applyTreeItemCreationTool("Tree_CreateItem", dTreeItem.getContainer(), dTreeItem.getTarget());
        TestsUtil.synchronizationWithUIThread();
        this.checkExpectedElementsInSelection((DialectEditor)this.editor, null, 0);
        this.changeSelectionExpression(tool, "service:stdEmptyCollection", false);
        TestsUtil.synchronizationWithUIThread();
        this.applyTreeItemCreationTool("Tree_CreateItem", dTreeItem.getContainer(), dTreeItem.getTarget());
        TestsUtil.synchronizationWithUIThread();
        this.checkExpectedElementsInSelection((DialectEditor)this.editor, null, 0);
    }

    void applyTreeItemCreationTool(String toolName, DTreeItemContainer lineContainer, EObject semanticCurrentElement) {
        TreeItemCreationTool tool = (TreeItemCreationTool)this.getTool(toolName);
        Command cmd = ((ITreeCommandFactory)this.getCommandFactory()).buildCreateLineCommandFromTool(lineContainer, semanticCurrentElement, tool);
        this.session.getTransactionalEditingDomain().getCommandStack().execute(cmd);
    }

    private AbstractToolDescription getTool(String name) {
        TreeIterator allTreeDescriptionContents = this.treeClasses.getDescription().eAllContents();
        while (allTreeDescriptionContents.hasNext()) {
            EObject eObject = (EObject)allTreeDescriptionContents.next();
            if (!(eObject instanceof AbstractToolDescription) || !((AbstractToolDescription)eObject).getName().equals(name)) continue;
            return (AbstractToolDescription)eObject;
        }
        return null;
    }

    public void testRunTimeVariableAfterCreateLineTool() {
        DTreeItem dTreeItem = (DTreeItem)this.treeClasses.getOwnedTreeItems().get(0);
        AbstractToolDescription tool = this.getTool("Tree_CreateItem");
        this.changeSelectionExpression(tool, "[container->including(element)->including(root)/]", false);
        this.applyTreeItemCreationTool("Tree_CreateItem", (DTreeItemContainer)dTreeItem, dTreeItem.getTarget());
        SelectionInTreeAfterToolExecutionTest.assertFalse((String)"An error occurred during runtime execution of ElementsToSelect expression", (boolean)this.doesAnErrorOccurs());
    }

    protected ICommandFactory getCommandFactory() {
        ITreeCommandFactory commandFactory = TreeCommandFactoryService.getInstance().getNewProvider().getCommandFactory(this.session.getTransactionalEditingDomain());
        commandFactory.setModelAccessor(SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)((Resource)this.session.getSemanticResources().iterator().next()).getContents().get(0)));
        return commandFactory;
    }
}

