/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.tree.vsm.edit;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.tests.unit.tree.vsm.edit.InterpretedExpression;
import org.eclipse.sirius.tools.api.interpreter.context.SiriusInterpreterContextFactory;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VSMVariableTypesValidationTest {
    private static final String ORG_ECLIPSE_SIRIUS_TESTS_JUNIT_DATA_UNIT_VSM_VALIDATE_VARIABLE_TYPES_ODESIGN = "/org.eclipse.sirius.tests.tree/data/unit/vsm/validateVariableTypeTree.odesign";
    private InterpretedExpression interpretedExpToTest;

    public VSMVariableTypesValidationTest(InterpretedExpression expression) {
        this.interpretedExpToTest = expression;
    }

    @Parameterized.Parameters(name="org.eclipse.sirius.tests.unit.tree.vsm.edit.VSMVariableTypesValidationTest.{index}: ({0})")
    public static Collection<Object[]> data() throws IOException {
        URI uri = URI.createPlatformPluginURI((String)ORG_ECLIPSE_SIRIUS_TESTS_JUNIT_DATA_UNIT_VSM_VALIDATE_VARIABLE_TYPES_ODESIGN, (boolean)true);
        ArrayList parameters = Lists.newArrayList();
        Group group = VSMVariableTypesValidationTest.loadVSM(uri);
        if (group != null) {
            for (Viewpoint vp : group.getOwnedViewpoints()) {
                TreeIterator it = vp.eAllContents();
                while (it.hasNext()) {
                    EObject underTest = (EObject)it.next();
                    for (EAttribute attr : underTest.eClass().getEAllAttributes()) {
                        Object expr;
                        if (attr.getEType() != DescriptionPackage.eINSTANCE.getInterpretedExpression() || !((expr = underTest.eGet((EStructuralFeature)attr)) instanceof String) || ((String)expr).length() <= 0) continue;
                        parameters.add(new Object[]{new InterpretedExpression((String)expr, underTest, attr)});
                    }
                }
            }
        }
        return parameters;
    }

    private static Group loadVSM(URI uri) {
        ResourceSetImpl set = new ResourceSetImpl();
        ECrossReferenceAdapter crossReferencer = new ECrossReferenceAdapter();
        set.eAdapters().add((Object)crossReferencer);
        Resource res = set.getResource(uri, true);
        for (EObject root : res.getContents()) {
            if (!(root instanceof Group)) continue;
            return (Group)root;
        }
        return null;
    }

    @Test
    public void matchesExpectationsRegardingValidation() {
        String expression = this.interpretedExpToTest.getExpression();
        IInterpreter interpreterForExpression = CompoundInterpreter.INSTANCE.getInterpreterForExpression(expression);
        Collection errors = Sets.newLinkedHashSet();
        if (interpreterForExpression.supportsValidation()) {
            IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext((EObject)this.interpretedExpToTest.getDeclaration(), (EStructuralFeature)this.interpretedExpToTest.getFeature());
            errors = MultiLanguagesValidator.getInstance().validateExpression(context, expression).getStatuses();
            if (errors.size() > 0) {
                String message = String.valueOf(this.interpretedExpToTest.toString()) + "triggers unexpected errors \n" + Joiner.on((char)'\n').join(Iterables.transform(errors, (Function)new Function<IInterpreterStatus, String>(){

                    public String apply(IInterpreterStatus input) {
                        return String.valueOf(input.getSeverity()) + " : " + input.getMessage();
                    }
                }));
                Assert.fail((String)message);
            }
        }
    }
}

