/*******************************************************************************
 * Copyright (c) 2011 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.sirius.tests.api.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.ui.business.api.helper.TableUIHelper;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.tests.SiriusTestsPlugin;
import org.eclipse.sirius.tests.support.api.SiriusDiagramTestCase;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.ui.business.api.helper.TreeUIHelper;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

/**
 * Test Multiple refresh required when several editors are open and AutoRefresh
 * is on. Test also undo and redo with several editors are open. Test VP-815 and
 * DOREMI-2443
 * 
 * @author jdupont
 */
public class RefreshWhenSeveralEditorsOpenTest extends SiriusDiagramTestCase {

    private static final String SEMANTIC_MODEL_PATH = "/" + SiriusTestsPlugin.PLUGIN_ID + "/data/unit/refresh/refreshWhenSeveralEdiorsOpen/My.ecore";

    private static final String MODELER_PATH = "/" + SiriusTestsPlugin.PLUGIN_ID + "/data/unit/refresh/refreshWhenSeveralEdiorsOpen/EcoreExtension.odesign";

    private static final String SESSION_PATH = "/" + SiriusTestsPlugin.PLUGIN_ID + "/data/unit/refresh/refreshWhenSeveralEdiorsOpen/My.aird";

    private static final String VIEWPOINT_NAME = "Design";

    private static final String VIEWPOINT_NAME_EXTENSION = "EcoreForResfreshTest";

    private static final String REPRESENTATION_DESC_NAME_TREE = "Tree";

    private static final String REPRESENTATION_DESC_NAME_ENTITIES = "Entities";

    private static final String REPRESENTATION_DESC_NAME_CLASSES = "Classes";

    private static final String PACKAGE_12 = "new Package 12";

    private static final String PACKAGE_12A = "new Package 12A";

    private static final String ECLASS_12 = "new EClass 12";

    private static final String ECLASS_12A = "new EClass 12A";

    private static final String ECLASS_3 = "new EClass 3";

    private DDiagram diagramAnotherRootpackage;

    private DDiagram diagramPackage;

    private DDiagram diagramRootPackage;

    private DTable tableInNewPackage;

    private DTable tableRootPackage;

    private DTree tree;

    private IEditorPart editorPackage2Classes;

    private IEditorPart editorRootClasses;

    private IEditorPart editorRootTree;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        genericSetUp(SEMANTIC_MODEL_PATH, MODELER_PATH, SESSION_PATH);
        initViewpoint(VIEWPOINT_NAME);
        initViewpoint(VIEWPOINT_NAME_EXTENSION);
        getDiagram();
        getTable();
        tree = (DTree) getRepresentations(REPRESENTATION_DESC_NAME_TREE).toArray()[0];
    }

    /**
     * Test initial case with many editors open.
     */
    public void testInitialisation() {
        // Opened all editor.
        openedAllEditors();

        // Transform editor table & tree contains in html table.
        AbstractDTableEditor dTableEditorPackage2 = (AbstractDTableEditor) editorPackage2Classes;
        Tree treeTablePackage2 = dTableEditorPackage2.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTablePackage2 = TableUIHelper.toContentHTMl(treeTablePackage2);
        String expectedHtmlTablePackage2 = getExpectedTablePackage2();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTablePackage2, currentHtmlTablePackage2);

        AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
        Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
        String expectedHtmlTableRoot = getExpectedTableRoot();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

        AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor) editorRootTree;
        Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
        String expectedHtmlTreeRoot = getExpectedTree();
        // Verify that tree correspond to attempts
        Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

        // Transform editor diagram elements in String list.
        List<String> currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
        List<String> expectedAnotherRootPackage = getExpectedAnotherRootPackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

        // Transform editor diagram elements in String list.
        List<String> currentNewPackageEntities = getElementsDiagrams(diagramPackage);
        List<String> expectedNewPackageEntities = getExpectedNewPackageEntities();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

        // Transform editor diagram elements in String list.
        List<String> currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
        List<String> expectedRootPackageEntities = getExpectedRootPackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);

    }

    /**
     * Test the package rename on diagram. Verify all representations are
     * changed. Verify there is only 1 refresh execute by representation. Test
     * the undo and redo action.
     */
    public void testRenamePackageOnDiagram() {
        changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        // Opened all editor.
        openedAllEditors();

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, ""));

        // Modify name of package in another root diagram
        DNodeContainer diagramPackageToRename = getPackageElementInDiagram(diagramAnotherRootpackage, PACKAGE_12);
        // Use tool Rename+A on Package
        applyNodeCreationTool("Rename+A", diagramAnotherRootpackage, diagramPackageToRename);

        TestsUtil.synchronizationWithUIThread();

        Assert.assertNotNull(getPackageElementInDiagram(diagramAnotherRootpackage, PACKAGE_12A));

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12A, ""));

        // Transform editor table & tree contains in html table.
        AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
        Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
        String expectedHtmlTableRoot = getExpectedTableRootAfterRenamePackage();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

        AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor) editorRootTree;
        Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
        String expectedHtmlTreeRoot = getExpectedTreeAfterRenamePackage();
        // Verify that tree correspond to attempts
        Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

        // Transform editor diagram elements in String list.
        List<String> currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
        List<String> expectedAnotherRootPackage = getExpectedAnotherRootPackageAfterRenamePackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

        // Transform editor diagram elements in String list.
        List<String> currentNewPackageEntities = getElementsDiagrams(diagramPackage);
        List<String> expectedNewPackageEntities = getExpectedNewPackageEntities();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

        // Transform editor diagram elements in String list.
        List<String> currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
        List<String> expectedRootPackageEntities = getExpectedRootPackageAfterRenamePackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);

        // Undo
        try {
            undo();
        } catch (Exception e) {
            Assert.fail();
        }

        TestsUtil.synchronizationWithUIThread();

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, ""));

        // Transform editor table & tree contains in html table.
        dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
        expectedHtmlTableRoot = getExpectedTableRoot();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

        dTreeEditor = (AbstractDTreeEditor) editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
        expectedHtmlTreeRoot = getExpectedTree();
        // Verify that tree correspond to attempts
        Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

        // Transform editor diagram elements in String list.
        currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
        expectedAnotherRootPackage = getExpectedAnotherRootPackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

        // Transform editor diagram elements in String list.
        currentNewPackageEntities = getElementsDiagrams(diagramPackage);
        expectedNewPackageEntities = getExpectedNewPackageEntities();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

        // Transform editor diagram elements in String list.
        currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
        expectedRootPackageEntities = getExpectedRootPackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);

        // Redo
        try {
            redo();
        } catch (Exception e) {
            Assert.fail();
        }

        TestsUtil.synchronizationWithUIThread();

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12A, ""));

        // Transform editor table & tree contains in html table.
        dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
        expectedHtmlTableRoot = getExpectedTableRootAfterRenamePackage();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

        dTreeEditor = (AbstractDTreeEditor) editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
        expectedHtmlTreeRoot = getExpectedTreeAfterRenamePackage();
        // Verify that tree correspond to attempts
        Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

        // Transform editor diagram elements in String list.
        currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
        expectedAnotherRootPackage = getExpectedAnotherRootPackageAfterRenamePackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

        // Transform editor diagram elements in String list.
        currentNewPackageEntities = getElementsDiagrams(diagramPackage);
        expectedNewPackageEntities = getExpectedNewPackageEntities();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

        // Transform editor diagram elements in String list.
        currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
        expectedRootPackageEntities = getExpectedRootPackageAfterRenamePackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
    }

    /**
     * Test the class rename on diagram. Verify all representations are changed.
     * Verify there is only 1 refresh execute by representation. Test the undo
     * and redo action.
     */
    public void testRenameClassOnDiagram() {
        changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        // Opened all editor.
        openedAllEditors();

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, ECLASS_12));

        // Modify name of class in another root diagram
        DNodeList diagramClassToRename = getClassElementInDiagram(diagramAnotherRootpackage, ECLASS_12);
        // Use tool Rename+A on Eclass
        applyNodeCreationTool("Rename+A", diagramAnotherRootpackage, diagramClassToRename);
        TestsUtil.synchronizationWithUIThread();
        Assert.assertNotNull(getClassElementInDiagram(diagramAnotherRootpackage, ECLASS_12A));

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, ECLASS_12A));

        // Transform editor table & tree contains in html table.
        AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
        Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
        String expectedHtmlTableRoot = getExpectedTableRootAfterRenameClass();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

        AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor) editorRootTree;
        Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
        String expectedHtmlTreeRoot = getExpectedTreeAfterRenameClass();
        // Verify that tree correspond to attempts
        Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

        // Transform editor diagram elements in String list.
        List<String> currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
        List<String> expectedAnotherRootPackage = getExpectedAnotherRootPackageAfterRenameClass();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

        // Transform editor diagram elements in String list.
        List<String> currentNewPackageEntities = getElementsDiagrams(diagramPackage);
        List<String> expectedNewPackageEntities = getExpectedNewPackageEntitiesAfterRenameClass();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

        // Transform editor diagram elements in String list.
        List<String> currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
        List<String> expectedRootPackageEntities = getExpectedRootPackageAfterRenameClass();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);

        // Undo
        try {
            undo();
        } catch (Exception e) {
            Assert.fail();
        }

        TestsUtil.synchronizationWithUIThread();

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, ECLASS_12));

        // Transform editor table & tree contains in html table.
        dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
        expectedHtmlTableRoot = getExpectedTableRoot();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

        dTreeEditor = (AbstractDTreeEditor) editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
        expectedHtmlTreeRoot = getExpectedTree();
        // Verify that tree correspond to attempts
        Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

        // Transform editor diagram elements in String list.
        currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
        expectedAnotherRootPackage = getExpectedAnotherRootPackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

        // Transform editor diagram elements in String list.
        currentNewPackageEntities = getElementsDiagrams(diagramPackage);
        expectedNewPackageEntities = getExpectedNewPackageEntities();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

        // Transform editor diagram elements in String list.
        currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
        expectedRootPackageEntities = getExpectedRootPackage();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);

        // Redo
        try {
            redo();
        } catch (Exception e) {
            Assert.fail();
        }

        TestsUtil.synchronizationWithUIThread();

        Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, ECLASS_12A));

        // Transform editor table & tree contains in html table.
        dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
        treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
        currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
        expectedHtmlTableRoot = getExpectedTableRootAfterRenameClass();
        // Verify that table correspond to attempts
        Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

        dTreeEditor = (AbstractDTreeEditor) editorRootTree;
        treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
        currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
        expectedHtmlTreeRoot = getExpectedTreeAfterRenameClass();
        // Verify that tree correspond to attempts
        Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

        // Transform editor diagram elements in String list.
        currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
        expectedAnotherRootPackage = getExpectedAnotherRootPackageAfterRenameClass();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

        // Transform editor diagram elements in String list.
        currentNewPackageEntities = getElementsDiagrams(diagramPackage);
        expectedNewPackageEntities = getExpectedNewPackageEntitiesAfterRenameClass();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

        // Transform editor diagram elements in String list.
        currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
        expectedRootPackageEntities = getExpectedRootPackageAfterRenameClass();
        // Verify that diagram correspond to attempts
        Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
    }

    /**
     * Test add class on diagram. Verify all representations are changed. Verify
     * there is only 1 refresh execute by representation. Test the undo and redo
     * action.
     */
    public void testAddClassOnDiagram() {
        changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
        // Count number of refresh call
        DslCommonPlugin.PROFILER.setActive(true);
        try {
            DslCommonPlugin.PROFILER.init();

            // Opened all editor.
            openedAllEditors();

            int refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            int refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            int refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals("Number of diagram refresh is inconrrect", 3, refreshDiagramNumberCount);
            Assert.assertEquals("Number of table refresh is inconrrect", 2, refreshTableNumberCount);
            Assert.assertEquals("Number of tree refresh is inconrrect", 1, refreshTreeNumberCount);

            Assert.assertEquals("The semantic model is not correct", false, isSemanticModelUpdated(PACKAGE_12, ECLASS_3));

            DslCommonPlugin.PROFILER.init();
            // Add class in package in another root diagram
            DNodeContainer diagramPackageToAddClass = getPackageElementInDiagram(diagramAnotherRootpackage, PACKAGE_12);
            // Use tool Class on package "new package 2"
            applyNodeCreationTool("Class", diagramAnotherRootpackage, diagramPackageToAddClass);

            TestsUtil.synchronizationWithUIThread();

            refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals("Number of diagram refresh is incorrect", 3, refreshDiagramNumberCount);
            Assert.assertEquals("Number of table refresh is incorrect", 2, refreshTableNumberCount);
            Assert.assertEquals("Number of tree refresh is incorrect", 1, refreshTreeNumberCount);

            Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, "NewEClass3"));

            // Transform editor table & tree contains in html table.
            AbstractDTableEditor dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
            Tree treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
            String currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
            String expectedHtmlTableRoot = getExpectedTableRootAfterAddClass();
            // Verify that table correspond to attempts
            Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

            AbstractDTreeEditor dTreeEditor = (AbstractDTreeEditor) editorRootTree;
            Tree treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
            String currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
            String expectedHtmlTreeRoot = getExpectedTreeAfterAddClass();
            // Verify that tree correspond to attempts
            Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

            // Transform editor diagram elements in String list.
            List<String> currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
            List<String> expectedAnotherRootPackage = getExpectedAnotherRootPackageAfterAddClass();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

            // Transform editor diagram elements in String list.
            List<String> currentNewPackageEntities = getElementsDiagrams(diagramPackage);
            List<String> expectedNewPackageEntities = getExpectedNewPackageEntitiesAfterAddClass();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

            // Transform editor diagram elements in String list.
            List<String> currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
            List<String> expectedRootPackageEntities = getExpectedRootPackageAfterAddClass();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);

            DslCommonPlugin.PROFILER.init();
            // Undo
            try {
                undo();
            } catch (Exception e) {
                Assert.fail();
            }

            refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals("Number of diagram refresh is inconrrect", 0, refreshDiagramNumberCount);
            Assert.assertEquals("Number of table refresh is inconrrect", 0, refreshTableNumberCount);
            Assert.assertEquals("Number of tree refresh is inconrrect", 0, refreshTreeNumberCount);

            TestsUtil.synchronizationWithUIThread();

            Assert.assertEquals("The semantic model is not correct", false, isSemanticModelUpdated(PACKAGE_12, "NewEClass3"));

            // Transform editor diagram elements in String list.
            currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
            expectedAnotherRootPackage = getExpectedAnotherRootPackage();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

            // Transform editor table & tree contains in html table.
            dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
            treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
            currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
            expectedHtmlTableRoot = getExpectedTableRoot();
            // Verify that table correspond to attempts
            Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

            dTreeEditor = (AbstractDTreeEditor) editorRootTree;
            treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
            currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
            expectedHtmlTreeRoot = getExpectedTree();
            // Verify that tree correspond to attempts
            Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

            // // Transform editor diagram elements in String list.
            currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
            expectedAnotherRootPackage = getExpectedAnotherRootPackage();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

            // Transform editor diagram elements in String list.
            currentNewPackageEntities = getElementsDiagrams(diagramPackage);
            expectedNewPackageEntities = getExpectedNewPackageEntities();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

            // Transform editor diagram elements in String list.
            currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
            expectedRootPackageEntities = getExpectedRootPackage();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);

            DslCommonPlugin.PROFILER.init();
            // Redo
            try {
                redo();
            } catch (Exception e) {
                Assert.fail();
            }

            refreshDiagramNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_DIAGRAM_KEY);
            refreshTableNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TABLE_KEY);
            refreshTreeNumberCount = DslCommonPlugin.PROFILER.getCountTask(SiriusTasksKey.REFRESH_TREE_KEY);
            Assert.assertEquals("Number of diagram refresh is inconrrect", 0, refreshDiagramNumberCount);
            Assert.assertEquals("Number of table refresh is inconrrect", 0, refreshTableNumberCount);
            Assert.assertEquals("Number of tree refresh is inconrrect", 0, refreshTreeNumberCount);

            TestsUtil.synchronizationWithUIThread();

            Assert.assertEquals("The semantic model is not correct", true, isSemanticModelUpdated(PACKAGE_12, "NewEClass3"));

            // Transform editor table & tree contains in html table.
            dTableEditorRoot = (AbstractDTableEditor) editorRootClasses;
            treeTableRoot = dTableEditorRoot.getTableViewer().getTreeViewer().getTree();
            currentHtmlTableRoot = TableUIHelper.toContentHTMl(treeTableRoot);
            expectedHtmlTableRoot = getExpectedTableRootAfterAddClass();
            // Verify that table correspond to attempts
            Assert.assertEquals("The table doesn't correspond to attempt", expectedHtmlTableRoot, currentHtmlTableRoot);

            dTreeEditor = (AbstractDTreeEditor) editorRootTree;
            treeTreeRoot = dTreeEditor.getTableViewer().getTreeViewer().getTree();
            currentHtmlTreeRoot = TreeUIHelper.toContentHTMl(treeTreeRoot);
            expectedHtmlTreeRoot = getExpectedTreeAfterAddClass();
            // Verify that tree correspond to attempts
            Assert.assertEquals("The tree doesn't correspond to attempt", expectedHtmlTreeRoot, currentHtmlTreeRoot);

            // Transform editor diagram elements in String list.
            currentAnotherRootPackage = getElementsDiagrams(diagramAnotherRootpackage);
            expectedAnotherRootPackage = getExpectedAnotherRootPackageAfterAddClass();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedAnotherRootPackage, currentAnotherRootPackage);

            // Transform editor diagram elements in String list.
            currentNewPackageEntities = getElementsDiagrams(diagramPackage);
            expectedNewPackageEntities = getExpectedNewPackageEntitiesAfterAddClass();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedNewPackageEntities, currentNewPackageEntities);

            // Transform editor diagram elements in String list.
            currentRootPackageEntities = getElementsDiagrams(diagramRootPackage);
            expectedRootPackageEntities = getExpectedRootPackageAfterAddClass();
            // Verify that diagram correspond to attempts
            Assert.assertEquals("The diagram doesn't correspond to attempt", expectedRootPackageEntities, currentRootPackageEntities);
        } finally {
            DslCommonPlugin.PROFILER.setActive(false);
        }
    }

    public void testEditorRename() {
        // opened all editors
        openedAllEditors();
        final String originalTitle = editorRootClasses.getTitle();

        session.getTransactionalEditingDomain().getCommandStack().execute(new RecordingCommand(session.getTransactionalEditingDomain()) {
            @Override
            protected void doExecute() {
                tableRootPackage.setName("new name");
            }
        });

        TestsUtil.synchronizationWithUIThread();

        final String newTitle = editorRootClasses.getTitle();
        Assert.assertFalse(originalTitle.equals(newTitle));
        Assert.assertTrue(newTitle.contains("new name"));
        Assert.assertEquals("Editor name is not correct", "Classes in new Package 2 package", editorPackage2Classes.getTitle());
        Assert.assertEquals("Editor name is not correct", "new Tree", editorRootTree.getTitle());

    }

    /**
     * Retrieve the package corresponding to package name in diagram.
     * 
     * @param diagram
     *            the diagram
     * @param packageName
     *            the package name
     * @return the package corresponding to package name. Null if package not
     *         found.
     */
    private DNodeContainer getPackageElementInDiagram(DDiagram diagram, String packageName) {
        for (DDiagramElement diagramElement : diagram.getOwnedDiagramElements()) {
            if (diagramElement instanceof DNodeContainer && packageName.equals(diagramElement.getName())) {
                return (DNodeContainer) diagramElement;
            }
        }
        return null;
    }

    /**
     * Retrieve the class corresponding to class name in diagram.
     * 
     * @param diagram
     *            the diagram
     * @param className
     *            the class name
     * @return the class corresponding to class name. Null if class not found.
     */
    private DNodeList getClassElementInDiagram(DDiagram diagram, String className) {
        for (DDiagramElement diagramElement : diagram.getOwnedDiagramElements()) {
            if (diagramElement instanceof DNodeContainer) {
                for (DDiagramElement nodeListSpec : ((DNodeContainer) diagramElement).getOwnedDiagramElements()) {
                    if (nodeListSpec instanceof DNodeList && className.equals(nodeListSpec.getName())) {
                        return (DNodeList) nodeListSpec;
                    }
                }
            }
        }
        return null;
    }

    /**
     * Affect to variables the DDiagram corresponding to.
     */
    private void getDiagram() {
        Collection<DRepresentation> representations = getRepresentations(REPRESENTATION_DESC_NAME_ENTITIES);
        for (DRepresentation representation : representations) {
            if (representation instanceof DDiagram) {
                if ("another root package entities".equals(((DDiagram) representation).getName())) {
                    diagramAnotherRootpackage = (DDiagram) representation;
                } else if ("new Package 1 package entities".equals(((DDiagram) representation).getName())) {
                    diagramPackage = (DDiagram) representation;
                } else if ("root package entities".equals(((DDiagram) representation).getName())) {
                    diagramRootPackage = (DDiagram) representation;
                }
            }
        }
    }

    /**
     * Affect to variable the DTable corresponding to.
     */
    private void getTable() {
        Collection<DRepresentation> representations = getRepresentations(REPRESENTATION_DESC_NAME_CLASSES);
        for (DRepresentation representation : representations) {
            if (representation instanceof DTable) {
                if ("Classes in new Package 2 package".equals(((DTable) representation).getName())) {
                    tableInNewPackage = (DTable) representation;
                } else if ("Classes in root package".equals(((DTable) representation).getName())) {
                    tableRootPackage = (DTable) representation;
                }
            }
        }
    }

    /**
     * Retrieve all class and package in the diagram.
     * 
     * @param diagram
     *            diagram
     * @return all classes and packages in diagram.
     */
    private List<String> getElementsDiagrams(DDiagram diagram) {
        EList<DDiagramElement> allDiagramElements = diagram.getOwnedDiagramElements();
        List<String> allElementsInDiagram = new ArrayList<String>();
        for (DDiagramElement nodeContainer : allDiagramElements) {
            if (nodeContainer instanceof DNodeContainer) {
                allElementsInDiagram.add("Package : " + nodeContainer);
                List<DDiagramElement> allClassesInDiagram = ((DNodeContainer) nodeContainer).getOwnedDiagramElements();
                for (DDiagramElement nodeListSpec : allClassesInDiagram) {
                    if (nodeListSpec instanceof DNodeList) {
                        allElementsInDiagram.add("Class : " + nodeListSpec.getName());
                        List<DNodeListElement> allAttributsInDiagram = ((DNodeList) nodeListSpec).getOwnedElements();
                        for (DNodeListElement nodeListElement : allAttributsInDiagram) {
                            if (nodeListElement instanceof DNodeListElement) {
                                allElementsInDiagram.add("Attribute : " + nodeListElement.getName());
                            }
                        }

                    }
                }
            } else if (nodeContainer instanceof DNodeList) {
                allElementsInDiagram.add("Class : " + nodeContainer.getName());
                List<DNodeListElement> allAttributsInDiagram = ((DNodeList) nodeContainer).getOwnedElements();
                for (DNodeListElement nodeListElement : allAttributsInDiagram) {
                    if (nodeListElement instanceof DNodeListElement) {
                        allElementsInDiagram.add("Attribute : " + nodeListElement.getName());
                    }
                }
            }
        }
        return allElementsInDiagram;
    }

    /**
     * Opened all editors.
     */
    private void openedAllEditors() {
        // Opened all editor.
        DialectUIManager.INSTANCE.openEditor(session, diagramPackage, new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        editorPackage2Classes = DialectUIManager.INSTANCE.openEditor(session, tableInNewPackage, new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        editorRootClasses = DialectUIManager.INSTANCE.openEditor(session, tableRootPackage, new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        DialectUIManager.INSTANCE.openEditor(session, diagramAnotherRootpackage, new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        editorRootTree = DialectUIManager.INSTANCE.openEditor(session, tree, new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        DialectUIManager.INSTANCE.openEditor(session, diagramRootPackage, new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
    }

    /**
     * Test the model semantic correspond to attempt for package name passed to
     * parameters. If class name is not informed return true if package name
     * find.
     * 
     * @param packageToFind
     *            the package name to find in semantic model
     * @param classToFind
     *            the class name to find in package name corresponding to first
     *            parameter
     * @return true if class find. False otherwise.
     */
    private boolean isSemanticModelUpdated(String packageToFind, String classToFind) {
        EPackage ePackageRoot = (EPackage) semanticModel;
        List<EPackage> packages = ePackageRoot.getESubpackages();
        for (EPackage pack : packages) {
            if (pack.getName().equals(packageToFind)) {
                if (classToFind == "") {
                    return true;
                }
                EClass classFind = (EClass) pack.getEClassifier(classToFind);
                if (classFind != null) {
                    return true;
                }
            }
        }

        return false;
    }

    private String getExpectedTablePackage2() {
        List<List<String>> expected = new ArrayList<List<String>>();
        TableUIHelper.addLineToTable(expected, new String[] { "", "Name" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2", "new EClass 2" });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_3, ECLASS_3 });
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRoot() {
        List<List<String>> expected = new ArrayList<List<String>>();
        TableUIHelper.addLineToTable(expected, new String[] { "", "Name" });
        TableUIHelper.addLineToTable(expected, new String[] { PACKAGE_12, PACKAGE_12 });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_12, ECLASS_12 });
        TableUIHelper.addLineToTable(expected, new String[] { "attribut1", "attribut1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2A", "new EClass 2A" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 2", "new Package 2" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2", "new EClass 2" });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_3, ECLASS_3 });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 3", "new Package 3" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 4", "new Package 4" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRootAfterRenamePackage() {
        List<List<String>> expected = new ArrayList<List<String>>();
        TableUIHelper.addLineToTable(expected, new String[] { "", "Name" });
        TableUIHelper.addLineToTable(expected, new String[] { PACKAGE_12A, PACKAGE_12A });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_12, ECLASS_12 });
        TableUIHelper.addLineToTable(expected, new String[] { "attribut1", "attribut1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2A", "new EClass 2A" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 2", "new Package 2" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2", "new EClass 2" });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_3, ECLASS_3 });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 3", "new Package 3" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 4", "new Package 4" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRootAfterRenameClass() {
        List<List<String>> expected = new ArrayList<List<String>>();
        TableUIHelper.addLineToTable(expected, new String[] { "", "Name" });
        TableUIHelper.addLineToTable(expected, new String[] { PACKAGE_12, PACKAGE_12 });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_12A, ECLASS_12A });
        TableUIHelper.addLineToTable(expected, new String[] { "attribut1", "attribut1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2A", "new EClass 2A" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 2", "new Package 2" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2", "new EClass 2" });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_3, ECLASS_3 });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 3", "new Package 3" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 4", "new Package 4" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTableRootAfterAddClass() {
        List<List<String>> expected = new ArrayList<List<String>>();
        TableUIHelper.addLineToTable(expected, new String[] { "", "Name" });
        TableUIHelper.addLineToTable(expected, new String[] { PACKAGE_12, PACKAGE_12 });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_12, ECLASS_12 });
        TableUIHelper.addLineToTable(expected, new String[] { "attribut1", "attribut1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2A", "new EClass 2A" });
        TableUIHelper.addLineToTable(expected, new String[] { "NewEClass3", "NewEClass3" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 2", "new Package 2" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 2", "new EClass 2" });
        TableUIHelper.addLineToTable(expected, new String[] { ECLASS_3, ECLASS_3 });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 3", "new Package 3" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        TableUIHelper.addLineToTable(expected, new String[] { "new Package 4", "new Package 4" });
        TableUIHelper.addLineToTable(expected, new String[] { "new EClass 1", "new EClass 1" });
        return TableUIHelper.toHTML(expected);
    }

    private String getExpectedTree() {
        List<String> expected = new ArrayList<String>();
        TreeUIHelper.addLineToTree(expected, String.valueOf(PACKAGE_12));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_12));
        TreeUIHelper.addLineToTree(expected, String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private String getExpectedTreeAfterRenamePackage() {
        List<String> expected = new ArrayList<String>();
        TreeUIHelper.addLineToTree(expected, String.valueOf(PACKAGE_12A));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_12));
        TreeUIHelper.addLineToTree(expected, String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private String getExpectedTreeAfterRenameClass() {
        List<String> expected = new ArrayList<String>();
        TreeUIHelper.addLineToTree(expected, String.valueOf(PACKAGE_12));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_12A));
        TreeUIHelper.addLineToTree(expected, String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private String getExpectedTreeAfterAddClass() {
        List<String> expected = new ArrayList<String>();
        TreeUIHelper.addLineToTree(expected, String.valueOf(PACKAGE_12));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_12));
        TreeUIHelper.addLineToTree(expected, String.valueOf("attribut1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2A"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("NewEClass3"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 2"));
        TreeUIHelper.addLineToTree(expected, String.valueOf(ECLASS_3));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 3"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new Package 4"));
        TreeUIHelper.addLineToTree(expected, String.valueOf("new EClass 1"));
        return TreeUIHelper.toHTML(expected);
    }

    private List<String> getExpectedAnotherRootPackage() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12);
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedAnotherRootPackageAfterRenamePackage() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12A);
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedAnotherRootPackageAfterRenameClass() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12);
        expected.add("Class : " + ECLASS_12A);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedAnotherRootPackageAfterAddClass() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12);
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Class : " + "NewEClass3");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedNewPackageEntities() {
        List<String> expected = new ArrayList<String>();
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        return expected;
    }

    private List<String> getExpectedNewPackageEntitiesAfterRenameClass() {
        List<String> expected = new ArrayList<String>();
        expected.add("Class : " + ECLASS_12A);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        return expected;
    }

    private List<String> getExpectedNewPackageEntitiesAfterAddClass() {
        List<String> expected = new ArrayList<String>();
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Class : " + "NewEClass3");
        return expected;
    }

    private List<String> getExpectedRootPackage() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12);
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedRootPackageAfterRenamePackage() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12A);
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedRootPackageAfterRenameClass() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12);
        expected.add("Class : " + ECLASS_12A);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    private List<String> getExpectedRootPackageAfterAddClass() {
        List<String> expected = new ArrayList<String>();
        expected.add("Package : " + PACKAGE_12);
        expected.add("Class : " + ECLASS_12);
        expected.add("Attribute : attribut1");
        expected.add("Class : new EClass 2A");
        expected.add("Class : " + "NewEClass3");
        expected.add("Package : new Package 2");
        expected.add("Class : new EClass 1");
        expected.add("Class : new EClass 2");
        expected.add("Class : " + ECLASS_3);
        expected.add("Package : new Package 3");
        expected.add("Class : new EClass 1");
        expected.add("Package : new Package 4");
        expected.add("Class : new EClass 1");
        return expected;
    }

    @Override
    protected void tearDown() throws Exception {
        TestsUtil.synchronizationWithUIThread();

        diagramAnotherRootpackage = null;
        diagramPackage = null;
        diagramRootPackage = null;

        tableInNewPackage = null;
        tableRootPackage = null;

        tree = null;

        editorPackage2Classes = null;
        editorRootClasses = null;
        editorRootTree = null;

        super.tearDown();
    }
}
