/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class ReversedEdgeRestorer
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Restoring reversed edges", 1.0f);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    LEdge[] edgeArray;
                    LEdge[] lEdgeArray = edgeArray = port.getOutgoingEdges().toArray(new LEdge[port.getOutgoingEdges().size()]);
                    int n = edgeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LEdge edge = lEdgeArray[n2];
                        if (((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue()) {
                            edge.reverse(layeredGraph, false);
                        }
                        ++n2;
                    }
                }
            }
        }
        monitor.done();
    }
}

