/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.elk.ELKLayoutNodeProvider;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithmProvider;
import org.eclipse.sirius.diagram.ui.api.layout.EnumChoice;
import org.eclipse.sirius.diagram.ui.api.layout.LayoutOptionFactory;

public class ELKAlgorithmProvider
implements CustomLayoutAlgorithmProvider {
    public List<CustomLayoutAlgorithm> getCustomLayoutAlgorithms() {
        ArrayList<CustomLayoutAlgorithm> layoutAlgorithms = new ArrayList<CustomLayoutAlgorithm>();
        Collection algorithmData = LayoutMetaDataService.getInstance().getAlgorithmData();
        for (LayoutAlgorithmData layoutAlgorithmData : algorithmData) {
            List optionDatas = LayoutMetaDataService.getInstance().getOptionData(layoutAlgorithmData, LayoutOptionData.Target.PARENTS);
            HashMap<String, LayoutOption> layoutOptions = new HashMap<String, LayoutOption>();
            LayoutOptionFactory layoutOptionFactory = new LayoutOptionFactory();
            for (LayoutOptionData layoutOptionData : optionDatas) {
                if (CoreOptions.ALGORITHM.getId().equals(layoutOptionData.getId()) || layoutOptionData.getVisibility().equals((Object)LayoutOptionData.Visibility.HIDDEN)) continue;
                switch (layoutOptionData.getType()) {
                    case STRING: {
                        layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createStringOption((String)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName()));
                        break;
                    }
                    case BOOLEAN: {
                        layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createBooleanOption((Boolean)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName()));
                        break;
                    }
                    case INT: {
                        layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createIntegerOption((Integer)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName()));
                        break;
                    }
                    case DOUBLE: {
                        layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createDoubleOption((Double)layoutOptionData.getDefaultDefault(), layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName()));
                        break;
                    }
                    case ENUM: 
                    case ENUMSET: {
                        EnumSet enumSet;
                        String[] choices = layoutOptionData.getChoices();
                        ArrayList<EnumChoice> choicesList = new ArrayList<EnumChoice>();
                        int i = 0;
                        while (i < choices.length) {
                            String choiceId = choices[i];
                            choicesList.add(new EnumChoice(choiceId, ""));
                            ++i;
                        }
                        Object defaultObject = layoutOptionData.getDefaultDefault();
                        if (layoutOptionData.getType() == LayoutOptionData.Type.ENUM) {
                            String defaultValue = null;
                            if (defaultObject instanceof Enum) {
                                defaultValue = ((Enum)defaultObject).name();
                            }
                            layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createEnumOption(choicesList, layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), defaultValue));
                            break;
                        }
                        ArrayList enumValues = new ArrayList();
                        if (defaultObject instanceof EnumSet && (enumSet = (EnumSet)defaultObject).size() > 0) {
                            enumSet.forEach(enumValue -> {
                                boolean bl = enumValues.add(enumValue.name());
                            });
                        }
                        layoutOptions.put(layoutOptionData.getId(), layoutOptionFactory.createEnumSetOption(choicesList, layoutOptionData.getId(), layoutOptionData.getDescription(), layoutOptionData.getName(), enumValues));
                        break;
                    }
                }
            }
            layoutAlgorithms.add(new CustomLayoutAlgorithm(layoutAlgorithmData.getId(), layoutAlgorithmData.getName(), layoutAlgorithmData.getDescription(), () -> new ELKLayoutNodeProvider(), layoutOptions));
        }
        return layoutAlgorithms;
    }
}

