/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.elk.core.IGraphLayoutEngine;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.service.ElkServicePlugin;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Maybe;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.sirius.diagram.description.BooleanLayoutOption;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DoubleLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.EnumSetLayoutOption;
import org.eclipse.sirius.diagram.description.IntegerLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.description.StringLayoutOption;
import org.eclipse.sirius.diagram.elk.ApplyLayoutRequest;
import org.eclipse.sirius.diagram.elk.IEditPartFilter;
import org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IWorkbenchPart;

@Singleton
public class ElkDiagramLayoutConnector
implements IDiagramLayoutConnector {
    public static final IProperty<List<ConnectionEditPart>> CONNECTIONS = new Property("gmf.connections");
    public static final IProperty<DiagramEditPart> DIAGRAM_EDIT_PART = new Property("gmf.diagramEditPart");
    public static final IProperty<Command> LAYOUT_COMMAND = new Property("gmf.applyLayoutCommand");
    public static final IProperty<KVector> COORDINATE_OFFSET = new Property("gmf.coordinateOffset");
    public static final String PREF_EXEC_TIME_MEASUREMENT = "elk.exectime.measure";
    @Inject
    private IEditPartFilter editPartFilter;
    @Inject
    private IGraphLayoutEngine graphLayoutEngine;

    public static Rectangle getAbsoluteBounds(IFigure figure) {
        Rectangle bounds = new Rectangle(figure.getBounds()){
            static final long serialVersionUID = 1L;

            public void performScale(double factor) {
            }
        };
        figure.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        EditPart ep = editPart;
        while (ep != null && !(ep instanceof DiagramEditPart) && !(ep instanceof RootEditPart)) {
            ep = ep.getParent();
        }
        if (ep instanceof RootEditPart) {
            RootEditPart root = (RootEditPart)ep;
            ep = null;
            for (Object child : root.getChildren()) {
                if (!(child instanceof DiagramEditPart)) continue;
                ep = (EditPart)child;
            }
        }
        return (DiagramEditPart)ep;
    }

    protected DiagramEditor getDiagramEditor(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof DiagramEditor) {
            return (DiagramEditor)workbenchPart;
        }
        return null;
    }

    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        DiagramEditor diagramEditor = this.getDiagramEditor(workbenchPart);
        IGraphicalEditPart layoutRootPart = null;
        ArrayList<ShapeNodeEditPart> selectedParts = null;
        if (diagramPart instanceof ShapeNodeEditPart || diagramPart instanceof DiagramEditPart) {
            layoutRootPart = (IGraphicalEditPart)diagramPart;
        } else if (diagramPart instanceof IGraphicalEditPart) {
            TopGraphicEditPart tgEditPart = ((IGraphicalEditPart)diagramPart).getTopGraphicEditPart();
            if (tgEditPart instanceof ShapeNodeEditPart) {
                layoutRootPart = (IGraphicalEditPart)tgEditPart;
            }
        } else if (diagramPart instanceof Collection) {
            Collection selection = (Collection)diagramPart;
            for (Object object : selection) {
                if (!(object instanceof IGraphicalEditPart)) continue;
                if (layoutRootPart != null) {
                    EditPart parent = ElkDiagramLayoutConnector.commonParent((EditPart)layoutRootPart, (EditPart)object);
                    if (parent == null || parent instanceof RootEditPart) continue;
                    layoutRootPart = (IGraphicalEditPart)parent;
                    continue;
                }
                if (object instanceof ConnectionEditPart) continue;
                layoutRootPart = (IGraphicalEditPart)object;
            }
            if (layoutRootPart != null) {
                selectedParts = new ArrayList<ShapeNodeEditPart>(selection.size());
                for (Object object : selection) {
                    if (!(object instanceof IGraphicalEditPart)) continue;
                    EditPart editPart = (EditPart)object;
                    while (editPart != null && editPart.getParent() != layoutRootPart) {
                        editPart = editPart.getParent();
                    }
                    if (!(editPart instanceof ShapeNodeEditPart) || !this.editPartFilter.filter(editPart) || selectedParts.contains(editPart)) continue;
                    selectedParts.add((ShapeNodeEditPart)editPart);
                }
            }
        }
        if (layoutRootPart == null && diagramEditor != null) {
            layoutRootPart = diagramEditor.getDiagramEditPart();
        }
        if (layoutRootPart == null) {
            throw new IllegalArgumentException("Not supported by this layout connector: Workbench part " + workbenchPart + ", Edit part " + diagramPart);
        }
        LayoutMapping mapping = this.buildLayoutGraph(layoutRootPart, selectedParts, workbenchPart);
        return mapping;
    }

    protected static EditPart commonParent(EditPart editPart1, EditPart editPart2) {
        EditPart ep1 = editPart1;
        EditPart ep2 = editPart2;
        do {
            if (ElkDiagramLayoutConnector.isParent(ep1, ep2)) {
                return ep1;
            }
            if (ElkDiagramLayoutConnector.isParent(ep2, ep1)) {
                return ep2;
            }
            ep1 = ep1.getParent();
            ep2 = ep2.getParent();
        } while (ep1 != null && ep2 != null);
        return null;
    }

    protected static boolean isParent(EditPart parent, EditPart child) {
        EditPart editPart = child;
        do {
            if (editPart != parent) continue;
            return true;
        } while ((editPart = editPart.getParent()) != null);
        return false;
    }

    public <E extends Enum<E>> EnumSet<E> of(E e, EnumSet<E> enumSet) {
        enumSet.add(e);
        return enumSet;
    }

    protected LayoutMapping buildLayoutGraph(IGraphicalEditPart layoutRootPart, List<ShapeNodeEditPart> selection, IWorkbenchPart workbenchPart) {
        ElkNode topNode;
        LayoutMapping mapping = new LayoutMapping(workbenchPart);
        mapping.setProperty(CONNECTIONS, new LinkedList());
        mapping.setParentElement((Object)layoutRootPart);
        mapping.setProperty(DIAGRAM_EDIT_PART, (Object)ElkDiagramLayoutConnector.getDiagramEditPart((EditPart)layoutRootPart));
        if (layoutRootPart instanceof ShapeNodeEditPart) {
            topNode = this.createNode(mapping, (ShapeNodeEditPart)layoutRootPart, null, null, null);
        } else {
            topNode = ElkGraphUtil.createGraph();
            Rectangle rootBounds = layoutRootPart.getFigure().getBounds();
            if (layoutRootPart instanceof DiagramEditPart) {
                String labelText = ((DiagramEditPart)layoutRootPart).getDiagramView().getName();
                if (labelText.length() > 0) {
                    ElkLabel label = ElkGraphUtil.createLabel((ElkGraphElement)topNode);
                    label.setText(labelText);
                }
            } else {
                topNode.setLocation((double)rootBounds.x, (double)rootBounds.y);
            }
            topNode.setDimensions((double)rootBounds.width, (double)rootBounds.height);
            mapping.getGraphMap().put((Object)topNode, (Object)layoutRootPart);
        }
        this.configureGlobalOptions(layoutRootPart, topNode);
        mapping.setLayoutGraph(topNode);
        if (selection != null && !selection.isEmpty()) {
            double minx = 2.147483647E9;
            double miny = 2.147483647E9;
            Maybe kinsets = new Maybe();
            for (ShapeNodeEditPart editPart : selection) {
                ElkNode node = this.createNode(mapping, editPart, layoutRootPart, topNode, (Maybe<ElkPadding>)kinsets);
                minx = Math.min(minx, node.getX());
                miny = Math.min(miny, node.getY());
                this.buildLayoutGraphRecursively(mapping, (IGraphicalEditPart)editPart, node, (IGraphicalEditPart)editPart);
            }
            mapping.setProperty(COORDINATE_OFFSET, (Object)new KVector(minx, miny));
        } else {
            this.buildLayoutGraphRecursively(mapping, layoutRootPart, topNode, layoutRootPart);
        }
        this.processConnections(mapping);
        return mapping;
    }

    private void configureGlobalOptions(IGraphicalEditPart layoutRootPart, ElkNode topNode) {
        EditPartQuery editPartQuery = new EditPartQuery(layoutRootPart);
        DiagramDescription diagramDescription = editPartQuery.getDiagramDescription();
        if (diagramDescription != null) {
            CustomLayoutConfiguration layout = (CustomLayoutConfiguration)diagramDescription.getLayout();
            topNode.setProperty(CoreOptions.ALGORITHM, (Object)layout.getId().trim());
            EList layoutOptions = layout.getLayoutOptions();
            for (LayoutOption layoutOption : layoutOptions) {
                LayoutOptionData layoutProperty = LayoutMetaDataService.getInstance().getOptionData(layoutOption.getId());
                switch (layoutOption.eClass().getClassifierID()) {
                    case 24: {
                        EnumLayoutOption enumOption = (EnumLayoutOption)layoutOption;
                        int enumValueCount = layoutProperty.getEnumValueCount();
                        Enum elkEnum = null;
                        int i = 0;
                        while (i < enumValueCount && elkEnum == null) {
                            layoutProperty.getEnumValue(i);
                            Enum enumValue = layoutProperty.getEnumValue(i);
                            if (enumOption.getValue().getName().equals(enumValue.name())) {
                                elkEnum = enumValue;
                            }
                            ++i;
                        }
                        topNode.setProperty((IProperty)layoutProperty, elkEnum);
                        break;
                    }
                    case 25: {
                        int i;
                        EnumSetLayoutOption enumSetOption = (EnumSetLayoutOption)layoutOption;
                        int enumValueCount = layoutProperty.getEnumValueCount();
                        if (enumValueCount <= 0) break;
                        EnumSet<Object> enumSet = EnumSet.noneOf(layoutProperty.getEnumValue(0).getDeclaringClass());
                        EList values = enumSetOption.getValues();
                        block10: for (EnumLayoutValue enumLayoutValue : values) {
                            i = 0;
                            while (i < enumValueCount) {
                                Enum enumValue = layoutProperty.getEnumValue(i);
                                if (enumLayoutValue.getName().equals(enumValue.name())) {
                                    enumSet = this.of(enumValue, enumSet);
                                    continue block10;
                                }
                                ++i;
                            }
                        }
                        topNode.setProperty((IProperty)layoutProperty, enumSet);
                        break;
                    }
                    case 20: {
                        BooleanLayoutOption booleanOption = (BooleanLayoutOption)layoutOption;
                        topNode.setProperty((IProperty)layoutProperty, (Object)booleanOption.isValue());
                        break;
                    }
                    case 22: {
                        IntegerLayoutOption integerOption = (IntegerLayoutOption)layoutOption;
                        topNode.setProperty((IProperty)layoutProperty, (Object)integerOption.getValue());
                        break;
                    }
                    case 23: {
                        DoubleLayoutOption doubleOption = (DoubleLayoutOption)layoutOption;
                        topNode.setProperty((IProperty)layoutProperty, (Object)doubleOption.getValue());
                        break;
                    }
                    case 21: {
                        StringLayoutOption stringOption = (StringLayoutOption)layoutOption;
                        topNode.setProperty((IProperty)layoutProperty, (Object)stringOption.getValue().trim());
                        break;
                    }
                }
            }
        }
    }

    public void transferLayout(LayoutMapping mapping) {
        DiagramEditPart diagramEditPart;
        ApplyLayoutRequest applyLayoutRequest = new ApplyLayoutRequest();
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            if (entry.getValue() instanceof DiagramEditPart) continue;
            ElkGraphElement graphElement = (ElkGraphElement)entry.getKey();
            IGraphicalEditPart part = (IGraphicalEditPart)entry.getValue();
            applyLayoutRequest.addElement(graphElement, (GraphicalEditPart)part);
        }
        ElkNode layoutGraph = mapping.getLayoutGraph();
        applyLayoutRequest.setUpperBound(layoutGraph.getWidth(), layoutGraph.getHeight());
        KVector offset = (KVector)mapping.getProperty(COORDINATE_OFFSET);
        if (offset != null) {
            ElkDiagramLayoutConnector.addOffset(mapping.getLayoutGraph(), offset);
        }
        if (((InternalTransactionalEditingDomain)(diagramEditPart = (DiagramEditPart)mapping.getProperty(DIAGRAM_EDIT_PART)).getEditingDomain()).getChangeRecorder() != null) {
            Command applyLayoutCommand = diagramEditPart.getCommand((Request)applyLayoutRequest);
            mapping.setProperty(LAYOUT_COMMAND, (Object)applyLayoutCommand);
        }
    }

    protected static void addOffset(ElkNode parentNode, KVector offset) {
        double minx = 2.147483647E9;
        double miny = 2.147483647E9;
        for (ElkNode child : parentNode.getChildren()) {
            minx = Math.min(minx, child.getX());
            miny = Math.min(miny, child.getY());
        }
        offset.add(-minx, -miny);
        ElkUtil.translate((ElkNode)parentNode, (double)offset.x, (double)offset.y);
    }

    public Command getApplyCommand(LayoutMapping mapping) {
        Command applyLayoutCommand = (Command)mapping.getProperty(LAYOUT_COMMAND);
        return applyLayoutCommand;
    }

    protected void buildLayoutGraphRecursively(LayoutMapping mapping, IGraphicalEditPart parentEditPart, ElkNode parentLayoutNode, IGraphicalEditPart currentEditPart) {
        Maybe kinsets = new Maybe();
        for (Object obj : currentEditPart.getChildren()) {
            ElkLabel newNodeLabel;
            IFigure figure;
            if (obj instanceof IGraphicalEditPart && !(figure = ((IGraphicalEditPart)obj).getFigure()).isVisible()) continue;
            if (obj instanceof AbstractBorderItemEditPart) {
                AbstractBorderItemEditPart borderItem = (AbstractBorderItemEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)borderItem)) continue;
                this.createPort(mapping, borderItem, parentEditPart, parentLayoutNode);
                continue;
            }
            if (obj instanceof ResizableCompartmentEditPart && ((CompartmentEditPart)obj).getChildren().size() > 0) {
                CompartmentEditPart compartment = (CompartmentEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)compartment)) continue;
                boolean compExp = true;
                IFigure compartmentFigure = compartment.getFigure();
                if (compartmentFigure instanceof ResizableCompartmentFigure) {
                    ResizableCompartmentFigure resizCompFigure = (ResizableCompartmentFigure)compartmentFigure;
                    compExp = resizCompFigure.isExpanded();
                }
                if (!compExp) continue;
                this.buildLayoutGraphRecursively(mapping, parentEditPart, parentLayoutNode, (IGraphicalEditPart)compartment);
                continue;
            }
            if (obj instanceof ShapeNodeEditPart) {
                ShapeNodeEditPart childNodeEditPart = (ShapeNodeEditPart)obj;
                if (!this.editPartFilter.filter((EditPart)childNodeEditPart)) continue;
                ElkNode node = this.createNode(mapping, childNodeEditPart, parentEditPart, parentLayoutNode, (Maybe<ElkPadding>)kinsets);
                this.buildLayoutGraphRecursively(mapping, (IGraphicalEditPart)childNodeEditPart, node, (IGraphicalEditPart)childNodeEditPart);
                continue;
            }
            if (!(obj instanceof IGraphicalEditPart) || (newNodeLabel = this.createNodeLabel(mapping, (IGraphicalEditPart)obj, parentEditPart, parentLayoutNode)) == null) continue;
            parentLayoutNode.getLabels().add((Object)newNodeLabel);
        }
    }

    protected ElkNode createNode(LayoutMapping mapping, ShapeNodeEditPart nodeEditPart, IGraphicalEditPart parentEditPart, ElkNode parentElkNode, Maybe<ElkPadding> elkinsets) {
        IFigure nodeFigure = nodeEditPart.getFigure();
        ElkNode childLayoutNode = ElkGraphUtil.createNode((ElkNode)parentElkNode);
        Rectangle childBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeFigure);
        Rectangle containerBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeFigure.getParent());
        childLayoutNode.setX((double)(childBounds.x - containerBounds.x));
        childLayoutNode.setY((double)(childBounds.y - containerBounds.y));
        childLayoutNode.setDimensions((double)childBounds.width, (double)childBounds.height);
        try {
            Dimension minSize = nodeFigure.getMinimumSize();
            childLayoutNode.setProperty(CoreOptions.NODE_SIZE_MINIMUM, (Object)new KVector((double)minSize.width, (double)minSize.height));
        }
        catch (SWTException sWTException) {}
        if (parentElkNode != null) {
            if (elkinsets.get() == null) {
                Insets insets = this.calcSpecificInsets(parentEditPart.getFigure(), nodeFigure);
                ElkPadding ei = new ElkPadding((double)insets.top, (double)insets.right, (double)insets.bottom, (double)insets.left);
                childLayoutNode.setProperty(CoreOptions.PADDING, (Object)ei);
                elkinsets.set((Object)ei);
            }
            parentElkNode.getChildren().add((Object)childLayoutNode);
        }
        mapping.getGraphMap().put((Object)childLayoutNode, (Object)nodeEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)nodeEditPart);
        return childLayoutNode;
    }

    protected Insets calcSpecificInsets(IFigure parent, IFigure child) {
        Insets result = new Insets(0);
        IFigure currentChild = child;
        IFigure currentParent = child.getParent();
        Point coordsToAdd = null;
        boolean isRelative = false;
        while (currentChild != parent && currentParent != null) {
            if (currentParent.isCoordinateSystem()) {
                isRelative = true;
                result.add(currentParent.getInsets());
                if (coordsToAdd != null) {
                    result.left += coordsToAdd.x;
                    result.top += coordsToAdd.y;
                }
                coordsToAdd = currentParent.getBounds().getLocation();
            } else if (currentParent == parent && coordsToAdd != null) {
                Point parentCoords = parent.getBounds().getLocation();
                result.left += coordsToAdd.x - parentCoords.x;
                result.top += coordsToAdd.y - parentCoords.y;
            }
            currentChild = currentParent;
            currentParent = currentChild.getParent();
        }
        if (!isRelative) {
            Rectangle parentBounds = parent.getBounds();
            currentParent = child.getParent();
            Rectangle containerBounds = currentParent.getBounds();
            result.left = containerBounds.x - parentBounds.x;
            result.top = containerBounds.y - parentBounds.y;
        }
        result.right = result.left;
        result.bottom = result.left;
        return result;
    }

    protected ElkPort createPort(LayoutMapping mapping, AbstractBorderItemEditPart portEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode) {
        ElkPort port = ElkGraphUtil.createPort((ElkNode)elknode);
        Rectangle portBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(portEditPart.getFigure());
        Rectangle nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
        double xpos = portBounds.x - nodeBounds.x;
        double ypos = portBounds.y - nodeBounds.y;
        port.setLocation(xpos, ypos);
        port.setDimensions((double)portBounds.width, (double)portBounds.height);
        mapping.getGraphMap().put((Object)port, (Object)portEditPart);
        this.addConnections(mapping, (IGraphicalEditPart)portEditPart);
        for (Object portChildObj : portEditPart.getChildren()) {
            if (!(portChildObj instanceof IGraphicalEditPart)) continue;
            IFigure labelFigure = ((IGraphicalEditPart)portChildObj).getFigure();
            String text = null;
            if (labelFigure instanceof WrappingLabel) {
                text = ((WrappingLabel)labelFigure).getText();
            } else if (labelFigure instanceof Label) {
                text = ((Label)labelFigure).getText();
            }
            if (text == null) continue;
            ElkLabel portLabel = ElkGraphUtil.createLabel((ElkGraphElement)port);
            portLabel.setText(text);
            mapping.getGraphMap().put((Object)portLabel, portChildObj);
            Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            portLabel.setLocation((double)(labelBounds.x - portBounds.x), (double)(labelBounds.y - portBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                portLabel.setDimensions((double)size.width, (double)size.height);
            }
            catch (SWTException sWTException) {}
        }
        return port;
    }

    protected ElkLabel createNodeLabel(LayoutMapping mapping, IGraphicalEditPart labelEditPart, IGraphicalEditPart nodeEditPart, ElkNode elknode) {
        Label label;
        IFigure labelFigure = labelEditPart.getFigure();
        String text = null;
        Font font = null;
        if (labelFigure instanceof WrappingLabel) {
            WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
            text = wrappingLabel.getText();
            font = wrappingLabel.getFont();
        } else if (labelFigure instanceof Label) {
            label = (Label)labelFigure;
            text = label.getText();
            font = label.getFont();
        } else if (labelFigure instanceof SiriusWrapLabel) {
            label = (SiriusWrapLabel)labelFigure;
            text = label.getText();
            font = label.getFont();
        }
        if (text != null) {
            label = ElkGraphUtil.createLabel((ElkGraphElement)elknode);
            label.setText(text);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
            Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            Rectangle nodeBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(nodeEditPart.getFigure());
            label.setLocation((double)(labelBounds.x - nodeBounds.x), (double)(labelBounds.y - nodeBounds.y));
            try {
                Dimension size = labelFigure.getPreferredSize();
                label.setDimensions((double)size.width, (double)size.height);
                if (font != null && !font.isDisposed()) {
                    label.setProperty(CoreOptions.FONT_NAME, (Object)font.getFontData()[0].getName());
                    label.setProperty(CoreOptions.FONT_SIZE, (Object)font.getFontData()[0].getHeight());
                }
            }
            catch (SWTException sWTException) {}
            return label;
        }
        return null;
    }

    protected void addConnections(LayoutMapping mapping, IGraphicalEditPart editPart) {
        for (Object targetConn : editPart.getTargetConnections()) {
            ConnectionEditPart connectionEditPart;
            if (!(targetConn instanceof ConnectionEditPart) || !this.editPartFilter.filter((EditPart)(connectionEditPart = (ConnectionEditPart)targetConn))) continue;
            ((List)mapping.getProperty(CONNECTIONS)).add(connectionEditPart);
            this.addConnections(mapping, (IGraphicalEditPart)connectionEditPart);
        }
    }

    protected void processConnections(LayoutMapping mapping) {
        HashMap<EReference, ElkEdge> reference2EdgeMap = new HashMap<EReference, ElkEdge>();
        for (ConnectionEditPart connection : (List)mapping.getProperty(CONNECTIONS)) {
            ElkGraphElement targetElem;
            ElkGraphElement sourceElem;
            ElkEdge edge;
            boolean isOppositeEdge = false;
            EdgeLabelPlacement edgeLabelPlacement = EdgeLabelPlacement.UNDEFINED;
            EObject modelObject = connection.getNotationView().getElement();
            if (modelObject instanceof EReference) {
                EReference reference = (EReference)modelObject;
                edge = (ElkEdge)reference2EdgeMap.get(reference.getEOpposite());
                if (edge != null) {
                    edgeLabelPlacement = EdgeLabelPlacement.TAIL;
                    isOppositeEdge = true;
                } else {
                    edge = ElkGraphUtil.createEdge(null);
                    reference2EdgeMap.put(reference, edge);
                }
            } else {
                edge = ElkGraphUtil.createEdge(null);
            }
            BiMap inverseGraphMap = mapping.getGraphMap().inverse();
            EditPart sourceObj = connection.getSource();
            if (sourceObj instanceof ConnectionEditPart) {
                sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getSource());
                if (sourceElem == null) {
                    sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)sourceObj).getTarget());
                }
            } else {
                sourceElem = (ElkGraphElement)inverseGraphMap.get((Object)sourceObj);
            }
            ElkNode sourceShape = null;
            ElkPort sourcePort = null;
            ElkNode sourceNode = null;
            if (sourceElem instanceof ElkNode) {
                sourceShape = sourceNode = (ElkNode)sourceElem;
            } else {
                if (!(sourceElem instanceof ElkPort)) continue;
                sourcePort = (ElkPort)sourceElem;
                sourceNode = sourcePort.getParent();
                sourceShape = sourcePort;
            }
            EditPart targetObj = connection.getTarget();
            if (targetObj instanceof ConnectionEditPart) {
                targetElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getTarget());
                if (targetElem == null) {
                    targetElem = (ElkGraphElement)inverseGraphMap.get((Object)((ConnectionEditPart)targetObj).getSource());
                }
            } else {
                targetElem = (ElkGraphElement)inverseGraphMap.get((Object)targetObj);
            }
            ElkNode targetShape = null;
            ElkNode targetNode = null;
            ElkPort targetPort = null;
            if (targetElem instanceof ElkNode) {
                targetShape = targetNode = (ElkNode)targetElem;
            } else {
                if (!(targetElem instanceof ElkPort)) continue;
                targetPort = (ElkPort)targetElem;
                targetNode = targetPort.getParent();
                targetShape = targetPort;
            }
            ElkNode edgeContainment = ElkGraphUtil.findLowestCommonAncestor((ElkNode)sourceNode, (ElkNode)targetNode);
            KVector offset = new KVector();
            ElkUtil.toAbsolute((KVector)offset, (ElkNode)edgeContainment);
            if (!isOppositeEdge) {
                edge.getSources().add((Object)sourceShape);
                edge.getTargets().add((Object)targetShape);
                edgeContainment.getContainedEdges().add((Object)edge);
                mapping.getGraphMap().put((Object)edge, (Object)connection);
                this.setEdgeLayout(edge, connection, offset);
            }
            this.processEdgeLabels(mapping, connection, edge, edgeLabelPlacement, offset);
        }
    }

    protected void setEdgeLayout(ElkEdge edge, ConnectionEditPart connection, KVector offset) {
        Connection figure = connection.getConnectionFigure();
        PointList pointList = figure.getPoints();
        ElkEdgeSection edgeSection = ElkGraphUtil.createEdgeSection((ElkEdge)edge);
        Point firstPoint = pointList.getPoint(0);
        edgeSection.setStartX((double)firstPoint.x - offset.x);
        edgeSection.setStartY((double)firstPoint.y - offset.y);
        int i = 1;
        while (i < pointList.size() - 1) {
            Point point = pointList.getPoint(i);
            ElkGraphUtil.createBendPoint((ElkEdgeSection)edgeSection, (double)((double)point.x - offset.x), (double)((double)point.y - offset.y));
            ++i;
        }
        Point lastPoint = pointList.getPoint(pointList.size() - 1);
        edgeSection.setEndX((double)lastPoint.x - offset.x);
        edgeSection.setEndY((double)lastPoint.y - offset.y);
    }

    protected void processEdgeLabels(LayoutMapping mapping, ConnectionEditPart connection, ElkEdge edge, EdgeLabelPlacement placement, KVector offset) {
        for (Object obj : connection.getChildren()) {
            Label label;
            LabelEditPart labelEditPart;
            IFigure labelFigure;
            if (!(obj instanceof LabelEditPart) || (labelFigure = (labelEditPart = (LabelEditPart)obj).getFigure()) == null || !labelFigure.isVisible()) continue;
            Rectangle labelBounds = ElkDiagramLayoutConnector.getAbsoluteBounds(labelFigure);
            String labelText = null;
            Dimension iconBounds = null;
            if (labelFigure instanceof WrappingLabel) {
                WrappingLabel wrappingLabel = (WrappingLabel)labelFigure;
                labelText = wrappingLabel.getText();
                if (wrappingLabel.getIcon() != null) {
                    iconBounds = new Dimension();
                    iconBounds.width = wrappingLabel.getIcon().getBounds().width + wrappingLabel.getIconTextGap();
                    iconBounds.height = wrappingLabel.getIcon().getBounds().height;
                    labelText = "O " + labelText;
                }
            } else if (labelFigure instanceof Label) {
                label = (Label)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.width += label.getIconTextGap();
                    labelText = "O " + labelText;
                }
            } else if (labelFigure instanceof SiriusWrapLabel) {
                label = (SiriusWrapLabel)labelFigure;
                labelText = label.getText();
                if (label.getIcon() != null) {
                    iconBounds = label.getIconBounds().getSize();
                    iconBounds.width += label.getIconTextGap();
                    labelText = "O " + labelText;
                }
            }
            if (labelText != null && labelText.length() > 0) {
                label = ElkGraphUtil.createLabel((ElkGraphElement)edge);
                if (placement == EdgeLabelPlacement.UNDEFINED) {
                    switch (labelEditPart.getKeyPoint()) {
                        case 2: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.HEAD);
                            break;
                        }
                        case 4: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
                            break;
                        }
                        case 3: {
                            label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.TAIL);
                        }
                    }
                } else {
                    label.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)placement);
                }
                Font font = labelFigure.getFont();
                if (font != null && !font.isDisposed()) {
                    label.setProperty(CoreOptions.FONT_NAME, (Object)font.getFontData()[0].getName());
                    label.setProperty(CoreOptions.FONT_SIZE, (Object)font.getFontData()[0].getHeight());
                }
                label.setLocation((double)labelBounds.x - offset.x, (double)labelBounds.y - offset.y);
                if (iconBounds != null) {
                    label.setWidth((double)(labelBounds.width + iconBounds.width));
                } else {
                    label.setWidth((double)labelBounds.width);
                }
                label.setHeight((double)labelBounds.height);
                label.setText(labelText);
                mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
                continue;
            }
            label = ElkGraphUtil.createLabel(null);
            mapping.getGraphMap().put((Object)label, (Object)labelEditPart);
        }
    }

    public void layout(LayoutMapping layoutMapping) {
        BasicProgressMonitor basicProgressMonitor = new BasicProgressMonitor(0, ElkServicePlugin.getInstance().getPreferenceStore().getBoolean(PREF_EXEC_TIME_MEASUREMENT));
        this.graphLayoutEngine.layout(layoutMapping.getLayoutGraph(), basicProgressMonitor.subTask(1.0f));
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
    }
}

