/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.internal.ui.rulers.RulerEditPart;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.SiriusRulerEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.InsertBlankSpaceGuide;
import org.eclipse.swt.graphics.Cursor;

public class SiriusRulerDragTracker
extends SimpleDragTracker {
    protected RulerEditPart source;
    private int startLocation;
    private int startLocationForFeedback;
    private int endLocation;
    private InsertBlankSpaceGuide blankSpaceGuide;

    public SiriusRulerDragTracker(RulerEditPart source) {
        this.source = source;
    }

    protected Command getCommand() {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (this.startLocation == 0 && this.endLocation == 0 || this.startLocation != 0 && this.endLocation >= this.startLocation) {
            result = this.source.isHorizontal() ? ((SiriusRulerEditPart)this.source).createInsertHorizontalBlankSpaceCommand(this.startLocation, this.endLocation - this.startLocation) : ((SiriusRulerEditPart)this.source).createInsertVerticalBlankSpaceCommand(this.startLocation, this.endLocation - this.startLocation);
        }
        return result;
    }

    protected boolean handleButtonDown(int button) {
        this.startLocation = this.getCurrentPosition();
        this.startLocationForFeedback = this.getCurrentPositionZoomed();
        return super.handleButtonDown(button);
    }

    protected boolean handleDragInProgress() {
        this.endLocation = this.getCurrentPosition();
        return super.handleDragInProgress();
    }

    protected boolean handleButtonUp(int button) {
        boolean result = super.handleButtonUp(button);
        this.startLocation = 0;
        this.startLocationForFeedback = 0;
        this.endLocation = 0;
        return result;
    }

    protected Cursor calculateCursor() {
        if (this.getCommand().canExecute()) {
            return this.source.isHorizontal() ? SharedCursors.SIZEWE : SharedCursors.SIZENS;
        }
        return SharedCursors.NO;
    }

    protected void showSourceFeedback() {
        if (this.blankSpaceGuide == null) {
            this.blankSpaceGuide = new InsertBlankSpaceGuide(ColorConstants.blue, !this.source.isHorizontal());
            this.getFeedbackLayer().add((IFigure)this.blankSpaceGuide);
        }
        Rectangle bounds = this.getFeedbackLayer().getBounds().getCopy();
        if (this.source.isHorizontal()) {
            bounds.x = this.startLocationForFeedback;
            bounds.width = this.getCurrentPositionZoomed() - this.startLocationForFeedback;
        } else {
            bounds.y = this.startLocationForFeedback;
            bounds.height = this.getCurrentPositionZoomed() - this.startLocationForFeedback;
        }
        this.blankSpaceGuide.setBounds(bounds);
    }

    protected void eraseSourceFeedback() {
        if (this.blankSpaceGuide != null) {
            this.getFeedbackLayer().remove((IFigure)this.blankSpaceGuide);
            this.blankSpaceGuide = null;
        }
    }

    protected IFigure getFeedbackLayer() {
        return ((SiriusRulerEditPart)this.source).getFeedbackLayer();
    }

    protected int getCurrentPositionZoomed() {
        Point pt = this.getLocation();
        this.source.getFigure().translateToRelative((Translatable)pt);
        int position = this.source.isHorizontal() ? pt.x : pt.y;
        return position;
    }

    protected int getCurrentPosition() {
        int position = this.getCurrentPositionZoomed();
        ZoomManager zoomManager = this.source.getZoomManager();
        if (zoomManager != null) {
            position = (int)Math.round((double)position / zoomManager.getZoom());
        }
        return position;
    }

    protected String getCommandName() {
        return Messages.InsertBlankSpace_cmdName;
    }
}

