/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ruler;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.SnapToGeometryEx;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractBorderedDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SnapChangeBoundsRequest;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SnapBendpointRequest;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SiriusSnapToGeometry
extends SnapToGeometryEx {
    boolean snapToAll;

    public SiriusSnapToGeometry(GraphicalEditPart container) {
        super(container);
    }

    public int snapRectangle(Request request, int snapOrientation, PrecisionRectangle baseRect, PrecisionRectangle result) {
        Object snapToAllExtendedData = request.getExtendedData().get("snapToAllShape");
        boolean oldSnapToAll = this.snapToAll;
        boolean bl = this.snapToAll = snapToAllExtendedData != null && (Boolean)snapToAllExtendedData != false;
        if (!this.snapToAll) {
            if (request instanceof SnapChangeBoundsRequest) {
                this.snapToAll = ((SnapChangeBoundsRequest)request).isSnapToAllShape();
            } else if (request instanceof SnapBendpointRequest) {
                this.snapToAll = ((SnapBendpointRequest)request).isSnapToAllShape();
            }
        }
        if (oldSnapToAll != this.snapToAll) {
            this.rows = null;
            this.cols = null;
        }
        return super.snapRectangle(request, snapOrientation, baseRect, result);
    }

    protected List generateSnapPartsList(List exclusions) {
        if (!this.snapToAll) {
            ArrayList children = Lists.newArrayList((Iterable)this.container.getChildren());
            Iterables.addAll((Collection)children, (Iterable)Iterables.filter((Iterable)this.container.getParent().getChildren(), AbstractDiagramBorderNodeEditPart.class));
            children.removeAll(exclusions);
            Iterable filteredChildren = Iterables.filter((Iterable)children, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(IStyleEditPart.class)));
            ArrayList<GraphicalEditPart> hiddenChildren = new ArrayList<GraphicalEditPart>();
            for (GraphicalEditPart child : filteredChildren) {
                if (child.getFigure().isVisible()) continue;
                hiddenChildren.add(child);
            }
            Iterables.removeAll((Iterable)filteredChildren, hiddenChildren);
            return Lists.newArrayList((Iterable)filteredChildren);
        }
        ArrayList<Class> expectedClasses = new ArrayList<Class>();
        expectedClasses.add(AbstractBorderedDiagramElementEditPart.class);
        expectedClasses.add(AbstractDiagramBorderNodeEditPart.class);
        ArrayList snapPartsList = Lists.newArrayList((Iterable)new org.eclipse.sirius.ext.gef.query.EditPartQuery((EditPart)this.container.getRoot()).getAllChildren(false, expectedClasses));
        ArrayList<EditPart> exclusionsWithChildren = new ArrayList<EditPart>();
        for (Object editPart : exclusions) {
            if (!(editPart instanceof EditPart)) continue;
            exclusionsWithChildren.add((EditPart)editPart);
            exclusionsWithChildren.addAll(new org.eclipse.sirius.ext.gef.query.EditPartQuery((EditPart)editPart).getAllChildren(false, expectedClasses));
        }
        snapPartsList.removeAll(exclusionsWithChildren);
        Iterator iter = snapPartsList.iterator();
        while (iter.hasNext()) {
            EditPart snapPart = (EditPart)iter.next();
            if (!(snapPart instanceof IGraphicalEditPart) || new EditPartQuery((IGraphicalEditPart)snapPart).isVisibleOnViewport()) continue;
            iter.remove();
        }
        return snapPartsList;
    }

    protected void populateRowsAndCols(List parts) {
        int nbOfBorderNodes = Iterables.size((Iterable)Iterables.filter((Iterable)parts, AbstractDiagramBorderNodeEditPart.class));
        this.rows = new SnapToGeometry.Entry[(parts.size() - nbOfBorderNodes) * 3 + nbOfBorderNodes];
        this.cols = new SnapToGeometry.Entry[(parts.size() - nbOfBorderNodes) * 3 + nbOfBorderNodes];
        int currentIndex = 0;
        int i = 0;
        while (i < parts.size()) {
            Rectangle bounds;
            IGraphicalEditPart child = (IGraphicalEditPart)parts.get(i);
            if (!this.snapToAll) {
                if (child instanceof AbstractDiagramBorderNodeEditPart) {
                    bounds = GraphicalHelper.getAbsoluteBounds((IGraphicalEditPart)child);
                    this.makeRelative(this.container.getContentPane(), (Translatable)bounds);
                } else {
                    bounds = this.getFigureBounds((GraphicalEditPart)child);
                }
            } else {
                bounds = GraphicalHelper.getAbsoluteBounds((IGraphicalEditPart)child);
                this.makeRelative(this.container.getContentPane(), (Translatable)bounds);
            }
            if (!(child instanceof AbstractDiagramBorderNodeEditPart)) {
                this.cols[currentIndex] = new SiriusEntry(-1, bounds.x);
                this.rows[currentIndex++] = new SiriusEntry(-1, bounds.y);
            }
            this.cols[currentIndex] = new SiriusEntry(0, bounds.x + (bounds.width - 1) / 2);
            this.rows[currentIndex++] = new SiriusEntry(0, bounds.y + (bounds.height - 1) / 2);
            if (!(child instanceof AbstractDiagramBorderNodeEditPart)) {
                this.cols[currentIndex] = new SiriusEntry(1, bounds.right() - 1);
                this.rows[currentIndex++] = new SiriusEntry(1, bounds.bottom() - 1);
            }
            ++i;
        }
    }

    class SiriusEntry
    extends SnapToGeometry.Entry {
        protected SiriusEntry(int type, int location) {
            super(type, location);
        }
    }
}

