/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.tools.internal.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.editor.properties.api.DefaultWidgetDescription;
import org.eclipse.sirius.editor.properties.api.IDefaultWidgetDescriptionFactory;
import org.eclipse.sirius.editor.properties.internal.Messages;
import org.eclipse.sirius.editor.properties.internal.SiriusEditorPropertiesPlugin;
import org.eclipse.sirius.editor.properties.tools.internal.menu.CreateWidgetForAllFeaturesAction;
import org.eclipse.sirius.editor.properties.tools.internal.menu.CreateWidgetForAllFeaturesDescriptor;
import org.eclipse.sirius.editor.properties.tools.internal.menu.CreateWidgetForFeatureAction;
import org.eclipse.sirius.editor.properties.tools.internal.menu.CreateWidgetForFeatureDescriptor;
import org.eclipse.sirius.editor.properties.tools.internal.menu.PropertiesMenuBuilderConstants;
import org.eclipse.sirius.editor.tools.api.menu.AbstractMenuBuilder;
import org.eclipse.sirius.properties.ContainerDescription;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.WidgetDescription;
import org.eclipse.sirius.properties.core.internal.EditSupportSpec;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.ui.IEditorPart;

public class CreateWidgetFromDomainClassMenuBuilder
extends AbstractMenuBuilder {
    private static final Pattern SEPARATOR = Pattern.compile("(::?|\\.)");

    public String getLabel() {
        return Messages.CreateWidgetFromDomainClassMenuBuilder_label;
    }

    public int getPriority() {
        return PropertiesMenuBuilderConstants.WIDGETS_FROM_DOMAIN_CLASS;
    }

    protected boolean isMine(CommandParameter object) {
        return false;
    }

    public void update(Collection<?> newChildDescriptors, ISelection selection, IEditorPart editor) {
        this.depopulate();
        this.advancedChildActions = this.generateDomainClassWidgetsActions(selection, editor);
    }

    private Collection<CreateChildAction> generateDomainClassWidgetsActions(ISelection selection, IEditorPart editor) {
        ArrayList<CreateChildAction> actions = new ArrayList<CreateChildAction>();
        Optional<EObject> optionalControlsContainerDescription = this.getControlsContainerDescription(selection);
        optionalControlsContainerDescription.ifPresent(controlsContainerDescription -> {
            List<EPackage> ePackages = this.getEPackages((EObject)controlsContainerDescription);
            String domainClassQualifiedName = this.getDomainClassQualifiedName((EObject)controlsContainerDescription);
            Optional<EClass> optionalDomainClass = this.getDomainClass(ePackages, domainClassQualifiedName);
            optionalDomainClass.ifPresent(domainClass -> {
                actions.add(new CreateWidgetForAllFeaturesAction(editor, selection, new CreateWidgetForAllFeaturesDescriptor((EObject)controlsContainerDescription, (EClass)domainClass)));
                actions.addAll(this.addActionsForStructuralFeatures(selection, editor, (EObject)controlsContainerDescription, (EClass)domainClass));
            });
        });
        return actions;
    }

    private List<CreateWidgetForFeatureAction> addActionsForStructuralFeatures(ISelection selection, IEditorPart editor, EObject controlsContainerDescription, EClass domainClass) {
        ArrayList<CreateWidgetForFeatureAction> actions = new ArrayList<CreateWidgetForFeatureAction>();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        domainClass.getEAllStructuralFeatures().stream().filter(EditSupportSpec::shouldAppearInPropertySheet).forEach(eStructuralFeature -> {
            List<IDefaultWidgetDescriptionFactory> factories = SiriusEditorPropertiesPlugin.getPlugin().getDefaultWidgetDescriptionFactory(domainClass, (EStructuralFeature)eStructuralFeature);
            for (IDefaultWidgetDescriptionFactory factory : factories) {
                DefaultWidgetDescription defaultWidgetDescription = factory.create(domainClass, (EStructuralFeature)eStructuralFeature);
                ImageDescriptor imageDescriptor = this.getCreateWidgetActionImageDescriptor((AdapterFactory)adapterFactory, defaultWidgetDescription.getWidgetDescription());
                CreateWidgetForFeatureDescriptor descriptor = new CreateWidgetForFeatureDescriptor(controlsContainerDescription, domainClass, imageDescriptor, defaultWidgetDescription);
                CreateWidgetForFeatureAction action = new CreateWidgetForFeatureAction(editor, selection, descriptor);
                actions.add(action);
            }
        });
        adapterFactory.dispose();
        return actions;
    }

    private ImageDescriptor getCreateWidgetActionImageDescriptor(AdapterFactory adapterFactory, WidgetDescription widgetDescription) {
        ImageDescriptor imageDescriptor = null;
        Adapter adapter = adapterFactory.adapt((Notifier)widgetDescription, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            imageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(((IItemLabelProvider)adapter).getImage((Object)widgetDescription));
        }
        return imageDescriptor;
    }

    private Optional<EObject> getControlsContainerDescription(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return Arrays.stream(structuredSelection.toArray()).filter(object -> object instanceof GroupDescription || object instanceof ContainerDescription).map(EObject.class::cast).findFirst();
        }
        return Optional.empty();
    }

    private List<EPackage> getEPackages(EObject controlsContainerDescription) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        EObject eContainer = controlsContainerDescription.eContainer();
        while (eContainer != null && !(eContainer instanceof ViewExtensionDescription) && !(eContainer instanceof RepresentationDescription)) {
            eContainer = eContainer.eContainer();
        }
        if (eContainer instanceof ViewExtensionDescription) {
            ePackages.addAll((Collection<EPackage>)((ViewExtensionDescription)eContainer).getMetamodels());
        } else if (eContainer instanceof RepresentationDescription) {
            ePackages.addAll((Collection<EPackage>)((RepresentationDescription)eContainer).getMetamodel());
        }
        return ePackages;
    }

    private String getDomainClassQualifiedName(EObject controlsContainerDescription) {
        String domainClassQualifiedName = "";
        if (controlsContainerDescription instanceof GroupDescription) {
            domainClassQualifiedName = ((GroupDescription)controlsContainerDescription).getDomainClass();
        } else if (controlsContainerDescription instanceof ContainerDescription) {
            EObject eContainer = controlsContainerDescription.eContainer();
            while (eContainer != null && !(eContainer instanceof GroupDescription)) {
                eContainer = eContainer.eContainer();
            }
            if (eContainer instanceof GroupDescription) {
                domainClassQualifiedName = ((GroupDescription)eContainer).getDomainClass();
            }
        }
        return domainClassQualifiedName;
    }

    private Optional<EClass> getDomainClass(List<EPackage> metamodels, String domainClassQualifiedName) {
        Optional<EClass> optionalDomainClass = Optional.empty();
        String packageName = null;
        String className = null;
        if (!StringUtil.isEmpty((String)domainClassQualifiedName)) {
            Matcher m = SEPARATOR.matcher(domainClassQualifiedName);
            if (m.find()) {
                packageName = domainClassQualifiedName.substring(0, m.start());
                className = domainClassQualifiedName.substring(m.end());
            } else {
                className = domainClassQualifiedName;
            }
        }
        for (EPackage ePackage : metamodels) {
            EClassifier classifier;
            if (packageName != null && ePackage.getName().equals(packageName) && (classifier = ePackage.getEClassifier(className)) instanceof EClass) {
                optionalDomainClass = Optional.of((EClass)classifier);
                break;
            }
            Optional<EClass> optionalClazz = this.getDomainClass((List<EPackage>)ePackage.getESubpackages(), domainClassQualifiedName);
            if (!optionalClazz.isPresent()) continue;
            optionalDomainClass = optionalClazz;
            break;
        }
        return optionalDomainClass;
    }
}

