/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.SessionCookieConfig;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.sirius.server.api.ISiriusServerConfigurator;
import org.eclipse.sirius.server.backend.internal.SiriusServerBackendFilter;
import org.eclipse.sirius.server.backend.internal.SiriusServerErrorHandler;

public class SiriusServerBackendConfigurator
implements ISiriusServerConfigurator {
    private static final String ALLOWED_METHODS = "org.eclipse.sirius.server.cors.allowed.methods";
    private static final String ALLOWED_HEADERS = "org.eclipse.sirius.server.cors.allowed.headers";
    private static final String ALLOWED_ORIGINS = "org.eclipse.sirius.server.cors.allowed.origins";
    private static final String ALLOW_CORS = "org.eclipse.sirius.server.cors.enabled";
    private static final String CONTEXT_PATH = "/api";

    public void configure(Server server) {
        ServletContextHandler servletContextHandler = new ServletContextHandler(5);
        servletContextHandler.setContextPath(CONTEXT_PATH);
        servletContextHandler.setErrorHandler((ErrorHandler)new SiriusServerErrorHandler());
        SessionCookieConfig sessionCookieConfig = servletContextHandler.getServletContext().getSessionCookieConfig();
        sessionCookieConfig.setHttpOnly(true);
        boolean allowCors = Boolean.parseBoolean(System.getProperty(ALLOW_CORS));
        if (allowCors) {
            String allowedMethods;
            String allowedHeaders;
            FilterHolder cors = new FilterHolder();
            String allowedOrigins = System.getProperty(ALLOWED_ORIGINS);
            if (allowedOrigins != null) {
                cors.setInitParameter("allowedOrigins", allowedOrigins);
            }
            if ((allowedHeaders = System.getProperty(ALLOWED_HEADERS)) != null) {
                cors.setInitParameter("allowedHeaders", allowedHeaders);
            }
            if ((allowedMethods = System.getProperty(ALLOWED_METHODS)) != null) {
                cors.setInitParameter("allowedMethods", allowedMethods);
            }
            cors.setFilter((Filter)new CrossOriginFilter());
            servletContextHandler.addFilter(cors, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC, DispatcherType.INCLUDE));
        }
        servletContextHandler.addFilter(SiriusServerBackendFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.INCLUDE));
        Handler handler = server.getHandler();
        if (handler instanceof HandlerCollection) {
            HandlerCollection handlerCollection = (HandlerCollection)handler;
            handlerCollection.addHandler((Handler)servletContextHandler);
        }
    }
}

