/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.services.dashboard;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.server.backend.internal.ISiriusServerService;
import org.eclipse.sirius.server.backend.internal.SiriusServerPath;
import org.eclipse.sirius.server.backend.internal.SiriusServerResponse;
import org.eclipse.sirius.server.backend.internal.services.dashboard.SiriusServerDashboardDto;
import org.eclipse.sirius.server.backend.internal.services.dashboard.SiriusServerDashboardProjectDto;
import org.eclipse.sirius.server.backend.internal.utils.SiriusServerUtils;

@SiriusServerPath(value="/dashboard")
public class SiriusServerDashboardService
implements ISiriusServerService {
    private static final int DASHBOARD_PROJECT_COUNT = 7;

    @Override
    public SiriusServerResponse doGet(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return new SiriusServerResponse(200, this.getDashboard());
    }

    private SiriusServerDashboardDto getDashboard() {
        int projectsCount = Long.valueOf(this.getModelingProjects().count()).intValue();
        int viewpointsCount = ViewpointRegistry.getInstance().getViewpoints().size();
        int metamodelsCount = EPackage.Registry.INSTANCE.size();
        List<SiriusServerDashboardProjectDto> projects = this.getModelingProjects().limit(7L).map(this::convertToProject).collect(Collectors.toList());
        return new SiriusServerDashboardDto(projectsCount, viewpointsCount, metamodelsCount, projects);
    }

    private Stream<IProject> getModelingProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return Arrays.stream(allProjects).filter(ModelingProject::hasModelingProjectNature).filter(IProject::isOpen);
    }

    private SiriusServerDashboardProjectDto convertToProject(IProject iProject) {
        String name = iProject.getName();
        String description = SiriusServerUtils.getProjectDescription(iProject);
        return new SiriusServerDashboardProjectDto(name, description);
    }
}

