/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.internal;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Optional;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.sirius.server.internal.Messages;
import org.eclipse.sirius.server.internal.SiriusServerPlugin;

public class SiriusServerManager {
    private static final String PORT_VMARG = "SIRIUS_SERVER_PORT";
    private static final String HOSTNAME = "localhost";
    private static final String PORT = "0";
    private Server server;

    public void start() {
        if (this.server == null || !this.server.isRunning()) {
            int port = Integer.valueOf(System.getProperty(PORT_VMARG, PORT));
            InetSocketAddress address = new InetSocketAddress(HOSTNAME, port);
            this.server = new Server(address);
            this.server.setHandler((Handler)new HandlerCollection());
            SiriusServerPlugin.getPlugin().getSiriusServerConfigurators().forEach(configurator -> configurator.configure(this.server));
            try {
                this.server.start();
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.sirius.server", Messages.SiriusServerManager_cannotStartServer, (Throwable)exception);
                SiriusServerPlugin.getPlugin().log(status);
            }
        }
    }

    public void stop() {
        Optional.ofNullable(this.server).ifPresent(s -> {
            try {
                s.stop();
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.sirius.server", Messages.SiriusServerManager_cannotStopServer, (Throwable)exception);
                SiriusServerPlugin.getPlugin().log(status);
            }
        });
    }

    public URI getURI() {
        return this.server.getURI();
    }
}

