/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.internal.helper;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ModelInitializer {
    private final Scope scope;
    private final Predicate<EClass> isInstanciable = new Predicate<EClass>(){

        public boolean apply(EClass input) {
            return !input.isAbstract() && !input.isInterface();
        }
    };
    private final Multimap<EReference, EClass> refToCandidatesMap = HashMultimap.create();

    public ModelInitializer(Scope scope) {
        this.scope = scope;
    }

    public void linkElements(List<EObject> acc) {
        for (EObject current : acc) {
            for (EReference ref : current.eClass().getEAllReferences()) {
                boolean safeSettable;
                boolean containmentTouch = ref.isContainment() || ref.isContainer();
                boolean bl = safeSettable = !ref.isDerived() && !ref.isUnsettable() && ref.getEOpposite() == null;
                if (containmentTouch || !safeSettable || current.eIsSet((EStructuralFeature)ref)) continue;
                boolean selfValue = false;
                EObject possibleValue = null;
                for (EObject potentialValue : acc) {
                    if (!ref.getEReferenceType().isSuperTypeOf(potentialValue.eClass())) continue;
                    if (potentialValue == current) {
                        selfValue = true;
                        continue;
                    }
                    possibleValue = potentialValue;
                    break;
                }
                if (possibleValue != null) {
                    current.eSet((EStructuralFeature)ref, ref.isMany() ? Collections.singletonList(possibleValue) : possibleValue);
                    continue;
                }
                if (!selfValue) continue;
                current.eSet((EStructuralFeature)ref, (Object)(ref.isMany() ? Collections.singletonList(current) : current));
            }
        }
    }

    public List<EObject> initializeContents(EObject root) {
        Preconditions.checkNotNull((Object)root);
        this.refToCandidatesMap.clear();
        ArrayList<EObject> created = new ArrayList<EObject>();
        this.initializeContents(root, created);
        return created;
    }

    private void initializeContents(EObject element, List<EObject> acc) {
        for (EReference ref : element.eClass().getEAllReferences()) {
            if (!ref.isContainment() || !this.needsInitialization(element, ref)) continue;
            this.initializeContents(element, ref, acc);
        }
    }

    private void initializeContents(EObject root, EReference ref, List<EObject> acc) {
        Set<EClass> candidates = this.findCompatibleCandidates(root, ref);
        LinkedHashSet instanciableCandidates = Sets.newLinkedHashSet((Iterable)Iterables.filter(candidates, this.isInstanciable));
        final Collection refToCandidates = this.refToCandidatesMap.get((Object)ref);
        Predicate<EClass> newCreationType = new Predicate<EClass>(){

            public boolean apply(EClass input) {
                return !refToCandidates.contains(input);
            }
        };
        LinkedHashSet neverCreatedCandidates = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)instanciableCandidates, (Predicate)newCreationType));
        this.initializeContents(root, ref, neverCreatedCandidates, acc);
    }

    private void initializeContents(EObject element, EReference ref, Set<EClass> instanciableCandidates, List<EObject> acc) {
        List<Object> instances = Lists.newArrayListWithCapacity((int)instanciableCandidates.size());
        for (EClass klass : instanciableCandidates) {
            EObject instance = klass.getEPackage().getEFactoryInstance().create(klass);
            instances.add(instance);
        }
        if (instances.isEmpty()) {
            return;
        }
        if (ref.isMany()) {
            acc.addAll(instances);
            this.refToCandidatesMap.putAll((Object)ref, instanciableCandidates);
            element.eSet((EStructuralFeature)ref, (Object)instances);
        } else {
            EObject instance = (EObject)instances.iterator().next();
            if (instances.size() != 1) {
                instance = this.multiCandidateSingleRef(element, ref, instances);
            }
            if (instance != null) {
                this.refToCandidatesMap.put((Object)ref, (Object)instance.eClass());
                element.eSet((EStructuralFeature)ref, (Object)instance);
                acc.add(instance);
                instances = Collections.singletonList(instance);
            } else {
                instances.clear();
            }
        }
        for (EObject instance : instances) {
            this.customizeCreatedElement(instance);
            this.initializeContents(instance, acc);
        }
    }

    protected boolean needsInitialization(EObject element, EReference containmentRef) {
        return containmentRef.isContainment() && containmentRef.isRequired() && !element.eIsSet((EStructuralFeature)containmentRef);
    }

    protected EObject multiCandidateSingleRef(EObject element, EReference ref, Collection<EObject> instances) {
        return null;
    }

    protected void customizeCreatedElement(EObject createdElement) {
    }

    protected Set<EClass> findCompatibleCandidates(EObject container, EReference containmentReference) {
        LinkedHashSet<EClass> candidates = new LinkedHashSet<EClass>();
        for (EPackage pkg : this.scope.getScope()) {
            candidates.addAll(this.findCompatibleCandidates(container, containmentReference, pkg));
        }
        candidates.removeAll(this.scope.getEclassesToAvoid());
        return candidates;
    }

    protected Collection<? extends EClass> findCompatibleCandidates(EObject container, EReference reference, EPackage currentScope) {
        EClass type = reference.getEReferenceType();
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EClass klass : Iterables.filter((Iterable)currentScope.getEClassifiers(), EClass.class)) {
            boolean isCompatible;
            boolean bl = isCompatible = klass.equals(type) || klass.getEAllSuperTypes().contains((Object)type);
            if (!isCompatible) continue;
            result.add(klass);
        }
        return result;
    }

    public static class Scope {
        private final Set<EPackage> scope = new LinkedHashSet<EPackage>();
        private final Set<EClass> eclassesToAvoid = new HashSet<EClass>();

        public Scope(Collection<? extends EPackage> packages, Collection<EClass> doNotIns) {
            this.scope.addAll((Collection)Preconditions.checkNotNull(packages));
            this.eclassesToAvoid.addAll((Collection)Preconditions.checkNotNull(doNotIns));
        }

        public Scope(Collection<? extends EPackage> packages) {
            this.scope.addAll((Collection)Preconditions.checkNotNull(packages));
        }

        public Set<EClass> getEclassesToAvoid() {
            return this.eclassesToAvoid;
        }

        public Set<EPackage> getScope() {
            return this.scope;
        }
    }
}

