/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.workflow.ui.page;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.server.internal.SiriusServerPlugin;
import org.eclipse.sirius.ui.editor.api.pages.AbstractSessionEditorPage;
import org.eclipse.sirius.ui.editor.api.pages.PageProviderRegistry;
import org.eclipse.sirius.ui.editor.api.pages.PageUpdateCommandBuilder;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.workflow.ui.page.Messages;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WorkflowPage
extends AbstractSessionEditorPage {
    private final Session session;
    private Browser browser;
    private SessionManagerListenerForBrowserRefresh sessionManagerListenerForBrowserRefresh;

    public WorkflowPage(Session s) {
        super(s.getID(), Messages.WorkflowPage_tab_name);
        this.session = Objects.requireNonNull(s);
        this.sessionManagerListenerForBrowserRefresh = new SessionManagerListenerForBrowserRefresh();
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this.sessionManagerListenerForBrowserRefresh);
    }

    public void dispose() {
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this.sessionManagerListenerForBrowserRefresh);
        super.dispose();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(MessageFormat.format(Messages.WorkflowPage_header_title, this.session.getID()));
        toolkit.decorateFormHeading(scrolledForm.getForm());
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite subBody = toolkit.createComposite(body);
        subBody.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(0, 0).create());
        subBody.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser = new Browser(subBody, 4);
        GridData browserGridData = new GridData(4, 4, true, true);
        browserGridData.widthHint = 0;
        browserGridData.heightHint = 0;
        this.browser.setLayoutData((Object)browserGridData);
        this.browser.setUrl(this.getRootURL(this.session));
    }

    private String getRootURL(Session session) {
        URI uri = session.getSessionResource().getURI();
        if (uri.isPlatformResource()) {
            java.net.URI serverUri = SiriusServerPlugin.getPlugin().getServerURI();
            return String.format("http://%s:%d/projects/%s?fullscreen=true", serverUri.getHost(), serverUri.getPort(), uri.segment(1));
        }
        return "http://localhost:8080/";
    }

    public Optional<String> getLocationId() {
        return Optional.of("org.eclipse.sirius.ui.editor.DefaultSessionEditorPage");
    }

    public Optional<PageProviderRegistry.PositioningKind> getPositioning() {
        return Optional.of(PageProviderRegistry.PositioningKind.AFTER);
    }

    public Optional<PageUpdateCommandBuilder.PageUpdateCommand> pageChanged(boolean isVisible) {
        return Optional.empty();
    }

    public Optional<PageUpdateCommandBuilder.PageUpdateCommand> resourceSetChanged(ResourceSetChangeEvent resourceSetChangeEvent) {
        return Optional.empty();
    }

    private final class SessionManagerListenerForBrowserRefresh
    implements SessionManagerListener {
        private SessionManagerListenerForBrowserRefresh() {
        }

        public void notifyAddSession(Session newSession) {
        }

        public void notifyRemoveSession(Session removedSession) {
        }

        public void viewpointSelected(Viewpoint selectedSirius) {
        }

        public void viewpointDeselected(Viewpoint deselectedSirius) {
        }

        public void notify(Session updated, int notification) {
            switch (notification) {
                case 0: 
                case 5: 
                case 10: 
                case 11: 
                case 16: {
                    Display.getDefault().asyncExec(() -> {
                        if (WorkflowPage.this.browser != null && !WorkflowPage.this.browser.isDisposed()) {
                            WorkflowPage.this.browser.refresh();
                        }
                    });
                    break;
                }
            }
        }
    }
}

