/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IJavaAwareInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.JavaExtensionsManager;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.internal.interpreter.IService;
import org.eclipse.sirius.common.tools.internal.interpreter.MonomorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.PolymorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.VariableInterpreter;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class ServiceInterpreter
extends VariableInterpreter
implements IJavaAwareInterpreter,
IInterpreter,
IInterpreterProvider {
    public static final String PREFIX = "service:";
    public static final String RECEIVER_SEPARATOR = ".";
    private static final String EOBJECT_CLASS_NAME = EObject.class.getCanonicalName();
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[(,)]");
    private final Map<Object, Object> properties = new HashMap<Object, Object>();
    private final Map<String, PolymorphicService> services = new HashMap<String, PolymorphicService>();
    private final Multimap<String, PolymorphicService> qualifiedNameToServices = HashMultimap.create();
    private final JavaExtensionsManager javaExtensions = JavaExtensionsManager.createManagerWithOverride();
    private final ClassLoadingCallback callback = new ClassLoadingCallback(){

        @Override
        public void unloaded(String qualifiedName, Class<?> clazz) {
            for (PolymorphicService service : ServiceInterpreter.this.qualifiedNameToServices.get((Object)qualifiedName)) {
                ServiceInterpreter.this.services.remove(service.getName());
            }
            ServiceInterpreter.this.qualifiedNameToServices.removeAll((Object)qualifiedName);
        }

        @Override
        public void notFound(String qualifiedName) {
            DslCommonPlugin.getDefault().warning(MessageFormat.format(Messages.ServiceInterpreter_javaClassNotFound, qualifiedName), new RuntimeException());
        }

        @Override
        public void loaded(String qualifiedName, Class<?> clazz) {
            ServiceInterpreter.this.registerServiceClass(qualifiedName, clazz);
        }
    };

    public ServiceInterpreter() {
        this.javaExtensions.addClassLoadingCallBack(this.callback);
    }

    public static Option<String> getReceiverVariableName(String expression) {
        int indexOfServiceName = expression.indexOf(RECEIVER_SEPARATOR);
        if (indexOfServiceName != -1) {
            String receiverVariableName = expression.substring(0, indexOfServiceName);
            return Options.newSome((Object)receiverVariableName);
        }
        return Options.newNone();
    }

    @Override
    public IInterpreter createInterpreter() {
        return new ServiceInterpreter();
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        this.javaExtensions.reloadIfNeeded();
        Object evaluation = null;
        if (target != null && expression != null && expression.startsWith(PREFIX)) {
            int indexOfParenthesis;
            String serviceCall = expression.substring(PREFIX.length()).trim();
            Option<String> receiverVariableName = ServiceInterpreter.getReceiverVariableName(serviceCall);
            EObject receiver = target;
            String serviceName = serviceCall;
            if (receiverVariableName.some()) {
                serviceCall = serviceCall.substring(((String)receiverVariableName.get()).length() + 1);
                Object objectReceiver = this.evaluateVariable(target, ((String)receiverVariableName.get()).trim());
                if (objectReceiver instanceof EObject) {
                    receiver = (EObject)objectReceiver;
                } else {
                    throw new EvaluationException(MessageFormat.format(Messages.ServiceInterpreter_invalidReceiver, serviceCall, objectReceiver != null ? objectReceiver.getClass().getName() : "null"));
                }
            }
            serviceName = serviceCall.substring(0, (indexOfParenthesis = serviceCall.indexOf("(")) == -1 ? serviceCall.length() : indexOfParenthesis);
            Object[] parameters = new Object[]{receiver};
            if (indexOfParenthesis != -1) {
                String[] values = SPLIT_PATTERN.split(serviceCall);
                parameters = new Object[values.length];
                parameters[0] = receiver;
                int i = 1;
                while (i < values.length) {
                    parameters[i] = this.evaluateVariable(target, values[i].trim());
                    ++i;
                }
            }
            evaluation = this.callService(parameters, serviceName);
        }
        return evaluation;
    }

    private Object callService(Object[] target, String serviceName) throws EvaluationException {
        if (this.services.containsKey(serviceName)) {
            IService service = this.services.get(serviceName);
            return service.call(target);
        }
        throw new EvaluationException(MessageFormat.format(Messages.ServiceInterpreter_unknownService, serviceName));
    }

    @Override
    public Collection<Method> getImplementation(String serviceCall) {
        this.javaExtensions.reloadIfNeeded();
        String serviceName = serviceCall;
        if (this.services.containsKey(serviceName)) {
            IService service = this.services.get(serviceName);
            return service.getImplementations();
        }
        return Collections.emptyList();
    }

    @Override
    public void addImport(String dependency) {
        this.javaExtensions.addImport(dependency);
    }

    private void registerServiceClass(String qualifiedName, Class<?> klass) {
        Object serviceInstance = null;
        try {
            serviceInstance = klass.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (serviceInstance == null) {
            return;
        }
        Method[] methodArray = klass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (ServiceInterpreter.isValidServiceMethod(m)) {
                this.registerService(qualifiedName, new MonomorphicService(serviceInstance, m));
            }
            ++n2;
        }
    }

    private void registerService(String qualifiedName, MonomorphicService service) {
        String name = service.getName();
        if (!this.services.containsKey(name)) {
            PolymorphicService newService = new PolymorphicService(name);
            this.services.put(name, newService);
            this.qualifiedNameToServices.put((Object)qualifiedName, (Object)newService);
        }
        this.services.get(name).addImplementer(service);
    }

    public static boolean isValidServiceMethod(Method m) {
        int mods = m.getModifiers();
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (!Modifier.isPublic(mods) || parameterTypes.length < 1) {
            return false;
        }
        boolean result = false;
        try {
            ClassLoader classLoader = m.getDeclaringClass().getClassLoader();
            if (classLoader != null) {
                Class<?> eobjectClass = classLoader.loadClass(EOBJECT_CLASS_NAME);
                result = eobjectClass.isAssignableFrom(parameterTypes[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            result = false;
        }
        return result;
    }

    @Override
    public Collection<String> getImports() {
        return this.javaExtensions.getImports();
    }

    @Override
    public void removeImport(String dependency) {
        this.javaExtensions.removeImport(dependency);
    }

    @Override
    public void clearImports() {
        this.javaExtensions.clearImports();
        this.services.clear();
        this.qualifiedNameToServices.clear();
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
        if ("files".equals(key)) {
            this.javaExtensions.updateScope((Collection)value);
        }
    }

    public Map<String, IService> getServices() {
        this.javaExtensions.reloadIfNeeded();
        return new HashMap<String, IService>(this.services);
    }

    @Override
    public boolean supportsValidation() {
        return false;
    }

    @Override
    public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
        return new ValidationResult();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.javaExtensions.removeClassLoadingCallBack(this.callback);
        this.javaExtensions.dispose();
    }
}

