/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.ui.autostart.internal;

import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SiriusServerStartup
implements IStartup {
    private static final String SIRIUS_SERVER_PLUGIN_ID = "org.eclipse.sirius.server";
    private static final String DESCRIPTION = "Starting Sirius Server";

    public void earlyStartup() {
        final Display display = Display.getDefault();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                SiriusServerStartup.this.closeIntro(workbench);
                IExtensionTracker extensionTracker = workbench.getExtensionTracker();
                if (extensionTracker == null || workbench.getWorkbenchWindowCount() == 0) {
                    display.timerExec(1000, (Runnable)this);
                } else {
                    Job job = SiriusServerStartup.this.getStartupJob();
                    job.setPriority(50);
                    job.schedule(1000L);
                }
            }
        };
        display.asyncExec(runnable);
    }

    private void closeIntro(IWorkbench workbench) {
        IIntroManager introManager = workbench.getIntroManager();
        boolean hasIntro = introManager.hasIntro();
        if (hasIntro) {
            Optional<IIntroPart> optionalIntroPart = Optional.ofNullable(introManager.getIntro());
            optionalIntroPart.ifPresent(introPart -> {
                boolean bl = introManager.closeIntro(introPart);
            });
        }
    }

    private Job getStartupJob() {
        Job job = Job.create((String)DESCRIPTION, monitor -> Display.getDefault().asyncExec(() -> {
            Bundle siriusServerBundle = Platform.getBundle((String)SIRIUS_SERVER_PLUGIN_ID);
            if (siriusServerBundle != null && siriusServerBundle.getState() != 32) {
                try {
                    siriusServerBundle.start(1);
                }
                catch (BundleException exception) {
                    exception.printStackTrace();
                }
            }
        }));
        return job;
    }
}

