/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation.resources;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;

public final class SiriusGraphQLCreateProjectField {
    private static final String CREATE_PROJECT_FIELD = "createProject";
    private static final String DESCRIPTION_ARG = "description";

    private SiriusGraphQLCreateProjectField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(CREATE_PROJECT_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("Project")).argument(SiriusGraphQLCreateProjectField.getProjectDescriptionArgument()).dataFetcher(SiriusGraphQLCreateProjectField.getCreateProjectDataFetcher()).build();
    }

    private static GraphQLArgument getProjectDescriptionArgument() {
        return GraphQLArgument.newArgument().name(DESCRIPTION_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("ProjectCreationDescription"))).build();
    }

    private static DataFetcher<IProject> getCreateProjectDataFetcher() {
        return environment -> Optional.of((Map)environment.getArgument(DESCRIPTION_ARG)).map(description -> {
            String name = (String)description.get("name");
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!iProject.exists()) {
                try {
                    IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(name);
                    projectDescription.setNatureIds(new String[]{"org.eclipse.sirius.nature.modelingproject"});
                    iProject.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
                    iProject.open((IProgressMonitor)new NullProgressMonitor());
                    URI representationsURI = URI.createPlatformResourceURI((String)iProject.getFullPath().append("representations.aird").toString(), (boolean)true);
                    DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, (IProgressMonitor)new NullProgressMonitor());
                    sessionCreationOperation.execute();
                    iProject.build(6, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException exception) {
                    Status status = new Status(4, "org.eclipse.sirius.services.graphql", exception.getMessage(), (Throwable)exception);
                    SiriusGraphQLPlugin.getPlugin().log(status);
                }
                return iProject;
            }
            return null;
        }).orElse(null);
    }
}

