/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation.resources;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.resources.SiriusGraphQLContainerPathArgument;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.resources.SiriusGraphQLFileCreationHelper;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.resources.SiriusGraphQLProjectNameArgument;

public final class SiriusGraphQLCreateSemanticFileField {
    private static final String CREATE_SEMANTIC_FILE_FIELD = "createSemanticFile";
    private static final String DESCRIPTION_ARG = "description";

    private SiriusGraphQLCreateSemanticFileField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(CREATE_SEMANTIC_FILE_FIELD).argument(SiriusGraphQLProjectNameArgument.build()).argument(SiriusGraphQLContainerPathArgument.build()).argument(SiriusGraphQLCreateSemanticFileField.getDescriptionArgument()).type((GraphQLOutputType)new GraphQLTypeReference("File")).dataFetcher(SiriusGraphQLCreateSemanticFileField.getCreateSemanticFileDataFetcher()).build();
    }

    private static GraphQLArgument getDescriptionArgument() {
        return GraphQLArgument.newArgument().name(DESCRIPTION_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("SemanticFileCreationDescription"))).build();
    }

    private static DataFetcher<IFile> getCreateSemanticFileDataFetcher() {
        return environment -> {
            Optional<IFile> optionalFile = SiriusGraphQLFileCreationHelper.getFile(environment);
            Optional<EClass> optionalEClass = SiriusGraphQLCreateSemanticFileField.getEClass(environment);
            if (optionalFile.isPresent() && optionalEClass.isPresent()) {
                IFile iFile = optionalFile.get();
                EClass eClass = optionalEClass.get();
                if (!iFile.exists()) {
                    try {
                        URI uri = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
                        Resource.Factory factory = SiriusGraphQLCreateSemanticFileField.getResourceFactory(uri);
                        Resource resource = factory.createResource(uri);
                        EObject eObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
                        resource.getContents().add((Object)eObject);
                        resource.save(new HashMap());
                    }
                    catch (IOException exception) {
                        Status status = new Status(4, "org.eclipse.sirius.services.graphql", exception.getMessage(), (Throwable)exception);
                        SiriusGraphQLPlugin.getPlugin().log(status);
                    }
                    return iFile;
                }
            }
            return null;
        };
    }

    private static Optional<EClass> getEClass(DataFetchingEnvironment environment) {
        Map description = (Map)environment.getArgument(DESCRIPTION_ARG);
        String ePackageNsUri = (String)description.get("ePackageNsURI");
        String eClassName = (String)description.get("eClassName");
        Optional<EPackage> optionalEPackage = Optional.ofNullable(EPackage.Registry.INSTANCE.getEPackage(ePackageNsUri));
        return optionalEPackage.map(ePackage -> ePackage.getEClassifier(eClassName)).filter(EClass.class::isInstance).map(EClass.class::cast);
    }

    private static Resource.Factory getResourceFactory(URI uri) {
        Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        Object object = extensionToFactoryMap.get(uri.fileExtension());
        if (object instanceof Resource.Factory) {
            return (Resource.Factory)object;
        }
        return new XMIResourceFactoryImpl();
    }
}

