/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation.resources;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.resources.SiriusGraphQLContainerPathArgument;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.resources.SiriusGraphQLFileCreationHelper;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.resources.SiriusGraphQLProjectNameArgument;

public final class SiriusGraphQLCreateTextFileField {
    private static final String CREATE_TEXT_FILE_FIELD = "createTextFile";
    private static final String DESCRIPTION_ARG = "description";

    private SiriusGraphQLCreateTextFileField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(CREATE_TEXT_FILE_FIELD).argument(SiriusGraphQLProjectNameArgument.build()).argument(SiriusGraphQLContainerPathArgument.build()).argument(SiriusGraphQLCreateTextFileField.getDescriptionArgument()).type((GraphQLOutputType)new GraphQLTypeReference("File")).dataFetcher(SiriusGraphQLCreateTextFileField.getCreateTextFileDataFetcher()).build();
    }

    private static GraphQLArgument getDescriptionArgument() {
        return GraphQLArgument.newArgument().name(DESCRIPTION_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference("TextFileCreationDescription"))).build();
    }

    private static DataFetcher<IFile> getCreateTextFileDataFetcher() {
        return environment -> {
            IFile iFile;
            Optional<IFile> optionalFile = SiriusGraphQLFileCreationHelper.getFile(environment);
            if (optionalFile.isPresent() && !(iFile = optionalFile.get()).exists()) {
                Map description = (Map)environment.getArgument(DESCRIPTION_ARG);
                String content = (String)description.get("content");
                try {
                    iFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException exception) {
                    Status status = new Status(4, "org.eclipse.sirius.services.graphql", exception.getMessage(), (Throwable)exception);
                    SiriusGraphQLPlugin.getPlugin().log(status);
                }
                return iFile;
            }
            return null;
        };
    }
}

